<?php

namespace App\Http\Controllers\Branch;

use App\Model\CashInOutModel;
use App\Model\CustomerModel;
use App\Model\SaleDetailsModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\CurrencyModel;
use App\Model\PaymentDetailModel;
use App\Model\WarehouseModel;
use App\Model\PaymentModel;
use App\Model\product\ColorModel;
use App\Model\product\SizeModel;
use Illuminate\Support\Facades\Session;
use DB;
use Auth;
use App\JournalModel;
use App\Model\ProductModel;
use App\Model\StockModel;
use App\Fun\Fun;
use App\Model\ProductUnitModel;
use App\Model\SaleModel;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class POSBranchController extends Controller
{
    function __construct()

    {
        $this->middleware('permission:POS Retail Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:POS Retail List', ['only' => ['show', 'index']]);
    }

    public function index(Request $request)
    {

        Fun::lang();
        if ($request->ajax()) {
            $date = $request->date;
            $customer = $request->customer;
            $status = $request->status;
            $count_total = SaleModel::where(['user_id' => Auth::user() != null ? Auth::user()->id : 0])
                ->where('sale_type', 'pos')
                ->where('status', 1)
                ->count();

            $data = SaleModel::where(['user_id' => Auth::user() != null ? Auth::user()->id : 0])
                ->where('sale_type', 'pos')
                ->where('status', 1)
                ->where(function ($q) use ($date) {
                    if ($date) {
                        $q->where('sale_date', date('Y-m-d', strtotime($date)));
                    }
                })
                ->where(function ($q) use ($customer) {
                    if ($customer) {
                        $q->where('customer_id', $customer);
                    }
                })
                ->where(function ($query) use ($status) {
                    if ($status) {
                        $query->where('nso007_sales.payment_status', $status);
                    }
                })
                ->orderBy('nso007_sales.id', 'DESC');
            $count_filter = $data->count();
            if ($request->ajax()) {
                return DataTables::of($data->take(20))
                    ->with([
                        "recordsTotal" => $count_total,
                        "recordsFiltered" => $count_filter,
                    ])
                    ->editColumn('customer_phone', function ($data) {
                        $customer = findCustomer($data->customer_id);
                        return $customer != null ? $customer->customer_phone : '';
                    })
                    ->editColumn('customer_id', function ($data) {
                        $customer = findCustomer($data->customer_id);
                        return $customer != null ? $customer->customer_name : '';
                    })
                    ->editColumn('paid_amount_kh', function ($data) {
                        $total = ($data->paid_amount_kh > 0 ? ($data->paid_amount_kh / $data->rate) : 0) + $data->paid_amount_usd;
                        return '$' . $total;
                    })
                    ->editColumn('total', function ($data) {
                        $price = generateGrandTotal($data);
                        $user_currency = user_currency();
                        return $user_currency->symbol . number_format($price, 2);
                    })
                    ->editColumn('payment_status', function ($data) {
                        $status = '';
                        if (strtolower($data->payment_status) == 'due') {
                            $status = '<span class="label label-danger">' . __('administrator.due') . '</span>';
                        }
                        if (strtolower($data->payment_status) == 'partial') {
                            $status = '<span class="label label-warning">' . __('administrator.partial') . '</span>';
                        }
                        if (strtolower($data->payment_status) == 'paid') {
                            $status = '<span class="label label-success">' . __('administrator.paid') . '</span>';
                        }
                        return $status;
                    })
                    ->editColumn('sale_date', function ($data) {
                        return date('d-m-Y', strtotime($data->sale_date));
                    })
                    ->editColumn('discount', function ($data) {
                        return $data->discount ? $data->discount . '%' : '';
                    })
                    ->addColumn('action', function ($data) {
                        $show_de = '<a href="' . route("pos-retail.show", $data->id) . '" title="' . __('administrator.show') . '" class="button_info display-none">' . __('administrator.show') . '</a>' .
                            '<a  class="btn bg-olive btn-flat margin show_invoice" data-id="' . $data->id . '">' . __('administrator.invoice') . '</a>';
                        if (Gate::check('POS Retail Show')) {
                            $show_de;
                        } else {
                            $show_de = '';
                        }
                        return $show_de;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action' => 'action', 'total' => 'total', 'customer_id' => 'customer_id', 'payment_status' => 'payment_status', 'customer_phone' => 'customer_phone',])
                    ->make(true);
            }
        }

        return view('pos.clothes-pos.index');

    }

    public function create(Request $request)
    {
        $warehouse_id = WarehouseModel::whereRaw('branch_id = ? && user_id != ?', [\Auth::user()->id, \Auth::id()])->first()->id;

        $stock_item = StockModel::where('warehouse_id', $warehouse_id)
                            ->join('nso007_product_unit', 'nso007_stocks.product_unit_id', 'nso007_product_unit.id')
                            ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                            ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                            ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
                            ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
                            ->groupBy('product_unit_id')
                            ->selectRaw('image, product_name, unit, name as color, size, nso007_product_unit.id')
                            ->paginate(1);
        if ($request->ajax()) {
            $html = view('pos.pos-wholesale.result-create', compact('stock_item'))->render();
            return response()->json(['html' => $html]);
        }
        return view('pos.clothes-pos.create', compact('stock_item'));







        // $stock_item = StockModel::where(['warehouse_id' => (getMainWarehouse() ? getMainWarehouse()->id : 0), 'type' => 'product'])
        //     ->where('stock_qty', '>', 0)
        //     ->paginate(20);
        // $customer = CustomerModel::where(['agent_id' => Auth::user()->id])->pluck('customer_name', 'id');
        // if ($request->ajax()) {
        //     $html = view('pos.clothes-pos.result-create', compact('stock_item'))->render();
        //     return response()->json(['html' => $html]);
        // }
        // return view('pos.clothes-pos.create', compact('stock_item', 'customer'));
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'product_unit.*' => 'required',
            'dis.*' => 'required',
            'qty.*' => 'required',
            'retail_price' => 'required',
            'qty' => 'required',
            'customer' => 'required',
            'date' => 'required',
        ]);
        $rate = getRate();
        $ratebaht = getRate(1);
        $paid_kh = $request->paid_kh ? $request->paid_kh : 0;
        $paid_usd = $request->paid_usd ? $request->paid_usd : 0;
        $paid_baht = $request->paid_baht ? $request->paid_baht : 0;
        $total_paid = (float)$paid_usd + ((float)$paid_kh > 0 ? ((float)$paid_kh / $rate) : 0) + ((float)$paid_baht > 0 ? ((float)$paid_baht / $ratebaht) : 0);
        $total = $request->g_total_usd_hidden;
        $amount_due = $total - $total_paid;
        //Insert to Sale
        if ($total_paid >= $total) {
            $payment_status = 'paid';
        } else {
            if ($total_paid > 0) {
                $payment_status = 'partial';
            } else {
                $payment_status = 'due';
            }
        }
        $inv = generate_inv('nso007_sales', 'POS' . Auth::user()->id);
        $date = date('Y-m-d', strtotime($request->date));
        $order = SaleModel::where('sale_date', $date)->count();
        $pos_clothes = new SaleModel();
        $pos_clothes->user_id = Auth::user()->id;
        $pos_clothes->is_role = Auth::user()->is_role;
        $pos_clothes->branch_id = Auth::user()->id;
        $pos_clothes->customer_id = $request->customer;
        $pos_clothes->payment_status = $payment_status;
        $pos_clothes->invoice_number = $inv;
        $pos_clothes->sale_date = $date;
        $pos_clothes->year = date('Y');
        $pos_clothes->rate = getRate();
        $pos_clothes->rate_baht = getRate(1);
        $pos_clothes->sale_type = 'pos';
        $pos_clothes->paid_amount_kh = $paid_kh;
        $pos_clothes->paid_amount_usd = $paid_usd;
        $pos_clothes->paid_amount_baht = $paid_baht;
        $pos_clothes->discount = $request->discount;
        $pos_clothes->warehouse_id = getMainWarehouse()->id;
        $pos_clothes->daily_order_number = $order + 1;
        $pos_clothes->save();
        $last_id_pos_clothes = $pos_clothes->id;


        $product_unit = $request->product_unit;
        $qty = $request->qty;
        $price = $request->retail_price;
        $discount = $request->dis;


        foreach ($product_unit as $key => $value) {
            //Insert to Purchase Details
            $pro_unit = ProductUnitModel::find($value);
            $pos_clothes_detail = array(
                'sale_id' => $last_id_pos_clothes,
                'currency_id' => user_currency()->id,
                'product_id' => $pro_unit->product_id,
                'qty' => $qty[$key],
                'sale_price' => $price[$key],
                'barcode' => $pro_unit->barcode,
                'size_id' => $pro_unit->size_id,
                'dis' => $discount[$key],
                'unit_id' => $pro_unit->unit_id,
                'created_at' => date('Y-m-d h:i:s'),
                'updated_at' => date('Y-m-d h:i:s'),
            );
            SaleDetailsModel::insert($pos_clothes_detail);

            //Insert to Stock
            $qty_per_unit = $qty[$key];
            $stock = StockModel::updateOrCreate(array(
                'product_id' => $pro_unit->product_id,
                'color_id' => $pro_unit->color_id,
                'size_id' => $pro_unit->size_id,
                'warehouse_id' => getMainWarehouse()->id
            ));
            $stock->stock_qty -= $qty_per_unit;
            $stock->save();
        }

        $payment = new PaymentModel();
        $payment->user_id = Auth::user()->id;
        $payment->payment_invoice = $inv;
        $payment->invoice_id = $last_id_pos_clothes;
        $payment->payment_date = date('Y-m-d');
        $payment->payment_amount = $total;
        $payment->paid_amount = $total_paid;
        $payment->payment_status = $payment_status;
        $payment->customer_id = $request->customer;
        $payment->year = date('Y');
        $payment->status = 1;
        $payment->type = 'pos';
        $payment->save();

        $payment_detail = array(
            'payment_id' => $payment->id,
            'paid_amount' => $total_paid,
            'payment_date' => date('Y-m-d', strtotime($request->date)),
            'status' => 1,
        );
        if($total_paid>0){
            $cash_in_out = new CashInOutModel();
            $cash_in_out->branch_id = Auth::user()->id;
            $cash_in_out->type = 'pos';
            $cash_in_out->cash_type = 'cash_in';
            $cash_in_out->year = date('Y');
            $cash_in_out->user_id = Auth::user()->id;
            $cash_in_out->date = $date;
            $cash_in_out->invoice_id = $last_id_pos_clothes;
            $cash_in_out->invoice_number = $pos_clothes->invoice_number;
            $cash_in_out->pay_to_receive_from = $pos_clothes->customer_id;
            $cash_in_out->amount = convert_amount_to_user_amount($total_paid, 2, $pos_clothes->rate, $pos_clothes->rate_baht);
            $cash_in_out->description = 'POS';
            $cash_in_out->note = '';
            $cash_in_out->rate=  getRate();
            $cash_in_out->rate_baht=  getRate(1);
            $cash_in_out->currency_id = user_currency()->id;
            $cash_in_out->save();
        }

        /* ====== Accounting ====== */

        if ($total_paid >= $total) {
            $j = JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
            $journal = new JournalModel;
            $journal->branch_id = 0;
            $journal->journal_parentid = 0;
            $journal->journal_type = 1;
            $journal->journal_acccode = 11001;
            $journal->voucher_type = 1;
            $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
            $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
            $journal->journal_debit = $total;
            $journal->journal_credit = 0;
            $journal->journal_tran_id = $j->last_num + 1;
            $journal->journal_transactiondate = date("Y-m-d");
            $journal->journal_paydate = date("Y-m-d");
            $journal->journal_currency = 1;
            $journal->transaction_type = 'POS Retail';
            $journal->journal_referenceid = $last_id_pos_clothes;
            $journal->journal_by = \Auth::id();
            $journal->save();

            $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

            $journal = new JournalModel;
            $journal->branch_id = 0;
            $journal->journal_parentid = $jj->last_id;
            $journal->journal_type = 1;
            $journal->journal_acccode = 11006;
            $journal->voucher_type = 1;
            $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
            $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
            $journal->journal_debit = 0;
            $journal->journal_credit = $total;
            $journal->journal_tran_id = $j->last_num + 1;
            $journal->journal_transactiondate = date("Y-m-d");
            $journal->journal_paydate = date("Y-m-d");
            $journal->journal_currency = 1;
            $journal->transaction_type = 'POS Retail';
            $journal->journal_referenceid = $last_id_pos_clothes;
            $journal->journal_by = \Auth::id();
            $journal->save();

        } else {
            if ($payment_status = 'partial') {
                $j = JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                $journal = new JournalModel;
                $journal->branch_id = 0;
                $journal->journal_parentid = 0;
                $journal->journal_type = 1;
                $journal->journal_acccode = 11001;
                $journal->voucher_type = 1;
                $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                $journal->journal_debit = $total_paid;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 1;
                $journal->transaction_type = 'POS Retail';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->save();

                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal = new JournalModel;
                $journal->branch_id = 0;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 1;
                $journal->journal_acccode = 11006;
                $journal->voucher_type = 1;
                $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $total;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 1;
                $journal->transaction_type = 'POS Retail';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->save();

                $jj1 = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal = new JournalModel;
                $journal->branch_id = 0;
                $journal->journal_parentid = $jj1->last_id;
                $journal->journal_type = 1;
                $journal->journal_acccode = 11003;
                $journal->voucher_type = 1;
                $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                $journal->journal_debit = $amount_due;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 1;
                $journal->transaction_type = 'POS Retail';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->save();
            } else {
                $j = JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                $journal = new JournalModel;
                $journal->branch_id = 0;
                $journal->journal_parentid = 0;
                $journal->journal_type = 1;
                $journal->journal_acccode = 11006;
                $journal->voucher_type = 1;
                $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $total;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 1;
                $journal->transaction_type = 'POS Retail';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->save();

                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal = new JournalModel;
                $journal->branch_id = 0;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 1;
                $journal->journal_acccode = 11003;
                $journal->voucher_type = 1;
                $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                $journal->journal_debit = $total;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 1;
                $journal->transaction_type = 'POS Retail';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->save();
            }

        }

        /* ====== End Account ====== */


        PaymentDetailModel::insert($payment_detail);
        session()->put('success', 'Record was added successfully');
        return response()->json(['sale_id' => $last_id_pos_clothes, 'status' => 'success']);

    }

    public static function generate_voucher_number($number_ref, $digit)
    {
        return str_pad($number_ref, $digit, "0", STR_PAD_LEFT);
    }

    public function autocomplete(Request $request)

    {
        $value = $request->barcode;
        $stock_item = StockModel::select('nso007_stocks.*')
            ->join('nso007_products', 'nso007_products.id', 'nso007_stocks.product_id')
            ->where(['nso007_stocks.warehouse_id' => (getMainWarehouse() ? getMainWarehouse()->id : 0), 'nso007_stocks.type' => 'product'])
            ->where('nso007_stocks.stock_qty', '>', 0)
            ->where(function ($q) use ($value) {
                $q->where('nso007_stocks.barcode', 'LIKE', '%' . $value . '%');
                $q->orwhere('nso007_products.product_name', 'LIKE', '%' . $value . '%');
            })
            ->paginate(20);
        $html = view('pos.clothes-pos.result-create', compact('stock_item'))->render();
        return response()->json(['html' => $html]);

    }

    public function scan_code(Request $request)

    {
        $std = new \stdClass();
        $value = $request->barcode;
        if ($value) {
            $stock_item = StockModel::select('nso007_stocks.*')
                ->where(['nso007_stocks.warehouse_id' => (getMainWarehouse() ? getMainWarehouse()->id : 0), 'nso007_stocks.type' => 'product'])
                ->where('nso007_stocks.stock_qty', '>', 0)
                ->where(function ($q) use ($value) {
                    $q->where('nso007_stocks.barcode', $value);
                })
                ->first();
            if ($stock_item) {
                $std->id = ProductUnitModel::where('barcode', $value)->first()->id;
                $std->name = getProductById($stock_item->product_id)->product_name;
                $std->stock = $stock_item->stock_qty;
                $std->size = findSize($stock_item->size_id)->size;
                $std->code = $stock_item->barcode;
                $std->price = ProductUnitModel::where('barcode', $stock_item->barcode)->first()->retail_price;
                $std->symbol = findProductCurrency($stock_item->product_id);
            }
        } else {
            $stock_item = null;
        }
        return response()->json(['data' => $std]);

    }
}

