<?php

namespace App\Http\Controllers\Branch;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\TypeOfIllness;
use Exception;
use Illuminate\Validation\ValidationException;
use Yajra\DataTables\Facades\DataTables;

class IllnessTypeController extends Controller
{

    public function index(Request $request)
    {
        $illness_type = TypeOfIllness::whereNull('deleted_at');

        if (isset($request->name_en))
            $illness_type = $illness_type->where('name_en', 'LIKE', '%' . $request->name_en . '%');
        if (isset($request->name_km))
            $illness_type = $illness_type->where('name_km', 'LIKE', '%' . $request->name_km . '%');
        if (isset($request->description))
            $illness_type = $illness_type->where('description', 'LIKE', '%' . $request->description . '%');


        if ($request->ajax()) {
            return DataTables::of($illness_type->latest()->take(20))
                ->with([
                    "recordsTotal" => $illness_type->count(),
                    "recordsFiltered" => $illness_type->count(),
                ])
                ->addIndexColumn()
                ->addColumn('action', function ($illness_type) {
                    $action = '';
                    if(FindBranchID()===$illness_type->branch_id){
                        $action .= '<a  class="btn btn-sm btn-warning btn-edit" data-href="' . route('illness-type.edit', $illness_type->id) . '">' . __('administrator.edit') . '</a>';
                        $action .= '&nbsp;<a class="btn btn-sm btn-danger btn-delete" data-href="'.route('illness-type.delete',$illness_type->id) . '">' . __('administrator.delete') . '</a>';
                    }
                    return $action;
                })
                ->rawColumns(['action'])
                ->make('true');
        }

        return view('branch.type_illness.index', compact('illness_type'));
    }

    public function create()
    {
        return view('branch.type_illness.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name_km' => 'unique:type_of_illnesses,name_km'.($request->name_en?'':'|required'),
            'name_en' => 'unique:type_of_illnesses,name_en'.($request->name_km?'':'|required'),
        ]);

        $illness_type = new TypeOfIllness();
        //check if is seller then no need to store branch_id
        $illness_type->branch_id = auth()->user()->is_role === 'Seller' ? null : auth()->user()->branch_id;
        // check if is seller then store use_id and if is branch or admin user then set null
        $illness_type->user_id = auth()->user()->is_role === 'Seller' ? auth()->user()->id : null;
        $illness_type->name_km = $request->name_km;
        $illness_type->name_en = $request->name_en;
        $illness_type->description = $request->description;
        if ($illness_type->save()) {
            $illness_type->data_type='ill';
            if($request->in_lead=="1"){
                return response()->json($illness_type);
            }else{
                return response()->json(['status' => 'ok','reload'=>1]);
            }
        }
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $illness_type = TypeOfIllness::find($id);
        return view('branch.type_illness.edit',compact('illness_type'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name_km' => 'unique:type_of_illnesses,name_km,'.$id.($request->name_en?'':'|required'),
            'name_en' => 'unique:type_of_illnesses,name_en,'.$id.($request->name_km?'':'|required'),
        ]);

        $illness_type = TypeOfIllness::find($id);
        $illness_type->name_km = $request->name_km;
        $illness_type->name_en = $request->name_en;
        $illness_type->description = $request->description;

        if ($illness_type->update()) {
            return response()->json(['status' => 'ok','reload'=>1]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, Request $request)
    {
        try {
            TypeOfIllness::find($id)->delete();

            if ($request->ajax())
                return response()->json(['status' => 200, 'message' => 'Illness type deleted.']);

        } catch (Exception $e) {
            if ($request->ajax())
                return response()->json(['status' => 500, 'message' => $e->getMessage()]);
        }
    }
}
