<?php

namespace App\Http\Controllers\Administrator\people;

use App\Model\people\TailorModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;

class TailorController extends Controller
{

    function __construct()
    {
       $this->middleware('permission:Tailor List', ['only' => ['index']]);
       $this->middleware('permission:Tailor Create', ['only' => [ 'create', 'store']]);
       $this->middleware('permission:Tailor Edit', ['only' => ['update','get_edit']]);
       
    }
    public function index()
    {
        $data=TailorModel::get();
        return view('administrator.people.tailor.index',compact('data'));
    }
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
            'phone'=>'required',
        ]);
        $tailor = new TailorModel();
        $tailor->user_id = Auth::user()->id;
        $tailor->phone = $request->phone;
        $tailor->outsource = $request->outsource?1:0;
        $tailor->name = $request->name;
        $tailor->note = $request->note;
        $tailor->address = $request->address;
        $tailor->save();
        session()->put('success','Tailor created successful');
        return response()->json('success');
    }
    public function get_edit($id)
    {
        $data = TailorModel::find($id);
        return response()->json($data);
    }
    public function update(Request $request)
    {
        $this->validate($request,[
            'phone'=>'required',
            'name'=>'required'
        ]);
        $tailor = TailorModel::find($request->id);
        $tailor->name = $request->name;
        $tailor->phone = $request->phone;
        $tailor->outsource = $request->outsource?1:0;
        $tailor->note = $request->note;
        $tailor->address = $request->address;
        $tailor->save();
        session()->put('success','Tailor update successful');
        return response()->json('success');
    }
}
