<?php

namespace App\Http\Controllers\Administrator\payment;

use App\Model\Accounting\AccountChartModel;
use App\Model\Accounting\JournalModel;
use App\Model\PurchaseModel;
use App\Model\SaleModel;
use Auth;
use App\Fun\Fun;
use App\Model\PaymentDetailModel;
use App\Model\PaymentModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;
use DB;

class PaymentController extends Controller
{
    function __construct()
    {
//        $this->middleware('permission:Sale Payment Show', ['only' => ['show']]);
//        $this->middleware('permission:Purchase Payment Show', ['only' => ['show']]);
//        $this->middleware('permission:Sale Payment Add Payment', ['only' => ['add_payment']]);
    }

    public function index(Request $request)
    {
        if ($request->nbpo != null) {
            session()->put('payment_type_in_payment', 'purchase');
        } else {
            session()->forget('payment_type_in_payment');
        }
        return view('administrator.payment.index');
    }

    public function getpayment(Request $request)
    {
        Fun::lang();
        if ($request->ajax()) {
            $value = $request->value;
            $ifPurchase = session()->get('payment_type_in_payment');
            if ($ifPurchase) {
                $customer_id = $request->supplier;
            } else {
                $customer_id = $request->customer;
            }
            $date = $request->date;
            $is_role = Auth::user()->is_role;
            $type = $request->type;
            $status = $request->status;

            $count_total = PaymentModel::
            where(['nso007_payment.user_id' => Auth::user()->id])
                ->where(function ($q) use ($ifPurchase) {
                    if ($ifPurchase) {
                        $q->where('nso007_payment.type', $ifPurchase);
                    } else {

                        $q->where('nso007_payment.type', '!=', 'purchase');
                    }
                })
                ->count();

            $data = PaymentModel::select('nso007_payment.updated_at');
            if ($ifPurchase) {
                $data->select('nso007_purchases.invoice_number', 'nso007_payment.id',
                    'nso007_payment.invoice_id', 'nso007_payment.customer_id', 'nso007_payment.supplier_id'
                    , 'nso007_payment.user_id', 'nso007_payment.payment_date'
                    , 'nso007_payment.payment_amount', 'nso007_payment.paid_amount',
                    'nso007_payment.payment_status', 'nso007_payment.type', 'nso007_payment.year', 'nso007_payment.status')
                    ->join('nso007_purchases', 'nso007_purchases.id', 'nso007_payment.invoice_id');
            } else {
                $data->select('nso007_sales.invoice_number', 'nso007_payment.invoice_id', 'nso007_payment.customer_id', 'nso007_payment.supplier_id', 'nso007_payment.id'
                    , 'nso007_payment.user_id', 'nso007_payment.payment_date'
                    , 'nso007_payment.payment_amount', 'nso007_payment.paid_amount',
                    'nso007_payment.payment_status', 'nso007_payment.type', 'nso007_payment.year', 'nso007_payment.status')
                    ->join('nso007_sales', 'nso007_sales.id', 'nso007_payment.invoice_id');
            }
            $data->where('nso007_payment.status', 1)
                ->where(function ($q) use ($ifPurchase) {
                    if ($ifPurchase) {
                        $q->where('nso007_payment.type', 'purchase');
                    } else {
                        $q->where('nso007_payment.type', 'wholesale');
                        $q->orwhere('nso007_payment.type', 'pos');

                    }
                })
                ->where(function ($q) use ($is_role) {
                    if ($is_role == 'out_shop') {
                        $q->where('nso007_payment.user_id', Auth::user()->id);
                    }
                })
                ->where(function ($q) use ($value, $ifPurchase) {
                    if ($value) {
                        if ($ifPurchase) {
                            $q->where('nso007_purchase.invoice_number', 'like', '%' . $value . '%');
                        } else {
                            $q->where('nso007_sales.invoice_number', 'like', '%' . $value . '%');
                        }
                    }
                })
                ->where(function ($q) use ($type) {
                    if ($type) {
                        $q->where('nso007_payment.type', $type);
                    }
                })
                ->where(function ($q) use ($date) {
                    if ($date) {
                        $q->where('nso007_payment.payment_date', date('Y-m-d', strtotime($date)));
                    }
                })
                ->where(function ($q) use ($customer_id, $ifPurchase) {
                    if ($customer_id) {
                        if ($ifPurchase) {
                            $q->where('nso007_payment.supplier_id', $customer_id);
                        } else {
                            $q->where('nso007_payment.customer_id', $customer_id);
                        }
                    }
                })
                ->where(function ($q) use ($status) {
                    if ($status) {
                        $q->where('nso007_payment.payment_status', $status);
                    }
                })
                ->orderBy('nso007_payment.created_at', 'DESC');
            $count_filter = $data->count();
            return DataTables::of($data->take(20))
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn('date', function ($data) {
                    return date('d-m-Y', strtotime($data->date));
                })
                ->editColumn('user_id', function ($data) {
                    return findUser($data->user_id)->name;
                })
                ->editColumn('type', function ($data) {
                    return __('administrator.' . $data->type);
                })
                ->addColumn('customer_phone', function ($data) {
                    $ifPurchase = session()->get('payment_type_in_payment');
                    if ($ifPurchase) {
                        return findSupplier($data->supplier_id)->supplier_phone;
                    } else {
                        if ($data->customer_id) {
                            return findCustomer($data->customer_id)->customer_phone;
                        }
                    }
                })
                ->addColumn('customer_name', function ($data) {
                    $ifPurchase = session()->get('payment_type_in_payment');
                    if ($ifPurchase) {
                        return findSupplier($data->supplier_id)->supplier_name;
                    } else {
                        if ($data->customer_id) {
                            return findCustomer($data->customer_id)->customer_name;
                        }

                    }
                })
                ->editColumn('payment_amount', function ($data) {
                    return '$' . number_format($data->payment_amount, 2);
                })
                ->editColumn('paid_amount', function ($data) {
                    return '$' . number_format($data->paid_amount, 2);
                })
                ->editColumn('payment_date', function ($data) {
                    return date('d-m-Y', strtotime($data->payment_date));
                })
                ->editColumn('remain', function ($data) {
                    return '$' . number_format($data->payment_amount - $data->paid_amount, 2);
                })
                ->editColumn('payment_status', function ($data) {
                    $bg = '';
                    if ($data->payment_status == 'due') {
                        $bg = 'danger';
                    }
                    if ($data->payment_status == 'partial') {
                        $bg = 'warning';
                    }
                    if ($data->payment_status == 'paid') {
                        $bg = 'success';
                    }
                    return '<span class="label label-' . $bg . '">' . __('administrator.' . $data->payment_status) . '</span>';
                })
                ->addColumn('action', function ($data) {
                    $ifPurchase = session()->get('payment_type_in_payment');
                    $pay = '';
                    if (strtolower($data->payment_status) != 'paid' && Auth::user()->user_type == 1) {
                        $pay .= ' <a  title="' . __('administrator.add_payment') . '" class="btn bg-olive btn-flat margin btn_add_payment"  data-id="' . $data->id . '">' . __('administrator.add_payment') . '</a>';
                    }
                    if (Gate::check('Sale Payment Show') && !$ifPurchase) {
                        $pay .= '<a href="' . route("payment.show", $data->id) . '" title="' . __('administrator.show') . '" class="button_info">' . __('administrator.show') . '</a>';
                    }

                    if (Gate::check('Purchase Payment Show') && $ifPurchase) {
                        $pay .= '<a href="' . route("payment.show", $data->id) . ($ifPurchase ? '?nbpo=tertfgd' : '') . '" title="' . __('administrator.show') . '" class="button_info">' . __('administrator.show') . '</a>';
                    }
                    return $pay;
                })
                ->addIndexColumn()
                ->rawColumns(['action' => 'action', 'payment_status' => 'payment_status', 'customer_id' => 'customer_id', 'customer_phone' => 'customer_phone', 'remain' => 'remain',])
                ->make(true);
        }
    }

    public function show($id)
    {
        $master = PaymentModel::find($id);
        $detail = PaymentDetailModel::where('payment_id', $id)->get();
        return view('administrator.payment.show', compact('master', 'detail'));
    }

    public static function generate_voucher_number($number_ref, $digit)
    {
        return str_pad($number_ref, $digit, "0", STR_PAD_LEFT);
    }

    public function edit($id)
    {
        $payment = PaymentModel::find($id);
        if($payment->type==="purchase"){
            $invoice = PurchaseModel::find($payment->invoice_id);
        }else{
            $invoice = SaleModel::find($payment->invoice_id);
        }
        $acc_chart = AccountChartModel::whereIn('id',['11001','11002'])->pluck((if_kh() ? 'acc_namekh' : 'acc_name'), 'id');
        return view('administrator.payment.edit',compact('payment','invoice','acc_chart'));
    }
    public function update(Request $request,$id)
    {
        $this->validate($request, [
            'amount' => 'required|numeric',
            'payment_method' => 'required',
            'date' => 'required',
        ]);
        $payment = PaymentModel::find($id);
        $punish = $payment->payment_amount*$request->punishment/100;
        $payment_amount = $payment->payment_amount+$punish;

        $payment->paid_amount += $request['amount'];
                if ($payment->paid_amount >= $payment_amount) {
                    $payment_status = 'paid';
                } else {
                    if ($payment->paid_amount > 0) {
                        $payment_status = 'partial';
                    } else {
                        $payment_status = 'due';
                    }
                }
        $payment->punishment = $request['punishment']?:0;
        $payment->payment_status = $payment_status;
        $payment->update();


        $paymentDetailModel = new PaymentDetailModel;
        $paymentDetailModel->paid_amount = $request['amount'];
        $paymentDetailModel->payment_date = date('Y-m-d',strtotime($request['date']));
        $paymentDetailModel->note = $request['note'];
        $paymentDetailModel->payment_id = $id;
        $paymentDetailModel->payment_method = $request['sub_payment_method'] ?? $request['payment_method'];;
        $paymentDetailModel->punishment = $request['punishment'];
        $paymentDetailModel->save();
        if($payment->type === 'purchase' ) {
            $invoice = PurchaseModel::find($payment->invoice_id);
        }else{
            $invoice = SaleModel::find($payment->invoice_id);
        }
        if($invoice){
            $invoice->payment_method = $paymentDetailModel->payment_method;
            $invoice->payment_status = $payment->payment_status;
            if($payment->type === 'purchase' ) {
                $invoice->paid_usd  += $request['amount'];
                $invoice->payment_status = $payment_status;
            }else{
                $invoice->paid_amount_usd+= $request['amount'];
                $invoice->payment_status = $payment_status;
                $invoice->remain -= $request['amount'];
                if($invoice->payment_status==='paid'){
                    $invoice->receipt_number = refNumber($invoice->branch_id,'receipt','RC');
                }
            }
            if($invoice->purchase_request_id){
                $purchase = PurchaseModel::find($invoice->purchase_request_id);
                $p_payment = PaymentModel::where(['invoice_id'=>$purchase->id,'type'=>'purchase'])->first();
                $p_payment->paid_amount+=$request['amount'];
                $p_payment->payment_status=$payment_status;
                $p_payment->update();

                $purchase->paid_usd  += $request['amount'];
                $purchase->payment_method = $paymentDetailModel->payment_method;
                $purchase->payment_status = $payment_status;
                $purchase->update();
            }
            $invoice->update();
        }
        /* ====== Accounting ====== */
        if ($payment->type == 'purchase') {
            $j = JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
            $journal = new JournalModel;
            $journal->branch_id = $invoice->branch_id;
            $journal->journal_parentid = 0;
            $journal->journal_type = 1;
            $journal->journal_acccode = $paymentDetailModel->payment_method;
            $journal->voucher_type = 2;
            $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
            $journal->journal_des = 'Stock In Payment (' . $invoice->invoice_number . ')';
            $journal->journal_debit = 0;
            $journal->journal_credit = $request->amount;
            $journal->journal_tran_id = $j->last_num + 1;
            $journal->journal_transactiondate = $paymentDetailModel->payment_date;
            $journal->journal_paydate = $paymentDetailModel->payment_date;
            $journal->journal_currency = 2;
            $journal->transaction_type = $payment->type;
            $journal->journal_referenceid = $payment->id;
            $journal->journal_by_supplier = $payment->supplier_id;
            $journal->journal_by = \Auth::id();
            $journal->journal_reference_number = $invoice->reference_number;
            $journal->save();

            $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

            $journal = new JournalModel;
            $journal->branch_id = $invoice->branch_id;
            $journal->journal_parentid = $jj->last_id;
            $journal->journal_type = 2;
            $journal->journal_acccode = 21001;
            $journal->voucher_type = 2;
            $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
            $journal->journal_des = 'Stock In Account Payable (' . $invoice->invoice_number . ')';
            $journal->journal_debit = $request->amount;
            $journal->journal_credit = 0;
            $journal->journal_tran_id = $j->last_num + 1;
            $journal->journal_transactiondate = $paymentDetailModel->payment_date;
            $journal->journal_paydate = $paymentDetailModel->payment_date;
            $journal->journal_currency = 2;
            $journal->transaction_type = $payment->type;
            $journal->journal_referenceid = $payment->id;
            $journal->journal_by_supplier = $payment->supplier_id;
            $journal->journal_by = \Auth::id();
            $journal->journal_reference_number = $invoice->reference_number;
            $journal->save();
        }
        else{
            $j = JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
            $journal = new JournalModel;
            $journal->branch_id = $invoice->branch_id;
            $journal->journal_parentid = 0;
            $journal->journal_type = 1;
            $journal->journal_acccode = $paymentDetailModel->payment_method;
            $journal->voucher_type = 1;
            $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
            $journal->journal_des = $invoice->sale_type.' Payment ' . '(' . $invoice->reference_number . ')';
            $journal->journal_debit = $request->amount;
            $journal->journal_credit = 0;
            $journal->journal_tran_id = $j->last_num + 1;
            $journal->journal_transactiondate = $paymentDetailModel->payment_date;
            $journal->journal_paydate = $paymentDetailModel->payment_date;
            $journal->journal_currency = 2;
            $journal->transaction_type =$payment->type;
            $journal->journal_referenceid = $payment->id;
            $journal->journal_reference_number = $invoice->reference_number;
            $journal->journal_by = \Auth::id();
            $journal->save();

            $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

            $journal = new JournalModel;
            $journal->branch_id = $invoice->branch_id;
            $journal->journal_parentid = $jj->last_id;
            $journal->journal_type = 1;
            $journal->journal_acccode = 11003;
            $journal->voucher_type = 1;
            $journal->voucher_ref = "V-" . $this->generate_voucher_number(($j->last_num + 1), 8);
            $journal->journal_des = $invoice->sale_type.' Payment Account Receivable ' . '(' . $invoice->reference_number . ')';
            $journal->journal_debit = 0;
            $journal->journal_credit = $request->amount;
            $journal->journal_tran_id = $j->last_num + 1;
            $journal->journal_transactiondate = $paymentDetailModel->payment_date;
            $journal->journal_paydate = $paymentDetailModel->payment_date;
            $journal->journal_currency = 2;
            $journal->transaction_type =$payment->type;
            $journal->journal_referenceid = $payment->id;
            $journal->journal_by = \Auth::id();
            $journal->journal_reference_number = $invoice->reference_number;
            $journal->save();

        }
        return response()->json(['status' => 'ok','reload'=>1]);
    }
}
