<?php

namespace App\Http\Controllers\Administrator;

use App\Http\Controllers\Controller;
use App\Model\Accounting\AccountChartModel;
use App\Model\Accounting\JournalModel;
use App\Model\CostOfSoldModel;
use App\Model\CurrencyHistoryModel;
use App\Model\CustomerBranchModel;
use App\Model\CustomerIllnessModel;
use App\Model\CustomerModel;
use App\Model\ImageModel;
use App\Model\MemberModel;
use App\Model\PaymentDetailModel;
use App\Model\PaymentModel;
use App\Model\ProductModel;
use App\Model\ProductUnitModel;
use App\Model\purchase_order\PurchaseOrderDetailModel;
use App\Model\purchase_order\PurchaseOrderModel;
use App\Model\SaleDetailsModel;
use App\Model\SaleModel;
use App\Model\setup\CustomerStatusModel;
use App\Model\StockModel;
use App\Model\WarehouseModel;
use App\Models\TypeOfIllness;
use App\User;
use Auth;
use Carbon\Carbon;
use DataTables;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;

class SellerRequestProductController extends Controller
{
    public function index()
    {
        return view('administrator.SellerRequestProduct.index');
    }
    public function order_list()
    {
        $order = 1;
        return view('administrator.SellerRequestProduct.index',compact('order'));
    }
    public function getTable(Request $request){
        if ($request->ajax()) {
            $isorder = $request['isorder'];
            $data = PurchaseOrderModel::leftJoin('users', 'nso007_purchase_order.user_id', 'users.id')
                ->leftJoin('nso007_branch', 'nso007_purchase_order.request_to', 'nso007_branch.id')
                ->leftJoin('nso007_customers', 'nso007_purchase_order.customer_id', 'nso007_customers.id')
                ->selectRaw('purchase_date,
                            users.name as seller,
                            nso007_branch.name as branch_name,
                            payment_status,
                            nso007_purchase_order.warehouse_id,
                            nso007_purchase_order.user_id,
                            nso007_purchase_order.status,
                            nso007_purchase_order.purchase_type,
                            nso007_purchase_order.is_role,
                            nso007_purchase_order.approve_by,
                            nso007_purchase_order.grand_total,
                            nso007_purchase_order.customer_id,
                            nso007_purchase_order.payment_type,
                            nso007_purchase_order.paid_amount_usd,
                            nso007_purchase_order.paid_amount_kh,
                            nso007_purchase_order.using_point,
                            nso007_purchase_order.reference_number,
                            nso007_purchase_order.reference,
                            nso007_purchase_order.request_to,
                            nso007_purchase_order.request_by,
                            nso007_purchase_order.close_sale_by,
                            nso007_purchase_order.bach_number,
                            nso007_customers.customer_name,
                            nso007_customers.customer_phone,
                            nso007_customers.customer_type,
                            nso007_customers.type_illness,
                            nso007_customers.known_product_by,
                            nso007_customers.known_this_from,
                            nso007_customers.customer_type,
                            nso007_customers.customer_status_id,
                            nso007_purchase_order.id')
                ->where(function ($q) use ($isorder){
                    if($isorder){
                        $mybranch = myBranch();
                        $relate = getRelatedBranchId($mybranch);
                        if(if_main($mybranch)){
                            $q->whereIn('nso007_purchase_order.request_to',  $relate);
                            $q->orwhereIn('nso007_purchase_order.request_by',  $relate);
                        }else{
                            $q->where('nso007_purchase_order.request_to',  $mybranch->id);
                        }
                    }else{
                        $q->where('nso007_purchase_order.request_by',  FindBranchID());
                    }
                })
                ->where(function ($q) use ($request){
                    if($request['reference_number']){
                        $q->where('nso007_purchase_order.reference_number', 'like', $request['reference_number'].'%');
                    }
                    if($request['bach_number']){
                        $q->where('nso007_purchase_order.bach_number', 'like', '%'.$request['bach_number'].'%');
                    }
                    if($request['customer_status_id']){
                        $q->where('nso007_customers.customer_status_id',  $request['customer_status_id']);
                    }
                    if($request['request_by']){
                        $q->where('nso007_purchase_order.request_by',  $request['request_by']);
                    }
                    if($request['request_to']){
                        $q->where('nso007_purchase_order.request_to',  $request['request_to']);
                    }
                    if($request['branch_id']){
                        $q->where('nso007_purchase_order.request_to',  $request['branch_id']);
                    }
                    if($request['approve_by']){
                        $q->where('nso007_purchase_order.approve_by',  $request['approve_by']);
                    }
                    if($request['user_id']){
                        $q->where('nso007_purchase_order.user_id',  $request['user_id']);
                    }
                    if($request['customer_id']){
                        $q->where('nso007_purchase_order.customer_id',  $request['customer_id']);
                    }
                    if($request['payment_status']){
                        $q->where('nso007_purchase_order.payment_status',  $request['payment_status']);
                    }
                    if($request['from_date']){
                        $q->whereDate('nso007_purchase_order.purchase_date', '>=', date('Y-m-d',strtotime($request['from_date'])).' 00:00:00');
                    }
                    if($request['to_date']){
                        $q->whereDate('nso007_purchase_order.purchase_date', '<=', date('Y-m-d',strtotime($request['to_date'])).' 23:59:59');
                    }
                })
                ->orderBy('nso007_purchase_order.reference_number','DESC')
                ->paginate($request->record, ['*'], 'page', str_replace(',', '', $request->page));

            return DataTables::of($data->items())
                ->with([
                    "activePage" => $request->page,
                    "records" => $request->record,
                    "recordsTotal" => $data->total(),
                    "recordsFiltered" => $data->total(),
                    'totalPage' => $data->lastPage()
                ])
                ->addColumn('action', function ($action) {
                    $btn = '';
                    $payment_id = 0;
                    if($action->payment_status!=='paid'){
                        $payment = PaymentModel::where(['invoice_id'=>$action->id,'type'=>'retail'])->first();
                        $payment_id = $payment?$payment->id:0;
                    }
                    $btn .= '<a
                    class="fa fa-eye btn btn-sm btn-success show_form"
                    title="Show" data-href="' . route('get-maho-request-invoice', $action->id) . '"
                    data-status="' . $action->payment_status . '"
                    data-id="' . $action->id . '"
                    data-get_payment_url = "' . route("payment.edit", $payment_id) . '"
                    data-payment_id= "' . $payment_id . '"
                    ></a> ';
                    $btn .= '<a
                    class="fa fa-user btn btn-sm btn-info show_customer"
                    title="show customer" data-href="' .route('get-maho-request-invoice',$action->id).'?show_customer=1'. '"></a>
                    ';
                    $check_file = ImageModel::where(['model'=>$action->getTable(),'model_id'=>$action->id])->first();
                    if($check_file) {
                        $btn .= '
                    <a data-href="'.route('get-image').'?model='.$action->getTable().'&model_id='.$action->id.'" class="btn btn-primary fa fa-file btn_show_file" ></a>
                    ';
                    }
                    if ($action->status == 3 || $action->status == 1 || $action->status == 2) {

                    } else {
                        if (Auth::id() == $action->user_id) {
                            // $btn .= '<a href="' . route("seller-request-product.edit", $action->id) . '"><i href="javascript:;" class="fa fa-pencil btn btn-sm btn-warning edit_form" title="Edit"></i></a> ';
                            if($action->status==0){
                                $btn .= '<i href="javascript:;" class="fa fa-trash btn btn-sm btn-danger delete_form" title="Delete" data-url="' . route("seller-request-product.destroy", $action->id) . '" ></i> ';
                            }
                        }
                        if (FindBranchID() == $action->request_to) {
                            $btn .= '<i href="javascript:;" class="fa fa-check btn btn-sm btn-primary approve_form" title="Approve" data-href="'.route('seller-request-product-update-type',$action->id).'"></i> ';
                            $btn .= '<i href="javascript:;" class="fa fa-times btn btn-sm btn-danger reject_form" title="Reject" data-url="' . route("seller-request-product.destroy", $action->id) . '"  ></i> ';
                        }
                    }
                    return $btn;
                })
                ->editColumn('purchase_date', function ($action) {
                    return Carbon::parse($action->purchase_date)->format('d-m-Y h:i');;
                })
                ->editColumn('customer_type', function ($action) {
                    if($action->customer_type){
                        return customerType($action->customer_type);
                    }
                })
                ->editColumn('user_id', function ($action) {
                    $user = findUser($action->user_id);
                    return $user ? $user->name : '';
                })
                ->editColumn('request_by', function ($action) {
                    $user = findBranch($action->request_by);
                    return $user ? $user->name : '';
                })
                ->editColumn('request_to', function ($action) {
                    $user = findBranch($action->request_to);
                    return $user ? $user->name : '';
                })
                ->editColumn('approve_by', function ($action) {
                    $user = findUser($action->approve_by);
                    return $user ? $user->name : '';
                })

                ->addColumn('payment_type', function ($action) {
                    if($action->payment_type){
                        $acc  = AccountChartModel::find($action->payment_type);
                        return $acc->acc_name??'';
                    }
                })
                ->editColumn('type_illness', function ($action) {
                    if($action->type_illness){
                        return getCustomerIllnessJson($action->type_illness);
                    }
                })
                ->editColumn('customer_status_id', function ($action) {
                    if($action->customer_status_id){
                        return CustomerStatusModel::find($action->customer_status_id)->name??'';
                    }
                })
                ->editColumn('known_this_from', function ($action) {
                    if($action->known_this_from){
                        return leadSource($action->known_this_from);
                    }
                })
                ->editColumn('payment_status', function ($action) {
                    return getPaymentStatus($action->payment_status);
                })
                ->addColumn('total', function ($action) {
                    return $action->grand_total ? ('$' . $action->grand_total) : 0;
                })
                ->addColumn('total', function ($action) {
                    return $action->grand_total ? ('$' . $action->grand_total) : 0;
                })
                ->addColumn('paid', function ($action) {
                    $rate = CurrencyHistoryModel::find($action->rate);
                    $rate = $rate ? $rate->exchange : currencyExchange();
                    $action->paid = ($action->paid_amount_kh / $rate) + $action->paid_amount_usd;
                    return '$' . number_format($action->paid,2);
                })
                ->addColumn('remain', function ($action) {
                    $remain = $action->grand_total - $action->paid;
                    $remain = $remain > 0 ? $remain : 0;
                    return '$' . number_format($remain,2);
                })
                ->addColumn('points', function ($action) {
                    return getPoint($action->grand_total);
                })
                ->editColumn('status', function ($action) {
                    switch ($action->status) {
                        case '1':
                            return '<span class="label label-success">Approved</span>';
                            break;
                        case '0':
                            return '<span class="label label-default">Pending</span>';
                            break;
                        case '2':
                            return '<span class="label label-danger">Rejected</span>';
                            break;
                        case '3':
                            return '<span class="label label-danger">Canceled</span>';
                            break;
                        case '4':
                            return '<span class="label label-warning">Returned</span>';
                            break;
                        default:
                            break;
                    }
                })
                ->addIndexColumn()
                ->rawColumns(['action',
                    'payment_status', 'status',
                    'customer_phone', 'type_illness', 'total',
                    'remain', 'paid', 'points','reference_number'])
                ->make(true);

        }
    }
    public function create(Request $request)
    {
        $stock_item = StockModel::join('nso007_product_unit', 'nso007_stocks.product_unit_id', 'nso007_product_unit.id')
            ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
            ->groupBy('product_unit_id')
            ->selectRaw('image, product_name, nso007_product_unit.id, nso007_product_unit.barcode')
            ->paginate(20);

        $branches = getBranch()->pluck('name', 'id');

        if ($request->ajax()) {
            $html = view('administrator.SellerRequestProduct.product', compact('stock_item'))->render();
            return response()->json(['html' => $html]);
        }
        return view('administrator.SellerRequestProduct.create', compact('stock_item', 'branches'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'member' => 'required|numeric',
        ]);

        $total = str_replace('$', '', $request['subtotal']);
        $total = str_replace(',', '', $total);
        $deliery_usd = $request['deliery-usd'];
        $deliery_kh = $request['deliery-kh'] / currencyExchange();
        // $discount = $request['discount'];
        // $grand_total = $total - ($total*($discount/100));
        $grand_total = $total;
        $paid_kh = $request['paid_kh'];
        $paid_usd = $request['paid_usd'];
        $paid_total_us = $paid_kh / currencyExchange() + $paid_usd;
        $member = $request->member;
        $branch_warehouse = WarehouseModel::where('branch_id', $member)->first();

        $purchaseOrderModel = new PurchaseOrderModel;
        $purchaseOrderModel->customer_id = $request['customer'];
        $purchaseOrderModel->payment_type = 0;
        $purchaseOrderModel->branch_id = FindBranchID();
        $purchaseOrderModel->transaction_code = 'TR' . date("YmdhisA");
        $purchaseOrderModel->user_id = \Auth::id();
        $purchaseOrderModel->request_by = $request['customer'];
        $purchaseOrderModel->request_type = 'customer';
        $purchaseOrderModel->rate = getProductRate();
        $purchaseOrderModel->invoice_number = getPrefixSale() . date("YmdhisA");
        $purchaseOrderModel->purchase_date = Carbon::now();
        $purchaseOrderModel->paid_amount_kh = 0;
        $purchaseOrderModel->paid_amount_usd = 0;
        $purchaseOrderModel->discount = 0;
        $purchaseOrderModel->payment_status = 'owe';
        $purchaseOrderModel->status = 0;
        $purchaseOrderModel->warehouse_id = $branch_warehouse->id;
        $purchaseOrderModel->save();

        $saleProduct = session()->get('saleRequest');
        if ($saleProduct) {
            foreach ($saleProduct as $item) {
                $purchaseOrderDetailModel = new PurchaseOrderDetailModel;
                $purchaseOrderDetailModel->product_unit_id = $item['id'];
                $purchaseOrderDetailModel->purchase_order_id = $purchaseOrderModel->id;
                $purchaseOrderDetailModel->qty = $item['qty'];
                $purchaseOrderDetailModel->sale_price = $item['cost'];
                $purchaseOrderDetailModel->dis = $item['discount'];
                $purchaseOrderDetailModel->unit_id = $item['unit_selected'];
                $purchaseOrderDetailModel->date = Carbon::now();
                $purchaseOrderDetailModel->save();
            }
        }
        session()->forget('saleRequest');
        return redirect()->route('seller-request-product.index')->with('success', 'Seller request product created successfully.');
    }

    public function show($id)
    {
        $purchaseOrderDetail = PurchaseOrderDetailModel::where('purchase_order_id', $id)
            ->leftJoin('nso007_purchase_order', 'nso007_purchase_order_detail.purchase_order_id', 'nso007_purchase_order.id')
            ->leftJoin('nso007_product_unit', 'nso007_purchase_order_detail.product_unit_id', 'nso007_product_unit.id')
            ->leftJoin('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
            ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
            ->selectRaw('product_name,
                                            paid_amount_kh,
                                            paid_amount_usd,
                                            unit,
                                            nso007_purchase_order_detail.qty,
                                            nso007_purchase_order_detail.dis,
                                            sale_price as cost')
            ->get();
        $view = view('administrator.SellerRequestProduct.show', compact('purchaseOrderDetail'))->render();
        return response()->json(['html' => $view]);
    }

    public function edit(Request $request, $id)
    {
        session()->forget('saleRequest');
        $purchase_order_detail = PurchaseOrderModel::join('nso007_purchase_order_detail', 'nso007_purchase_order.id', 'nso007_purchase_order_detail.purchase_order_id')
            ->where('nso007_purchase_order.id', $id)
            ->selectRaw('product_unit_id, qty, sale_price, unit_id, customer_id, warehouse_id, customer_id, warehouse_id, paid_amount_usd, paid_amount_kh')
            ->get();
        $customer_id = $purchase_order_detail->first()->customer_id;
        $warehouse_id = $purchase_order_detail->first()->warehouse_id;
        $brand_id = WarehouseModel::find($warehouse_id)->branch_id;
        if ($purchase_order_detail) {
            foreach ($purchase_order_detail as $key => $item) {
                $product_unit = \DB::table('nso007_product_unit')
                    ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                    ->selectRaw('nso007_product_unit.cur, sub_unit_id, product_id,image, product_name, nso007_product_unit.id, nso007_product_unit.barcode, retail_price')
                    ->where('nso007_product_unit.id', $item['product_unit_id'])
                    ->first();

                $product = ProductModel::where('id', $product_unit->product_id)
                    ->with('unit', 'unit_child')
                    ->first(['unit_id', 'child_unit']);
                $units = [];
                if ($product) {
                    if ($product->unit)
                        $units[$product->unit->id] = $product->unit->unit;

                    if ($product->unit_child)
                        $units[$product->unit_child->id] = $product->unit_child->unit;
                }
                $saleProduct[$item['product_unit_id']] = [
                    "id" => $item['product_unit_id'],
                    "units" => $units,
                    "unit_selected" => $item['unit_id'],
                    "name" => $product_unit->product_name,
                    "qty" => $item['qty'],
                    "cur" => 2,
                    "cost" => $item['sale_price'],
                    "discount" => 0,
                    "total" => 0,
                ];
                session()->put('saleRequest', $saleProduct);
            }
        }

        $stock_item = StockModel::join('nso007_product_unit', 'nso007_stocks.product_unit_id', 'nso007_product_unit.id')
            ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
            ->groupBy('product_unit_id')
            ->selectRaw('image, product_name, nso007_product_unit.id, nso007_product_unit.barcode')
            ->paginate(20);

        $branches = User::whereIn('is_role', ['Branch', 'Partner'])->pluck('name', 'id');

        if ($request->ajax()) {
            $html = view('administrator.SellerRequestProduct.product', compact('stock_item'))->render();
            return response()->json(['html' => $html]);
        }
        return view('administrator.SellerRequestProduct.edit', compact('stock_item', 'branches', 'id', 'customer_id', 'brand_id'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'member' => 'required|numeric',
        ]);

        $total = str_replace('$', '', $request['subtotal']);
        $total = str_replace(',', '', $total);
        $deliery_usd = $request['deliery-usd'];
        $deliery_kh = $request['deliery-kh'] / currencyExchange();
        // $discount = $request['discount'];
        // $grand_total = $total - ($total*($discount/100));
        $grand_total = $total;
        $paid_kh = $request['paid_kh'];
        $paid_usd = $request['paid_usd'];
        $paid_total_us = $paid_kh / currencyExchange() + $paid_usd;
        $member = $request->member;
        $branch_warehouse = WarehouseModel::where('branch_id', $member)->first();

        $purchaseOrderModel = PurchaseOrderModel::find($id);
        $purchaseOrderModel->customer_id = $request['customer'];
        $purchaseOrderModel->payment_type = 0;
        // $purchaseOrderModel->transaction_code = 'TR'.date("YmdhisA");
        $purchaseOrderModel->user_id = \Auth::id();
        $purchaseOrderModel->request_by = $request['customer'];
        $purchaseOrderModel->request_type = 'customer';
        // $purchaseOrderModel->rate = getProductRate();
        // $purchaseOrderModel->invoice_number = getPrefixSale().date("YmdhisA");
        // $purchaseOrderModel->purchase_date = Carbon::now();
        $purchaseOrderModel->paid_amount_kh = 0;
        $purchaseOrderModel->paid_amount_usd = 0;
        $purchaseOrderModel->discount = 0;
        $purchaseOrderModel->payment_status = 'owe';
        $purchaseOrderModel->status = 0;
        $purchaseOrderModel->warehouse_id = $branch_warehouse->id;
        $purchaseOrderModel->update();

        PurchaseOrderDetailModel::where('purchase_order_id', $id)->delete();
        $saleProduct = session()->get('saleRequest');
        if ($saleProduct) {
            foreach ($saleProduct as $item) {
                $purchaseOrderDetailModel = new PurchaseOrderDetailModel;
                $purchaseOrderDetailModel->product_unit_id = $item['id'];
                $purchaseOrderDetailModel->purchase_order_id = $purchaseOrderModel->id;
                $purchaseOrderDetailModel->qty = $item['qty'];
                $purchaseOrderDetailModel->sale_price = $item['cost'];
                $purchaseOrderDetailModel->dis = $item['discount'];
                $purchaseOrderDetailModel->unit_id = $item['unit_selected'];
                $purchaseOrderDetailModel->date = Carbon::now();
                $purchaseOrderDetailModel->save();
            }
        }
        session()->forget('saleRequest');
        return redirect()->route('seller-request-product.index')->with('success', 'Seller request product created successfully.');
    }

    public function destroy(Request $request, $id)
    {
        PurchaseOrderModel::findOrFail($id)->update(['status' => $request->type == 'reject' ? 2 : 3]);
        return response()->json(['message' => 'success', 'data' => 'Seller request deleted successfully.']);
    }

    public function addProduct(Request $request, $id)
    {
        $product_unit = \DB::table('nso007_product_unit')
            ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
            // ->leftJoin('nso007_unit', 'nso007_product_unit.sub_unit_id', 'nso007_unit.id')
            // ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
            // ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
            ->selectRaw('nso007_product_unit.cur, sub_unit_id, product_id,image, product_name, nso007_product_unit.id, nso007_product_unit.barcode, retail_price')
            ->where(function ($q) use ($request, $id) {
                if ($request->type == 'id') {
                    $q->where('nso007_product_unit.id', $id);
                } else {
                    $q->where('nso007_product_unit.barcode', $id);
                }
            })
            ->first();

        $product = ProductModel::where('id', $product_unit->product_id)
            ->with('unit', 'unit_child')
            ->first(['unit_id', 'child_unit']);
        $units = [];
        if ($product) {
            if ($product->unit)
                $units[$product->unit->id] = $product->unit->unit;

            if ($product->unit_child)
                $units[$product->unit_child->id] = $product->unit_child->unit;
        }

        $saleProduct = session()->get('saleRequest');
        if ($saleProduct) {
            if (@$saleProduct[$product_unit->id]) {
                return response()->json(['message' => 'warning', 'data' => __('administrator.product_adding_is_already_exist') . '!']);
            } else {
                $saleProduct[$product_unit->id] = [
                    "id" => $product_unit->id,
                    "units" => $units,
                    "unit_selected" => $product_unit->sub_unit_id,
                    "name" => $product_unit->product_name,
                    "qty" => 0,
                    "cur" => 2,
                    "cost" => $product_unit->retail_price,
                    "discount" => 0,
                    "total" => 0,
                ];
                session()->put('saleRequest', $saleProduct);
                return response()->json(['message' => 'success', 'data' => __('administrator.product_adding_successfully')]);
            }
        } else {
            $saleProduct[$product_unit->id] = [
                "id" => $product_unit->id,
                "units" => $units,
                "unit_selected" => $product_unit->sub_unit_id,
                "name" => $product_unit->product_name,
                "qty" => 0,
                "cur" => 2,
                "cost" => $product_unit->retail_price,
                "discount" => 0,
                "total" => 0,
            ];
            session()->put('saleRequest', $saleProduct);
            return response()->json(['message' => 'success', 'data' => __('administrator.product_added_successfully')]);
        };
    }

    public function getProduct()
    {
        $saleProduct = session()->get('saleRequest');
        $view = view('administrator.SellerRequestProduct.product_list', compact('saleProduct'))->render();
        return response()->json(['html' => $view]);
    }

    public function deleteProduct($id = 0)
    {
        $id == 0 ? session()->forget('saleRequest') : session()->forget('saleRequest.' . $id);
        return response()->json(['message' => 'success', 'data' => 'Product deleted successfully.']);
    }

    public function updateProduct(Request $request, $id)
    {
        $product_unit = ProductUnitModel::find($id);
        $price = $product_unit->unit_id == $request['unit'] ? $product_unit->wholesale_price : $product_unit->retail_price;
        $saleProduct = session()->get('saleRequest');
        $saleProduct[$id]['qty'] = $request['qty'];
        $saleProduct[$id]['cost'] = $price;
        $saleProduct[$id]['discount'] = $request['discount'];
        $saleProduct[$id]['unit_selected'] = $request['unit'];
        session()->put('saleRequest', $saleProduct);
        return response()->json(['message' => 'success', 'data' => 'Product updated successfully.']);
    }

    public function updateType(Request $request, $id)
    {
        if($request->method()==='GET'){
            $order = PurchaseOrderModel::find($id);
            return view('administrator.SellerRequestProduct.confirm-form',compact('order'));
        }
        else{
            $this->validate($request,[
                'reference_number'=>'required|unique:nso007_sales,reference_number',
                'warehouse_id'=>'required',
            ]);
            $purchase_order_detail = PurchaseOrderDetailModel::where('purchase_order_id', $id)->get();
            $warehouse = $request->warehouse_id;
            $stock_check=[];
            if($purchase_order_detail){
                foreach ($purchase_order_detail as $key=> $item) {
                    $product_unit = ProductUnitModel::find($item['product_unit_id']);
                    $product = ProductModel::find($product_unit->product_id);
                    $qty = $product_unit->unit_id == $item['unit_id'] ? ($item['qty'] * $product_unit->qty_per_unit) : $item['qty'];
                    $stock = StockModel::where('warehouse_id', $warehouse)->where('product_unit_id', $item['product_unit_id'])->first();
                    if ($stock) {
                        if($stock->stock_qty<$qty){
                            $stock_check[$product->product_name.$key] = $product->product_name.' is not enough.';
                        }
                    }
                }
            }else{
                throw ValidationException::withMessages(['kk'=>'No Item']);
            }
            if(count($stock_check)){
                throw ValidationException::withMessages($stock_check);
            }
            $user_id = Auth::user()->id;
            $purchaseOrder = PurchaseOrderModel::find($id);
            $grand_total = $purchaseOrder->grand_total;
            $delivery_fee = $purchaseOrder->delivery_en+($purchaseOrder->delivery_kh/currencyExchange());
            $paid_total_us = $purchaseOrder->paid_amount_kh / currencyExchange() + $purchaseOrder->paid_amount_usd;
            if ($paid_total_us >= $grand_total) {
                $payment_status = 'paid';
            } else {
                if ($paid_total_us > 0) {
                    $payment_status = 'partial';
                } else {
                    $payment_status = 'due';
                }
            }

            $receipt = '';
            $inv = '';
            $ref = $request->reference_number;
            $ref = $ref?$ref:refNumber( FindBranchID());
            if($payment_status==='paid'){
                $receipt = refNumber( FindBranchID(),'receipt','RC');
            }else{
                $inv = refNumber( FindBranchID(),'invoice','INV');
            }

            if ($purchaseOrder->get_point) {
                $get_point = getPoint($grand_total);
            } else {
                $get_point = 0;
            }

            $using_voucher_customer = $purchaseOrder->using_voucher_customer;
            $customerModel = CustomerModel::find($purchaseOrder->customer_id);
            $using_voucher_customer = CustomerModel::find($using_voucher_customer);
            $balance =   $customerModel->points+$get_point-(!$using_voucher_customer?$purchaseOrder->using_point:0);
            $purchaseOrder->update(['status' => 1, 'reason' => $request->note, 'warehouse_id' => $warehouse,'approve_by'=>$user_id,'reference_number'=>$ref]);

            $sale_date = Carbon::parse($purchaseOrder->purchase_date)->format('Y-m-d');
            $old_sale = SaleModel::where('customer_id',$customerModel->id)->orderBy('sale_date', 'ASC')->first();
            $date1 = $old_sale->sale_date??$purchaseOrder->purchase_date;
            $date2 = $sale_date;

            $toc = genTypeOfCustomer($date1,$date2);
            $first_sale = SaleModel::where('customer_id',$customerModel->id)->first();

            $pos = new SaleModel;
            $pos->reference_number= $ref;
            $pos->invoice_number= $inv;
            $pos->receipt_number= $receipt;
            $pos->points = $get_point;
            $pos->branch_id = FindBranchID();
            $pos->request_by = $purchaseOrder->request_by; // user
            $pos->request_to = $purchaseOrder->request_to; // branch
            $pos->using_point = $purchaseOrder->using_point ? $purchaseOrder->using_point : 0;
            $pos->balance_point = $balance;
            $pos->voucher_codes = date('sihdmy');
            $pos->user_id = $user_id;
            $pos->close_sale_by = $purchaseOrder->close_sale_by;
            $pos->customer_id = $purchaseOrder->customer_id;
            $pos->customer_type = $purchaseOrder->customer_type;
            $pos->using_voucher_customer = $purchaseOrder->using_voucher_customer;
            $pos->request_id = $purchaseOrder->id;
            $pos->payment_type = $purchaseOrder->payment_type;
            $pos->payment_status = $payment_status;
            $pos->year = date('Y');
            $pos->rate = $purchaseOrder->rate;
            $pos->sale_type = $purchaseOrder->purchase_type;
            $pos->paid_amount_kh = $purchaseOrder->paid_amount_kh;
            $pos->paid_amount_usd = $purchaseOrder->paid_amount_usd;
            $pos->discount = $purchaseOrder->discount;
            $pos->sale_date = $purchaseOrder->purchase_date;
            $pos->bach_number = generate_customer_bach($first_sale->sale_date??$sale_date);
            $pos->warehouse_id = $warehouse;
            $pos->status = 1;
            $pos->delivery_type = $purchaseOrder->delivery_type;
            $pos->delivery_fee = $purchaseOrder->delivery_en;
            $pos->delivery_fee_kh = $purchaseOrder->delivery_kh ;
            $pos->customer_note = $purchaseOrder->customer_note ;
            $grand_total+=($purchaseOrder->delivery_kh?$purchaseOrder->delivery_kh/currencyExchange():0)+$purchaseOrder->delivery_en;
            $pos->delivery_note = $purchaseOrder->comment;

            if ($files = $request->file('file')) {
                $original_name =  'PosRequest'.$purchaseOrder->id.'.png';
                $destinationPath = 'images/upload';
                $files->move($destinationPath, $original_name);
                $pos->invoice_reference = $destinationPath . '/' . $original_name;
            }
            $pos->type = 'customer';
            $pos->save();
            CustomerBranchModel::updateOrCreate([
                'customer_id'=>$pos->customer_id,
                'branch_id'=>$purchaseOrder->request_to,
                'user_id'=>$user_id,
            ],[
                'customer_id'=>$pos->customer_id,
                'branch_id'=>$purchaseOrder->request_to,
                'user_id'=>$user_id,
            ]);



            if ($customerModel) {
                if($request->customer_type){
                    $customerModel->customer_type = $pos->customer_type;
                }
                if($customerModel->type_of_customer!=='hm'){
                    $customerModel->type_of_customer = $toc;
                }
                $customerModel->points = $balance;
                $customerModel->bach_number = $pos->bach_number;
                $customerModel->update();
                CreateCustomerAccountChart($customerModel);
            }
            if($using_voucher_customer){
                $using_voucher_customer->points -= $purchaseOrder->using_point;
                $using_voucher_customer->update();
                CreateCustomerAccountChart($using_voucher_customer);
            }


            $j = JournalModel::selectRaw("Max(journal_tran_id) as last_num")->first();

            if ($purchase_order_detail) {
                foreach ($purchase_order_detail as $item) {
                    $product_unit = ProductUnitModel::find($item['product_unit_id']);
                    $qty = $product_unit->unit_id == $item['unit_id'] ? ($item['qty'] * $product_unit->qty_per_unit) : $item['qty'];
                    $stock = StockModel::where('warehouse_id', $warehouse)->where('product_unit_id', $item['product_unit_id'])->first();
                    if ($stock) {
                        if ($purchaseOrder->purchase_type === "wholesale" && $purchaseOrder->is_role === "Branch") {
                            $customer_warehouse = WarehouseModel::where('branch_id', $purchaseOrder->customer_id)->first();
                            $stock_customer = StockModel::where('warehouse_id', ($customer_warehouse ? $customer_warehouse->id : 0))->where('product_unit_id', $item['product_unit_id'])->first();
                            $stock_customer->stock_qty += $qty;
                            $stock_customer->update();
                        }
                        $stock->stock_qty -= $qty;
                        $stock->update();
                    }
                    $pos_detail = new SaleDetailsModel;
                    $pos_detail->sale_id = $pos->id;
                    $pos_detail->product_id = $item['product_unit_id'];
                    $pos_detail->qty = $item['qty'];
                    $pos_detail->currency_id = 2;
                    $pos_detail->sale_price = $item['sale_price'];
                    $pos_detail->dis = $item['dis'];
                    $pos_detail->unit_id = $item['unit_id'];
                    $pos_detail->total = $item['total'];
                    $pos_detail->member_package = $item['member_package'];
                    $pos_detail->last_stock = $stock->stock_qty;

                    $pos_detail->save();
                    //===================================== Account ========================================================
                    $cog = CostOfSoldModel::where(['product_unit_id'=>$pos_detail->product_id])->first();
                    $product = getProductById($product_unit->product_id);
                    $cost = $cog->cost??$product_unit->cost;
                    if((int)$pos_detail->unit_id !== (int)$product_unit->unit_id){
                        $cost/=$product_unit->qty_per_unit;
                    }
                    if($key===0){
                        $last_id = 0;
                    }else{
                        $last_id = JournalModel::selectRaw("Max(journal_parentid) as last_num")->first();
                        $last_id = $last_id->last_num??0;
                    }

                    $journal = new JournalModel;
                    $journal->branch_id = $pos->request_to;
                    $journal->journal_parentid = $last_id;
                    $journal->journal_type = 5;
                    $journal->voucher_type = 1;
                    $journal->journal_acccode = $product->acc_cost_of_good_sold;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Expense cost of goods sold '.($product->product_name??'').'('.($product->item_code??'').')';
                    $journal->journal_debit = $cost*$pos_detail->qty;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = date("Y-m-d");
                    $journal->journal_paydate = date("Y-m-d");
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $pos->id;
                    $journal->journal_by = \Auth::id();
                    $journal->journal_reference_number = $pos->invoice_number;
                    $journal->save();

                    $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                    $journal = new JournalModel;
                    $journal->branch_id = $pos->request_to;
                    $journal->journal_parentid = $jj->last_id;
                    $journal->journal_type = 4;
                    $journal->voucher_type = 1;
                    $journal->journal_acccode = $product->acc_sale_revenue;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Sale Revenue '.($product->product_name??'').'('.($product->item_code??'').')';
                    $journal->journal_debit = 0;
                    $journal->journal_credit = $pos_detail->sale_price*$pos_detail->qty;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = date("Y-m-d");
                    $journal->journal_paydate = date("Y-m-d");
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $pos->id;
                    $journal->journal_by = \Auth::id();
                    $journal->journal_reference_number = $pos->invoice_number;
                    $journal->save();

                    $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                    $journal = new JournalModel;
                    $journal->branch_id = $pos->request_to;
                    $journal->journal_parentid = $jj->last_id;
                    $journal->journal_type = 1;
                    $journal->voucher_type = 1;
                    $journal->journal_acccode = $product->acc_inventory;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($jj->last_num + 1), 8);
                    $journal->journal_des = 'Inventory  '.($product->product_name??'').'('.($product->item_code??'').')';
                    $journal->journal_debit = 0;
                    $journal->journal_credit = $cost*$pos_detail->qty;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = date("Y-m-d");
                    $journal->journal_paydate = date("Y-m-d");
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $pos->id;
                    $journal->journal_by = \Auth::id();
                    $journal->journal_reference_number = $pos->invoice_number;
                    $journal->save();
                }
            }

            $payment = new PaymentModel;
            $payment->invoice_id = $pos->id;
            $payment->branch_id = $purchaseOrder->request_to;
            $payment->customer_id = $pos->customer_id;
            $payment->user_id =$user_id;
            $payment->payment_invoice = $pos->invoice_number;
            $payment->payment_date = $sale_date;
            $payment->payment_amount = $grand_total;
            $payment->paid_amount = $paid_total_us;
            $payment->payment_status = $payment_status;
            $payment->type = $purchaseOrder->purchase_type;
            $payment->year = date('Y');
            $payment->status = 1;
            $payment->save();

            $payment_datail = new PaymentDetailModel;
            $payment_datail->payment_id = $payment->id;
            $payment_datail->paid_amount = $paid_total_us;
            $payment_datail->payment_date = $sale_date;
            $payment_datail->note = $purchaseOrder->purchase_type;
            $payment_datail->status = 1;
            $payment_datail->save();


            /* ====== Accounting ====== */
            $last_id_pos_clothes = $pos->id;
            $paid = $paid_total_us;
            $total = $grand_total;
            if ((double)$paid >= (double)$grand_total) {
                $journal = new JournalModel;
                $journal->branch_id = $pos->branch_id;
                $journal->journal_parentid = 0;
                $journal->journal_type = 1;
                $journal->journal_acccode = $pos->payment_type;
                $journal->voucher_type = 1;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Cash on hand  ' . '(' . $inv . ')';
                $journal->journal_debit = $total;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_reference_number = $inv;
                $journal->journal_by = $user_id;
                $journal->save();
            }
            else {
                if ($payment_status == 'partial') {
                    $journal = new JournalModel;
                    $journal->branch_id = $pos->branch_id;
                    $journal->journal_parentid = 0;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = $pos->payment_type;
                    $journal->voucher_type = 1;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Cash on hand  ' . '(' . $inv . ')';
                    $journal->journal_debit = $paid;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $inv;
                    $journal->journal_by = $user_id;
                    $journal->save();


                    $jj1 = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal = new JournalModel;
                    $journal->branch_id = $pos->branch_id;
                    $journal->journal_parentid = $jj1->last_id;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = 11003;
                    $journal->voucher_type = 1;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Account Receivable ' . '(' . $inv . ')';
                    $journal->journal_debit = $total - $paid;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $inv;
                    $journal->journal_by = $user_id;
                    $journal->save();
                }
                else {

                    $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal = new JournalModel;
                    $journal->branch_id = $pos->branch_id;
                    $journal->journal_parentid = $jj->last_id;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = $pos->payment_type;
                    $journal->voucher_type = 1;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Account Receivable ' . '(' . $inv . ')';
                    $journal->journal_debit = $total;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $inv;
                    $journal->journal_by = $user_id;
                    $journal->save();
                }

            }
            // delivery Revenue
            if($delivery_fee){
                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $pos->branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 4;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_sale_revenue;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Sale Revenue '.'(Delivery Fee)';
                $journal->journal_debit = 0;
                $journal->journal_credit = $delivery_fee;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $pos->invoice_number;
                $journal->save();
            }

            // Customer Points
            if($get_point) {
                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $pos->branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 2;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $customerModel->acc_related_party;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Related Party ' . '(' . ($customerModel->customer_name) . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $get_point / 2;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $pos->invoice_number;
                $journal->save();

                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $pos->branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 2;
                $journal->voucher_type = 2;
                $journal->journal_acccode = $customerModel->acc_marketing_promotion;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Expense Promotion ' . '(' . ($customerModel->customer_name) . ')';
                $journal->journal_debit =  $get_point / 2;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $pos->invoice_number;
                $journal->save();
            }
            // using point
            if((int)$request->using_point){

                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $pos->branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 2;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $customerModel->acc_related_party;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Related Party ' . '(' . ($customerModel->customer_name) . ') Used '.$request->using_point.' Point(s)';
                $journal->journal_debit = (int)$request->using_point / 2;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = $user_id;
                $journal->journal_reference_number = $inv;
                $journal->save();

            }
            /* ====== End Account ====== */

            /* ====== End Account ====== */
            return response()->json(['status' => 'ok']);
        }

    }
}
