<?php
namespace App\Http\Controllers\Administrator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DB;
use DataTables;
use Illuminate\Support\Facades\Crypt;
class RoleController extends Controller
{
    function __construct()
     {
          $this->middleware('permission:Role List', ['only' => ['show','index']]);
          $this->middleware('permission:Role Create', ['only' => ['create','store']]);
          $this->middleware('permission:Role Edit', ['only' => ['edit','update',]]);
     }
    public function index()
    {
        $data = Role::where(['group_role'=>'app','branch_id'=>FindBranchID()])->get();
		return view('administrator.roles.index',compact('data'));
    }
    public function create()
    {
        $branch = myBranch();
        $parent = findBranch($branch->parent_id);

        if($parent){
            $if_can = $parent->type==='branch'&&$branch->type!=='branch';
        }else{
            $if_can=null;
        }
        $group_permission = Permission::where('app_name','app')
            ->where(function ($q) use ($if_can){
                if($if_can){
                    $q->whereNotIn('group_name',['Item Setup','Member Package','Warehouse','Inventory']);
                }
            })->orderBy('id','ASC')->groupBy('group_name')->get();
        return view('administrator.roles.create',compact('group_permission'));
    }
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:roles,name',
            'permission' => 'required',
        ]);
        $role = new Role();
        $role->name =  $request->input('name');
        $role->branch_id =  FindBranchID();
        $role->group_role =  'app';
        $role->save();
        $role->syncPermissions($request->input('permission'));
        return redirect()->route('roles.index') ->with('success','Role created successfully !');
    }
    public function show($id)
    {
        $decrypt_id = Crypt::decrypt($id);
        $role = Role::find($decrypt_id);
        $rolePermissions = Permission::join("role_has_permissions","role_has_permissions.permission_id","=","permissions.id")
            ->where("role_has_permissions.role_id",$decrypt_id)
            ->get();
        return view('administrator.roles.show',compact('role','rolePermissions'));
    }
    public function edit($id)
    {
        $branch = myBranch();
        $parent = findBranch($branch->parent_id);

        if($parent){
            $if_can = $parent->type==='branch'&&$branch->type!=='branch';
        }else{
            $if_can = null;
        }
        $role = Role::find($id);
        $permission = Permission::get();
        $group_permission = Permission::where('app_name','app')
            ->where(function ($q) use ($if_can){
                if($if_can){
                    $q->whereNotIn('group_name',['Item Setup','Member Package','Warehouse','Inventory']);
                }
        })->orderBy('id','ASC')->groupBy('group_name')->get();
        $rolePermissions = DB::table("role_has_permissions")->where("role_has_permissions.role_id",$id)
            ->pluck('role_has_permissions.permission_id','role_has_permissions.permission_id')
            ->all();
        return view('administrator.roles.edit',compact('role','permission','rolePermissions','group_permission'));

    }
    public function update(Request $request, $id)

    {
        $this->validate($request, [
            'name' => 'required',
            'permission' => 'required',
        ]);

        $role = Role::find($id);
        $role->name = $request->input('name');
        $role->group_role =  'app';
        $role->save();

        $role->syncPermissions($request->input('permission'));

        return redirect()->back()

                        ->with('success','Role updated successfully !');
    }
    public function destroy($id)

    {

        DB::table("roles")->where('id',$id)->delete();

        return redirect()->route('roles.edit')

                        ->with('success','Role deleted successfully');

    }

}
