<?php


namespace App\Http\Controllers\Administrator;
use App\Fun\Fun;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Model\CustomerModel;

use App\Model\ProductModel;

use App\Model\StockModel;

use App\Model\SaleDetailsModel;

use App\Model\SaleModel;

use session;

use DB;

use Auth;

use DataTables;

class ReportSaleRequestController extends Controller

{
    function __construct()
    {
        $this->middleware('permission:Report Sales Request List', ['only' => ['index']]);
        Fun::lang();
    }

    public function index(Request $request)
    {
        $customer = SaleModel::where('is_role','out_shop')->pluck('customer_id');
        $customer = CustomerModel::whereIn('id',$customer)->pluck('customer_name','id');
        if ($request->ajax()) {
            $search = $request->input('search.value');
            $from_date = $request->start_date;
            $to_date = $request->end_date;
            $customer=$request->customer_id;
            $count_total = SaleModel::where('is_role','out_shop')->count();
            $data = SaleModel::select('nso007_sales.*',
            'nso007_customers.customer_phone',
            'nso007_customers.customer_name')
            ->join('nso007_customers', 'nso007_customers.id', 'nso007_sales.customer_id')
             ->where('is_role','out_shop')
            ->where(function ($query) use ($from_date, $to_date) {
                if ($from_date) {
                    $query->whereDate('nso007_sales.sale_date', '>=', date('Y-m-d', strtotime($from_date)));
                }
                if ($to_date) {
                    $query->whereDate('nso007_sales.sale_date', '<=', date('Y-m-d', strtotime($to_date)));
                }
            })
            ->where(function ($query) use ($customer) {
                if ($customer) {
                    $query->where('nso007_sales.customer_id',$customer);
                }
            })

            ->where(function ($q) use ($search) {
                if ($search) {
                    $q->where('nso007_sales.invoice_number', 'like', '%' . $search . '%');
                    $q->orwhere('nso007_customers.customer_phone', 'like', '%' . $search . '%');
                    $q->orwhere('nso007_customers.customer_name', 'like', '%' . $search . '%');
                }
            })
            ->orderBy('nso007_sales.id', 'DESC');
            $count_filter = $data->count();
            return DataTables::of($data->take(20))
                ->with([

                    "recordsTotal" => $count_total,

                    "recordsFiltered" => $count_filter,

                ])
                ->addColumn('amount', function ($sales) {
                    $user_currency = user_currency();
                    return $user_currency->symbol.number_format(generateGrandTotal($sales),2);

                })
                ->addColumn('sale_type', function ($sales) {
                    return __('administrator.'.$sales->sale_type);

                })
                ->addColumn('sale_date', function ($sales) {

                    return date('d-m-Y', strtotime($sales->sale_date));

                })
                ->editColumn('customer_id', function ($sales) {

                    return $sales->customer_name;

                })
                ->addColumn('customer_phone', function ($sales) {

                    return $sales->customer_phone;

                })
                ->addColumn('invoice_number', function ($sales) {

                    return $sales->invoice_number;

                })
                ->addIndexColumn()
                ->rawColumns(['invoice_number' => 'invoice_number', 'action' => 'action', 'customer_phone' => 'customer_phone'])
                ->make(true);
        }


        return view('administrator.reportsales-request.index',compact('customer'));

    }

}

