<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use DB;

use Auth;

use DataTables;

use App\Model\SupplierModel;

use App\Model\PurchaseDetailsModel;

use App\Model\PurchaseModel;

use App\Fun\Fun;
use Illuminate\Support\Facades\Gate;

class PurchaseController extends Controller

{

    function __construct()
    {
        $this->middleware('permission:Purchase List', ['only' => ['index']]);
        $this->middleware('permission:Purchase show', ['only' => ['show']]);
        Fun::lang();
    }
    public function index(Request $request)
    {

        if ($request->ajax()) {
            Fun::lang();
            $search = $request->input('search.value');
            $type = $request->type;
            $supplier = $request->supplier;
            $status = $request->status;
            $count_total = PurchaseModel::where(['nso007_purchases.status' => 1])
                ->count();
            $data = PurchaseModel::where(['nso007_purchases.status' => 1])
                ->where(function ($query) use ($type) {
                    if ($type) {
                        $query->Where('nso007_purchases.type', $type);
                    }

                })
                ->where(function ($query) use ($supplier) {
                    if ($supplier) {
                        $query->where('nso007_purchases.supplier_id', $supplier);
                    }
                })
                ->where(function ($query) use ($status) {
                    if ($status) {
                        $query->where('nso007_purchases.payment_status',$status);
                    }
                })
                ->where(function ($query) use ($search) {
                    $query->orWhere('nso007_purchases.invoice_number', 'LIKE', '%' . $search . '%');
                    $query->orWhere('nso007_purchases.transaction_code', 'LIKE', '%' . $search . '%');
                })
                ->orderBy('nso007_purchases.id', 'DESC');
            $count_filter = $data->count();
            return Datatables::of($data->take(20))
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->addColumn('supplier_name', function ($purchase) {
                    $sup = findSupplier($purchase->supplier_id);
                    return $sup?$sup->supplier_name:'';
                })
                ->addColumn('supplier_phone', function ($purchase) {
                    $sup = findSupplier($purchase->supplier_id);

                    return $sup?$sup->supplier_phone:'';
                })
                ->addColumn('paid', function ($purchase) {
                    $paid_kh = $purchase->paid_kh > 0 ? $purchase->paid_kh : 0;
                    $paid_usd = $purchase->paid_usd > 0 ? $purchase->paid_usd : 0;
                    $paid_baht = $purchase->paid_baht > 0 ? $purchase->paid_baht : 0;
                    $total_paid = ($paid_kh > 0 ? ($paid_kh / $purchase->rate) : 0) + $paid_usd + ($paid_baht > 0 ? ($paid_baht / $purchase->rate_baht) : 0);
                    return '$' . number_format($total_paid, 2);
                })
                ->addColumn('remain', function ($purchase) {
                    $paid_kh = $purchase->paid_kh > 0 ? $purchase->paid_kh : 0;
                    $paid_usd = $purchase->paid_usd > 0 ? $purchase->paid_usd : 0;
                    $paid_baht = $purchase->paid_baht > 0 ? $purchase->paid_baht : 0;
                    $total_paid = ($paid_kh > 0 ? ($paid_kh / $purchase->rate) : 0) + $paid_usd + ($paid_baht > 0 ? ($paid_baht / $purchase->rate_baht) : 0);
                    $total = getPurchaseTotal($purchase);
                    $remain = $total - $total_paid;
                    return '$' . number_format(($remain > 0 ? $remain : 0), 2);
                })
                ->addColumn('total', function ($purchase) {
                    return '$' . number_format(getPurchaseTotal($purchase), 2);

                })
                ->addColumn('purchase_date', function ($purchase) {

                    return date('d-m-Y', strtotime($purchase->purchase_date));

                })

                ->editColumn('payment_status', function ($sales) {
                    return checkPaymentStatus($sales->payment_status);
                })

                ->editColumn('type', function ($sales) {
                    return  __('administrator.'.$sales->type) ;
                })
                ->addColumn('action', function ($purchase) {
                    if(Gate::check('Purchase show'))
                    {
                        $btn_show =  '<a href="' . route("purchases.show", $purchase->id) . '" title="Show" class="button_warning">' . __('administrator.show') . '</a>';

                    }else{
                        $btn_show = '';
                    }
                    return $btn_show;

                })
                ->addIndexColumn()
                ->rawColumns([ 'action' => 'action', 'paid' => 'paid', 'remain' => 'remain', 'payment_status' => 'payment_status', 'total' => 'total', 'supplier_name' => 'supplier_name', 'supplier_phone' => 'supplier_phone'])
                ->make(true);

        }
        $purchase = PurchaseModel::groupBy('supplier_id')->pluck('supplier_id');
        $supplier = getSupplier(null,$purchase)->pluck('supplier_name','id');
        $type = PurchaseModel::groupBy('type')->pluck('type','type');
        foreach($type as $key =>$row){
            $type[$key]= __('administrator.'.$row);
        }
        return view('administrator.purchases.index',compact('supplier','type'));

    }

    public function show($id)

    {

        // Purchases

        $purchases = PurchaseModel::find($id);

        $supplier_id = $purchases->supplier_id;


        // Find Supplier Type

        $supplier_type = SupplierModel::join('nso007_supplier_type', 'nso007_supplier_type.id', '=', 'nso007_suppliers.supplier_type_id')
            ->where('nso007_suppliers.id', $supplier_id)
            ->first();
        // Purchase Details

        $purchase_details = PurchaseDetailsModel::select('nso007_suppliers.*', 'nso007_purchase_details.*', 'nso007_products.product_name')
            ->leftJoin('nso007_purchases', 'nso007_purchases.id', '=', 'nso007_purchase_details.purchase_id')
            ->leftJoin('nso007_products', 'nso007_products.id', '=', 'nso007_purchase_details.product_id')
            ->leftJoin('nso007_suppliers', 'nso007_suppliers.id', '=', 'nso007_purchases.supplier_id')
            ->where(['nso007_purchase_details.status' => 1,'nso007_purchase_details.purchase_id' => $id])
            ->get();

        return view('administrator.purchases.show', compact('purchase_details', 'purchases', 'supplier_type'));

    }

}

