<?php

namespace App\Http\Controllers\Administrator;

use App\Model\PaymentDetailModel;
use App\Model\PurchaseModel;
use App\Model\SupplierModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;

class PaymentReportController extends Controller
{

    public function index()
    {
        $suppliers = SupplierModel::pluck('supplier_name', 'id');
        return view('administrator.payment-report.index',compact('suppliers'));
    }
    function get_payment_report(Request $request){
        $search = $request->input('search.value');
        $count_total = PaymentDetailModel::select('nso007_payment_detail.id')
            ->join('nso007_payment','nso007_payment.id','nso007_payment_detail.payment_id')
            ->where('nso007_payment.type','purchase')
            ->where('nso007_payment_detail.payment_refunds','>',0)
            ->count();
        $count_filter =  PaymentDetailModel::select('nso007_payment_detail.id')
            ->join('nso007_payment','nso007_payment.id','nso007_payment_detail.payment_id')
            ->where('nso007_payment.type','purchase')
            ->where('nso007_payment_detail.payment_refunds','>',0)
            ->where(function($query) use ($search){
                $query->orWhere('nso007_payment.payment_invoice' , 'LIKE' , '%'.$search.'%');
            })
            ->count();
        $payment = PaymentDetailModel::select('nso007_payment_detail.*','nso007_payment.supplier_id','nso007_payment.payment_invoice','nso007_payment.payment_amount','nso007_payment.payment_status')
            ->join('nso007_payment','nso007_payment.id','nso007_payment_detail.payment_id')
            ->where('nso007_payment.type','purchase')
            ->where('nso007_payment_detail.payment_refunds','>',0)
            ->orderBy('nso007_payment.payment_invoice')
            ->get();
        if($request->isMethod('get')){
            return DataTables::of($payment)
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->addIndexColumn()
                ->addColumn('supplier_name',function($master_payment){
                    $sp = SupplierModel::find($master_payment->supplier_id);
                    return $sp!=null?$sp->supplier_name:'';
                })
                ->editColumn('amount',function($master_payment){
                    return '$'.$master_payment->payment_refunds;
                })
                ->editColumn('payment_amount',function($master_payment){
                    return '$'.$master_payment->payment_amount;
                })
                ->editColumn('payment_date',function($master_payment){
                    return date('d-m-Y',strtotime($master_payment->payment_date));
                })
                ->addColumn('supplier_phone',function($master_payment){
                    $sp = SupplierModel::find($master_payment->supplier_id);
                    return $sp!=null?$sp->supplier_phone:'';
                })
                ->addColumn('purchase_date',function($master_payment){
                    $sp = PurchaseModel::where('invoice_number',$master_payment->payment_invoice)->first();
                    return $sp!=null?date('d-m-Y',strtotime($sp->purchase_date)):'';
                })
                ->editColumn('payment_status',function($master_payment){
                    if(strtolower($master_payment->payment_status) == 'due'){
                        $status = '<span class="label label-danger">Due</span>';
                    }else{
                        $status = '<span class="label label-success">Paid</span>';
                    }
                    return $status;
                })
                ->rawColumns(['invoice_number' => 'invoice_number','supplier_name'=>'supplier_name','supplier_phone'=>'supplier_phone','purchase_date'=>'purchase_date','payment_status'=>'payment_status'])
                ->make(true);
        }else{
            $date = $request->search_date;
            $status = $request->status;
            $supplier_id = $request->supplier_id;
            $payment = PaymentDetailModel::select('nso007_payment_detail.*','nso007_suppliers.supplier_name','nso007_purchases.purchase_date','nso007_suppliers.supplier_phone','nso007_payment.payment_invoice','nso007_payment.payment_amount','nso007_payment.payment_status')
                ->join('nso007_payment','nso007_payment.id','nso007_payment_detail.payment_id')
                ->join('nso007_suppliers','nso007_suppliers.id','nso007_payment.supplier_id')
                ->join('nso007_purchases','nso007_purchases.invoice_number','nso007_payment.payment_invoice')
                ->where('nso007_payment.type','purchase')
                ->where(function ($q) use ($date){
                    if($date){
                        $q->where('nso007_purchases.purchase_date',date('Y-m-d',strtotime($date)));
                    }
                })
                ->where(function ($q) use ($status){
                    if($status){
                        $q->where('nso007_payment.payment_status',$status);
                    }
                })
                ->where(function ($q) use ($supplier_id){
                    if($supplier_id){
                        $q->where('nso007_payment.supplier_id',$supplier_id);
                    }
                })
                ->where('nso007_payment_detail.payment_refunds','>',0)
                ->orderBy('nso007_payment.payment_invoice')
                ->get();
            echo json_encode($payment);
        }
    }
    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        //
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {
        //
    }
}
