<?php

    namespace App\Http\Controllers\Administrator\Item;

    use App\Http\Controllers\Controller;
    use App\Model\product\ShelfModel;
    use Carbon\Carbon;
    use Illuminate\Http\Request;
    use Validator;
    use Yajra\DataTables\DataTables;
    use Auth;

    class ShelfController extends Controller
    {
        function __construct()
        {
            $this->middleware('permission:Shelf List', ['only' => ['index']]);
            $this->middleware('permission:Shelf Create', ['only' => ['create', 'store']]);
            $this->middleware('permission:Shelf Edit', ['only' => ['update', 'edit']]);
//            $this->middleware('permission:Shelf Delete', ['only' => ['index']]);
        }

        public function index(Request $request)
        {
            if ($request['delete']) {
                ShelfModel::find($request['delete'])->delete();
                return response()->json(['status' => 'ok']);
            }
            if ($request->ajax()) {
                $data = ShelfModel::latest()
                    ->take(20);
                $count = $data->count();
                return DataTables::of($data)
                    ->with([
                        "recordsTotal" => $count,
                        "recordsFiltered" => $count,
                    ])
                    ->addColumn('action', function ($action) {
                        if(!$action->member_id) {
                            $btn = '';
                            if (uCan('Shelf Edit')) {
                                $btn .= '<a data-href = "' . route("shelf.edit", $action->id) . '"  data-name="' . __('administrator.edit') . '" class="getHtmlForm fa fa-pencil btn btn-warning" title="' . __('administrator.edit') . '"></a>';
                            }
                            if (uCan('Shelf Delete')) {
                                $btn .= ' <a data-href = "' . route("shelf.index") . '?delete=' . $action->id . '" class="btn_delete fa fa-trash btn btn-danger" title="' . __('administrator.delete') . '"></a>';
                            }
                            return $btn;
                        }
                    })
                    ->editColumn('created_at', function ($action) {
                        return Carbon::parse($action->created_at)->format('d-m-Y');
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->make(true);
            }
            return view('administrator.item-setup.shelf.index');
        }

        public function create()
        {
            return view('administrator.item-setup.shelf.create');
        }

        public function edit($id)
        {
            $master = ShelfModel::find($id);
            return view('administrator.item-setup.shelf.edit', compact('master'));
        }

        public function store(Request $request)
        {
            return $this->update($request, null);
        }

        public function update(Request $request, $id)
        {
            $this->validate($request, [
                'name' => 'required|min:1|max:50|string|unique:nso007_shelf,name,' . $id,
                'note' => 'nullable|string|max:255',
            ]);
            $master = ShelfModel::updateOrCreate(['id' => $id], $request->all());
            if($request['input_name']){
                return response()->json(['value'=>$master->id,'text'=>$master->name,'input_name'=>$request['input_name']]);
            }
            return response()->json('ok');
        }
    }
