<?php

namespace App\Http\Controllers\Administrator\Item;

use App\Http\Controllers\Controller;
use App\Model\product\CategoryModel;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Validator;
use Yajra\DataTables\DataTables;
use Auth;

class CategoryController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Category List', ['only' => ['index']]);
        $this->middleware('permission:Category Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Category Edit', ['only' => ['update', 'edit']]);
//        $this->middleware('permission:Category Delete', ['only' => ['index']]);
    }

    public function index(Request $request)
    {
        if($request['delete']){
             CategoryModel::find($request['delete'])->delete();
             return response()->json(['status'=>'ok']);
        }
        if ($request->ajax()) {
            $data = CategoryModel::with('parent')
                ->selectRaw('parent_id, category_name as name, note, id, created_at, status')
                ->orderBy('id', 'desc')
                ->paginate(20);
            return DataTables::of($data->items())
                ->with([
                    "recordsTotal" => $data->count(),
                    "recordsFiltered" => $data->count(),
                ])
                ->addColumn('action', function ($action) {
                    $btn = '';
                    if (uCan('Category Edit')) {
                        $btn .= '<a data-href = "' . route("category.edit", $action->id) . '"  data-name="' .__('administrator.edit'). '" class="getHtmlForm fa fa-pencil btn btn-warning" title="' . __('administrator.edit') . '"></a>';
                    }
                    if (uCan('Category Delete')) {
                        $btn .= ' <a data-href = "' . route("category.index") . '?delete='.$action->id.'" class="btn_delete fa fa-trash btn btn-danger" title="' . __('administrator.delete') . '"></a>';
                    }
                    return $btn;
                })
                ->editColumn('parent', function ($action) {
                    return $action->parent ? $action->parent->category_name : '';
                })
                ->editColumn('created_at', function ($action) {
                    return Carbon::parse($action->created_at)->format('d-m-Y');
                })
                ->addIndexColumn()
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('administrator.item-setup.category.index');
    }
    public function create()
    {
        return view('administrator.item-setup.category.create');
    }
    public function edit($id)
    {
        $master = CategoryModel::find($id);
        return view('administrator.item-setup.category.edit',compact('master'));
    }
    public function store(Request $request)
    {
        return $this->update($request,null);
    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'category_name' => 'required|min:1|max:50|string|unique:nso007_category,category_name,'.$id,
            'note' => 'nullable|string|max:255',
        ]);
        $master=CategoryModel::updateOrCreate(['id'=>$id],$request->all());
        if($request['input_name']){
            return response()->json(['value'=>$master->id,'text'=>$master->category_name,'input_name'=>$request['input_name']]);
        }
        return response()->json('ok');
    }
    public function destroy($id)
    {
        CategoryModel::findOrFail($id)->update(['status' => 0]);
        return response()->json(['', 200]);
    }
}
