<?php

    namespace App\Http\Controllers\Administrator\Item;

    use App\Http\Controllers\Controller;
    use App\Model\product\BrandModel;
    use Carbon\Carbon;
    use http\Env\Response;
    use Illuminate\Http\Request;
    use Validator;
    use Yajra\DataTables\DataTables;
    use Auth;

    class BrandController extends Controller
    {
        function __construct()
        {
            $this->middleware('permission:Brand List', ['only' => ['index']]);
            $this->middleware('permission:Brand Create', ['only' => ['create', 'store']]);
            $this->middleware('permission:Brand Edit', ['only' => ['update', 'edit']]);
//            $this->middleware('permission:Brand Delete', ['only' => ['index']]);
        }

        public function index(Request $request)
        {
            if ($request['delete']) {
                BrandModel::find($request['delete'])->delete();
                return response()->json(['status' => 'ok']);
            }
            if ($request->ajax()) {
                $data = BrandModel::latest()
                    ->take(20);
                $count = $data->count();
                return DataTables::of($data)
                    ->with([
                        "recordsTotal" => $count,
                        "recordsFiltered" => $count,
                    ])
                    ->addColumn('action', function ($action) {
                        $btn = '';
                        if (uCan('Brand Edit')) {
                            $btn .= '<a data-href = "' . route("brand.edit", $action->id) . '"  data-name="' . __('administrator.edit') . '" class="getHtmlForm fa fa-pencil btn btn-warning" title="' . __('administrator.edit') . '"></a>';
                        }
                        if (uCan('Brand Delete')) {
                            $btn .= ' <a data-href = "' . route("brand.index") . '?delete=' . $action->id . '" class="btn_delete fa fa-trash btn btn-danger" title="' . __('administrator.delete') . '"></a>';
                        }
                        return $btn;
                    })
                    ->editColumn('created_at', function ($action) {
                        return Carbon::parse($action->created_at)->format('d-m-Y');
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->make(true);
            }
            return view('administrator.item-setup.brand.index');
        }

        public function create()
        {
            return view('administrator.item-setup.brand.create');
        }

        public function edit($id)
        {
            $master = BrandModel::find($id);
            return view('administrator.item-setup.brand.edit', compact('master'));
        }

        public function store(Request $request)
        {
            return $this->update($request, null);
        }

        public function update(Request $request, $id)
        {
            $this->validate($request, [
                'brand' => 'required|min:1|max:50|string|unique:nso007_product_brand,brand,' . $id,
                'note' => 'nullable|string|max:255',
            ]);
            $master = BrandModel::updateOrCreate(['id' => $id], $request->all());
            if($request['input_name']){
                return response()->json(['value'=>$master->id,'text'=>$master->brand,'input_name'=>$request['input_name']]);
            }
            return response()->json('ok');
        }
    }
