<?php


namespace App\Http\Controllers\Administrator;


use App\CurrencyModel;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use App\Model\HistoryCurrentcy;
use Auth;


class CurrencyController extends Controller

{


    public function index()

    {

        $currency = CurrencyModel::where('status', 1)->get();

        return view('administrator.currency.index', compact('currency'));

    }


    public function create()

    {

        return view('administrator.currency.create');

    }


    public function store(Request $request)

    {

        $this->validate($request, [

            'name' => 'required',

            'rate' => 'required',

            'code' => 'required',

            'symbol' => 'required',

        ]);

        $currency = new CurrencyModel();

        $currency->name = $request->name;

        $currency->rate = $request->rate;

        $currency->code = $request->code;

        $currency->symbol = $request->symbol;

        $currency->save();

        $history = new HistoryCurrentcy();
        $history->date = date('Y-m-d');
        $history->currency_id = $currency->id;
        $history->old_rate = $request->rate;
        $history->save();

        return redirect()->route('currency.index')->with('success', 'Currency was saved successful ...');

    }


    public function show($id)

    {

        //

    }


    public function edit($id)

    {

        $currency = CurrencyModel::find($id);

        return view('administrator.currency.edit', compact('currency'));

    }


    public function update(Request $request, $id)

    {

        $this->validate($request, [

            'name' => 'required',

            'rate' => 'required',

            'code' => 'required',

            'symbol' => 'required',

        ]);

        $currency = CurrencyModel::find($id);

        $currency->name = $request->name;
        $rate = $currency->rate;
        $currency->rate = $request->rate;

        $currency->code = $request->code;

        $currency->symbol = $request->symbol;

        $currency->save();
        $history = new HistoryCurrentcy();
        $history->date = date('Y-m-d');
        $history->currency_id = $currency->id;
        $history->old_rate = $rate;
        $history->save();
        return redirect()->route('currency.index')->with('success', 'Currency was updated successful ...');

    }


    public function currency_changeStatus(Request $request)
    {
        CurrencyModel::where(['default'=>1])->update(['default' => 0]);
        CurrencyModel::where(['default'=>0,'id'=>$request->id])->update(['default' => 1]);
        return response()->json(['success' => 'Status change successfully.']);
    }

    public function history()
    {
        $history = HistoryCurrentcy::get();
        return view('administrator.currency.history', compact('history'));

    }

}

