<?php


namespace App\Helpers;

use Request;

use App\LogActivity as LogActivityModel;


class LogActivity

{


    public static function addToLog($subject)

    {

    	$log = [];

    	$log['subject'] = $subject;

    	$log['url'] = Request::fullUrl();

    	$log['method'] = Request::method();

    	$log['ip'] = Request::getClientIp(true);

    	$log['agent'] = Request::header('user-agent');

    	$log['user_id'] = auth()->check() ? auth()->user()->id : 1;

    	LogActivityModel::create($log);

    }


    public static function logActivityLists()

    {

    	return LogActivityModel::with(array('get_user'=>function($query){
            $query->select('id','email');
        }))->get();


    }


}