<?php

namespace App\Console\Commands;

use App\Model\ItemRequestDetailModel;
use App\Model\PurchaseDetailsModel;
use App\Model\SaleDetailsModel;
use App\Model\StockByDateModel;
use App\Model\StockModel;
use Illuminate\Console\Command;

class GetDialyStock extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'run:daily-stock';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Daily Stock';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $stock = StockModel::get();
        $date = date('Y-m-d');
        foreach ($stock as $row) {
            $stock_out = SaleDetailsModel::join('nso007_sales', 'nso007_sales.id', 'nso007_sale_details.sale_id')
                ->join('nso007_product_unit', 'nso007_sale_details.product_id', 'nso007_product_unit.id')
                ->where(['nso007_sale_details.product_id' => $row->product_unit_id,'nso007_sales.warehouse_id' => $row->warehouse_id])
                ->where('nso007_sales.sale_date', $date)
                ->where(function ($q) {
                    $q->where('nso007_sale_details.type', NULL);
                    $q->orWhere('nso007_sale_details.type', "out");
                })
                ->selectRaw('SUM(IF(nso007_product_unit.unit_id=nso007_sale_details.unit_id,(nso007_sale_details.qty*nso007_product_unit.qty_per_unit),nso007_sale_details.qty)) as total_qty')
                ->groupby('nso007_sales.warehouse_id','nso007_sale_details.product_id','nso007_sale_details.shelf')
                ->first();
            $stock_in = SaleDetailsModel::join('nso007_sales', 'nso007_sales.id', 'nso007_sale_details.sale_id')
                ->join('nso007_product_unit', 'nso007_sale_details.product_id', 'nso007_product_unit.id')
                ->where(['nso007_sale_details.product_id' => $row->product_unit_id,'nso007_sales.to_warehouse' => $row->warehouse_id])
                ->where('nso007_sales.sale_date', $date)
                ->where(function ($q) {
                    $q->where('nso007_sale_details.type', NULL);
                    $q->orWhere('nso007_sale_details.type', "in");
                })
                ->selectRaw('SUM(IF(nso007_product_unit.unit_id=nso007_sale_details.unit_id,(nso007_sale_details.qty*nso007_product_unit.qty_per_unit),nso007_sale_details.qty)) as total_qty')
                ->groupby('nso007_sales.to_warehouse','nso007_sale_details.product_id','nso007_sale_details.shelf')
                ->first();


            $purchase = PurchaseDetailsModel::join('nso007_purchases', 'nso007_purchases.id', 'nso007_purchase_details.purchase_id')
                ->join('nso007_product_unit', 'nso007_purchase_details.product_unit_id', 'nso007_product_unit.id')
                ->where([
                    'nso007_purchase_details.product_unit_id' => $row->product_unit_id,
                    'nso007_purchases.warehouse_id' => $row->warehouse_id,
                    'nso007_purchases.status' => 1,
                ])
                ->where('nso007_purchases.purchase_date', $date)
                ->selectRaw('SUM(IF(nso007_product_unit.unit_id=nso007_purchase_details.unit_id,(nso007_purchase_details.qty*nso007_product_unit.qty_per_unit),nso007_purchase_details.qty)) as total_qty')
                ->groupby('nso007_purchases.warehouse_id','nso007_purchase_details.product_unit_id','nso007_purchase_details.shelf')
                ->first();


            $req_in  = ItemRequestDetailModel::join('nso007_item_request', 'nso007_item_request.id', 'nso007_item_request_detail.request_id')
                ->join('nso007_product_unit', 'nso007_item_request_detail.product_unit_id', 'nso007_product_unit.id')
                ->where([
                    'nso007_item_request_detail.product_unit_id' => $row->product_unit_id,
                    'nso007_item_request.to_warehouse' => $row->warehouse_id,
                    'nso007_item_request.status' => 1,
                    'nso007_item_request.confirm_status' => 1,
                ])
                ->where('nso007_item_request.request_date', $date)
                ->selectRaw('SUM(IF(nso007_product_unit.unit_id=nso007_item_request_detail.unit_id,(nso007_item_request_detail.qty*nso007_product_unit.qty_per_unit),nso007_item_request_detail.qty)) as total_qty')
                ->groupby('nso007_item_request.to_warehouse','nso007_item_request_detail.product_unit_id','nso007_item_request_detail.shelf')
                ->first();
            $req_out  = ItemRequestDetailModel::join('nso007_item_request', 'nso007_item_request.id', 'nso007_item_request_detail.request_id')
                ->join('nso007_product_unit', 'nso007_item_request_detail.product_unit_id', 'nso007_product_unit.id')
                ->where([
                    'nso007_item_request_detail.product_unit_id' => $row->product_unit_id,
                    'nso007_item_request.from_warehouse' => $row->warehouse_id,
                    'nso007_item_request.status' => 1,
                    'nso007_item_request.confirm_status' => 1,
                ])
                ->where('nso007_item_request.request_date', $date)
                ->selectRaw('SUM(IF(nso007_product_unit.unit_id=nso007_item_request_detail.unit_id,(nso007_item_request_detail.qty*nso007_product_unit.qty_per_unit),nso007_item_request_detail.qty)) as total_qty')
                ->groupby('nso007_item_request.to_warehouse','nso007_item_request_detail.product_unit_id','nso007_item_request_detail.shelf')
                ->first();
            $total_in = ($stock_in->total_qty??0)+($req_in->total_qty??0)+($purchase->total_qty??0);
            $total_out = ($stock_out->total_qty??0)+($req_out->total_qty??0);
            StockByDateModel::create([
                'product_unit_id' => $row->product_unit_id,
                'branch_id' => $row->branch_id,
                'shelf' => $row->shelf,
                'stock_out' => $total_out,
                'stock_in' => $total_in,
                'balance' => $row->stock_qty,
                'date' => $date,
            ]);

        }
        $this->info('Backup stock daily success!');

    }
}
