<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>

<script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>

<style>
   thead input {
       width: 100%;
   }
   input[type=text]{
       color: black;
   }
   .buttons-html5{background: coral !important;}
   .container {
    display: block;
    position: relative;
    padding-left: 35px;
    margin-bottom: 12px;
    cursor: pointer;
    font-size: 22px;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
  }
  
  /* Hide the browser's default checkbox */
  .container input {
    position: absolute;
    opacity: 0;
    cursor: pointer;
    height: 0;
    width: 0;
  }
  
  /* Create a custom checkbox */
  .checkmark {
    position: absolute;
    top: 0;
    left: 0;
    height: 20px;
    width: 22px;
    background-color: #eee;
    margin-left: 36%;
  }
  
  /* On mouse-over, add a grey background color */
   
  /* When the checkbox is checked, add a blue background */
  .container input:checked ~ .checkmark {
    background-color: #2196F3;
  }
  
  /* Create the checkmark/indicator (hidden when not checked) */
  .checkmark:after {
    content: "";
    position: absolute;
    display: none;
  }
  
  /* Show the checkmark when checked */
  .container input:checked ~ .checkmark:after {
    display: block;
  }
  
  /* Style the checkmark/indicator */
  .container .checkmark:after {
    left: 9px;
    top: 5px;
    width: 5px;
    height: 10px;
    border: solid white;
    border-width: 0 3px 3px 0;
    -webkit-transform: rotate(45deg);
    -ms-transform: rotate(45deg);
    transform: rotate(45deg);
  }
</style>

<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
	  <li class="active"><?php echo e(__('administrator.history_driver_list')); ?></li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                <?php echo Form::open(array('route' => 'history_driver_print','method'=>'POST')); ?>

                <div class="form-search">
                    <?php if(\Globals::is_Administrator() == 'Administrator'): ?>
                    <div class="form-group col-sm-2 col-xs-2">
                        <?php echo Form::select('drivers', $drivers, null, ['class' => 'form-control']); ?>

                    </div>
                    <?php endif; ?>

                    <div class="form-group col-sm-2 col-xs-2">
                        <select name="status[]" id="" multiple="multiple" class="form-control chosen-select" >
                            <option value=""> <?php echo e(__('administrator.please_choose')); ?> </option>
                            <option value="1">  <?php echo e(__('administrator.processing')); ?></option>
                            <option value="2">  <?php echo e(__('administrator.padding')); ?> </option>
                            <option value="3"> <?php echo e(__('administrator.done')); ?> </option>
                            <option value="4"> <?php echo e(__('administrator.cancel')); ?> </option>
                        </select>
                    </div>
                    <div class="form-group col-sm-2 col-xs-2">
                        <?php echo Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')); ?>

                    </div>
                    <div class="form-group col-sm-2 col-xs-2">
                        <?php echo Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')); ?>

                    </div>

                    <div class="form-group col-sm-2 col-xs-2">
                        <?php echo Form::text('driver_voucher',null, array('placeholder' => __('administrator.driver_voucher'),'class' => 'form-control')); ?>

                    </div>

                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button class="button_sm button_info pull-right " id='search' type="button"><span class="fa fa-search"></span> <?php echo e(__('administrator.searching')); ?> </button>
                            <button type="submit" class="button_sm button_info pull-right buttons-print"  style='display: none'><span class="fa fa-print"></span><?php echo e(__('administrator.print')); ?> </button>
                        </div>
                    </div>

                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th><?php echo e(__('administrator.no')); ?></th>
                    <th><?php echo e(__('administrator.date')); ?></th>
                    <th><?php echo e(__('administrator.driver_voucher')); ?></th>
                    <th><?php echo e(__('administrator.driver')); ?></th>
                    <th><?php echo e(__('administrator.shop_name')); ?></th>
                    <th><?php echo e(__('administrator.box_code')); ?></th>
                    <th><?php echo e(__('administrator.location')); ?></th>
                    <th><?php echo e(__('administrator.customer_receive')); ?></th>
                    <th><?php echo e(__('administrator.price')); ?></th>
                    <th><?php echo e(__('administrator.price_of_car')); ?></th>
                    <th><?php echo e(__('administrator.price_of_service')); ?></th>
                    
                    <th><?php echo e(__('administrator.total')); ?></th>
                    <th><?php echo e(__('administrator.reason')); ?></th>
                    <th  > 
                        <label class="container"> 
                            <input  type="checkbox"  name="check" class="checkbox_all" >
                            <span class="checkmark"></span>
                        </label></th> 
                    <th><a class="btn btn-success btn-xs fa fa-check-square-o show_all" href="#">  <?php echo e(__('administrator.pay')); ?></th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>



<div class="modal fade" id="show_item">
    <div class="modal-dialog">
        <div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">&times;</span>
					<span class="sr-only">Close</span>
				</button>
				<h4 class="modal-title" id="myModalLabel"><?php echo e(__('administrator.box_code_successful')); ?></h4>
			</div>
            <form  method="POST" action="#">
                <?php echo e(csrf_field()); ?>

                    <table class="account-payable table table-bordered table-striped table table-condensed table-hover">
                        <thead>
                            <tr>
                                <th>    <?php echo e(__('administrator.no')); ?>                  </th>
                                <th>    <?php echo e(__('administrator.box_code')); ?>            </th>
                                <th>    <?php echo e(__('administrator.location')); ?>            </th>
                                <th>    <?php echo e(__('administrator.customer_receive')); ?>    </th>
                                <th>    <?php echo e(__('administrator.price')); ?>               </th>
                                <th>    <?php echo e(__('administrator.delivery_fee')); ?>        </th>
                                <th>    <?php echo e(__('administrator.price_of_car')); ?>        </th>
                            </tr>
                        </thead>

                        <tbody class="tbody_1">

                        </tbody>
                    </table>

                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal"> <?php echo e(__('administrator.close')); ?></button>
                    <a href="#" class="fa fa-check btn btn-warning" id="submit"> <?php echo e(__('administrator.save')); ?></a>
                </div>
            </form>
		</div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script type="text/javascript">


    $('.show_al1l').on('click', function(e) {
        var export_id = [];
        var tbody_1 = '';
        $(".checkbox:checked").each(function() {
            export_id.push($(this).attr('data-export_id'));
        });
        export_id = export_id.join(",");
        $.ajax({
            url: "<?php echo e(route('clear-dirver.show',1)); ?>",
            type: 'GET',
            dataType: 'json',
            data: {
                export_id: export_id,
                _token: '<?php echo e(csrf_token()); ?>',
            },
            success: function(data) {
                $('.tbody_1').empty();
                var export_id = '';
                $.each(data,function(index,val){
                    export_id += val.export_id+',';
                    if(val.taxi_status == 1){
                        var buy_fee =   val.taxi_shop_fee;
                    }
                    else{
                        var buy_fee =     val.taxi_cust_fee;
                    }
                    str = val.date_delivery;
                    st2 = str.split("-");
                    yr = st2[0];
                    mo = st2[1];
                    dy = st2[2];
                    var date_delivery = dy+'-'+mo+'-'+yr;

                    tbody_1 += ` 
                        <tr>
                            <td>${(index+1)}</td>
                            <td>${date_delivery}</td>
                            <td>${val.merchant_name}</td>
                            <td>${val.box_code}</td>
                            <td>${val.driver_name}</td>  
                            <td>${val.inovice}</td>  
                            <td>$${val.customer_receive}</td>
                            <td>${val.location_name}</td>

                        </tr> 
                    `;
                });
              
                $.confirm({ 
                    title: 'd', 
                    content: `
                    <table id="datatable_income" width="100%" class="table table-striped table-hover  " style="overflow:hidden ; text-align: center ; background: #2774c2 ">
                        <thead>
                            <tr>
                                <th><?php echo e(__("administrator.no")); ?></th>
                                <th><?php echo e(__("administrator.date")); ?></th>
                                <th><?php echo e(__("administrator.shop_name")); ?></th>
                                <th><?php echo e(__("administrator.box_code")); ?></th> 
                                <th><?php echo e(__("administrator.driver")); ?></th>
                                <th><?php echo e(__("administrator.driver_voucher")); ?></th>
                                <th><?php echo e(__("administrator.customer_receive")); ?></th> 
                                <th><?php echo e(__("administrator.location")); ?></th> 
                            </tr>
                        </thead>
                        <tbody class="tbody">
                            ${tbody_1}
                        </tbody>
                    </table>`,

                    boxWidth: '60%',
                    useBootstrap: false, 
                    scrollToPreviousElement:false, 
                     
                });
            
            }
        });

        
    });
    $('.show_all').on('click', function(e) { 
        var export_id = [];
        var tbody_1 = '';
        $(".checkbox:checked").each(function() {
            export_id.push($(this).attr('data-export_id'));
        });
        export_id = export_id.join(",");
        $.confirm({
            content: function () {
                var self = this;
                return $.ajax({
                    url: "<?php echo e(route('clear-dirver.show',1)); ?>",
                    dataType: 'json',
                    method: 'get',
                    data: {
                        export_id: export_id,
                        _token: '<?php echo e(csrf_token()); ?>',
                    },
                }).done(function (data) {
                    $('.tbody_1').empty();
                    var export_id = '';
                    $.each(data,function(index,val){
                        export_id += val.export_id+',';
                        if(val.taxi_status == 1){
                            var buy_fee =   val.taxi_shop_fee;
                        }
                        else{
                            var buy_fee =     val.taxi_cust_fee;
                        }
                        str = val.date_delivery;
                        st2 = str.split("-");
                        yr = st2[0];
                        mo = st2[1];
                        dy = st2[2];
                        var date_delivery = dy+'-'+mo+'-'+yr;

                        tbody_1 += ` 
                            <tr>
                                <td>${(index+1)}</td>
                                <td>${date_delivery}</td>
                                <td>${val.merchant_name}</td>
                                <td>${val.box_code}</td>
                                <td>${val.driver_name}</td>  
                                <td>${val.inovice}</td>  
                                <td>$${val.customer_receive}</td>
                                <td>${val.location_name}</td>

                            </tr> 
                        `;
                    });
               
                    self.setContent(`<table id="datatable_income" width="100%" class="table table-striped table-hover  " style="overflow:hidden ; text-align: center ; background: #2774c2 ">
                        <thead>
                            <tr>
                                <th><?php echo e(__("administrator.no")); ?></th>
                                <th><?php echo e(__("administrator.date")); ?></th>
                                <th><?php echo e(__("administrator.shop_name")); ?></th>
                                <th><?php echo e(__("administrator.box_code")); ?></th> 
                                <th><?php echo e(__("administrator.driver")); ?></th>
                                <th><?php echo e(__("administrator.driver_voucher")); ?></th>
                                <th><?php echo e(__("administrator.customer_receive")); ?></th> 
                                <th><?php echo e(__("administrator.location")); ?></th> 
                            </tr>
                        </thead>
                        <tbody class="tbody">
                            ${tbody_1}
                        </tbody>
                    </table>`);
                  
                }).fail(function(){
                    self.setContent('Something went wrong.');
                });
            },
            boxWidth: '60%',
            useBootstrap: false, 
            scrollToPreviousElement:false, 
        })
       
    });

    $('.checkbox_all').on('click', function(e) {
        if ($(this).is(':checked', true)) {
            $(".checkbox").prop('checked', true);
        } else {
            $(".checkbox").prop('checked', false);
        }
    });
 
    $(document).on('change','select[name="drivers"]',function(){
        if($(this).val() != ''){
            $('.buttons-print').show();
        }
        else{
            $('.buttons-print').hide();

        }
    });
    $(document).ready(function(){
        dataTableAjax(); 
    });
 
    $(document).on('click', '#search', function(){ 
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var drivers = $('select[name="drivers"]').val();
        var status = $('select[name="status[]"]').val(); 
        var driver_voucher = $('input[name="driver_voucher"]').val(); 
        $('#datatable_income').DataTable().destroy();  
        dataTableAjax(from_date, to_date, drivers,status,driver_voucher); 
    });

    function dataTableAjax(from_date= '', to_date= '', drivers= '',status='',driver_voucher=''){ 
        $('#datatable_income').DataTable({
            "oLanguage": {
                "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                "oPaginate": {
                    "sFirst": "<?php echo e(__('administrator.first')); ?>",
                    "sLast": "<?php echo e(__('administrator.last')); ?>",
                    "sNext": "<?php echo e(__('administrator.next')); ?>",
                    "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax:{
                url: "<?php echo e(route('clear-dirver.index')); ?>", 
                data:{                       
                    from_date:from_date, 
                    to_date:to_date, 
                    drivers:drivers,
                    status:status,
                    driver_voucher:driver_voucher
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'delivery_date'},
                    {data: 'driver_voucher'},
                    {data: 'driver_name'},
                    {data: 'shop_name'},
                    {data: 'box_code'},
                    {data: 'name_location'},
                    {data: 'customer_receive'},
                    {data: 'price'},
                    {data: 'taxi_fee'},
                    {data: 'delivery_fee'},
                    // {data: 'extra_fee'},
                    {data: 'total'},
                    {data: 'reason'},
                    {data: 'checkbox'},
                    {data: 'status'},
                ],
                orderCellsTop: true,
                fixedHeader: true, 
        });
    }
      
</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/clear-invoice-driver/index.blade.php ENDPATH**/ ?>