<?php Fun::lang()?>
<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <title>ប្រព័ន្ធដឹកជញ្ជូន</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="<?php echo e(asset('images/logo.png')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('assets/mobile/css/stylemobile.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/mobile/css/jquery-confirm.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('assets/font-awesome-4.7.0/css/font-awesome.css')); ?>">
    
    <script src="<?php echo e(asset('assets/js/jquery3.4.1.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/mobile/js/jquery-confirm.js')); ?>"></script>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">

</head>

<body>

        <?php if($message = Session::get('success')): ?>
        <div class="alert-message alert-success">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <i class="fa fa-check"></i>
            <h3>Success</h3>
            <p><?php echo e($message); ?></p>
        </div>
        <?php endif; ?> <?php if($message = Session::get('danger')): ?>
        <div class="alert-message alert-danger">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <i class="fa fa-exclamation-triangle"></i>
            <h3>Errors</h3>
            <p><?php echo e($message); ?></p>
        </div>
        <?php endif; ?> <?php if($message = Session::get('warning')): ?>
        <div class="alert-message alert-warning">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <i class="fa fa-exclamation-triangle"></i>
            <h3>Warning</h3>
            <p><?php echo e($message); ?></p>
        </div>
        <?php endif; ?> <?php if(count($errors) > 0): ?>
        <div class="alert-message  alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.
            <br>
            <br>
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>
        <div class="header sticky">
            <div class="container">
                <div class="main-menu">
                    <div class="col-md-8 col-sm-8 col-xs-7">
                        <div class="head-title">
                            <?php
                                $branch = DB::table('nso007_branch')->find(1);
                            ?>
                            <h3><?php echo e($branch->company_name); ?></h3>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-5">
                        <div class="head-icon">
                            <div class="notification">
                                <div  class="dropdown-acc">
                                    <div class="account-img">
                                        <img src="<?php echo e(asset('images/upload')); ?>/<?php echo e(\Auth::user()->avartar); ?>" alt="">
                                    </div>
                                </div>
                                <div class="mobile-acc is-visible">
                                    <li>
                                        <a href="#">
                                            <i class="fa fa-user">
                                                <?php echo e(\Auth::user()->name); ?>

                                            </i>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><span
                                                        class="fa fa-sign-out"></span> Sign out</a>
                                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                            <?php echo e(csrf_field()); ?>

                                        </form>
                                    </li>
                                </div>
                            </div>
                            <div class="notification">
                                <div  class="Dropdown-trigger">
                                    <i class="fa fa-bell-o"></i>
                                </div>
                                <!-- <div class="mobile-bell is-visible">
                                    <h4>Notification</h4>
                                    <div class="border-bottom">
                                        <div class="title-item">
                                            1. Call and Schedule another meeting
                                        </div>
                                        <div class="icon-item">
                                            <a href="#"><i class="fa fa-times-circle"></i></a>
                                        </div>
                                    </div>
                                    <div class="border-bottom">
                                        <div class="title-item">
                                            2. Don't forget to send in financial reports.
                                        </div>
                                        <div class="icon-item">
                                            <a href="#"><i class="fa fa-times-circle"></i></a>
                                        </div>
                                    </div>
                                    <div class="border-bottom">
                                        <div class="title-item">
                                            3. new guest account have been created.
                                        </div>
                                        <div class="icon-item">
                                            <a href="#"><i class="fa fa-times-circle"></i></a>
                                        </div>
                                    </div>
                                </div> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="menu-mobile">
            <ul>
                <li>
                    <a href="<?php echo e(route('onDeliveryToDay')); ?>">
                        <i class="fa fa-taxi">
                            <span class="menu-text">កំពុងដឹក</span>
                        </i>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('deliveryToSuccessful')); ?>">
                        <i class="fa fa-book">
                            <span class="menu-text">ដឹករួចរាល់</span>
                        </i>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('dashboard_merchant')); ?>" class="mobile-home">
                        <i class="fa fa-home">
                            <span class="menu-text">Home</span>
                        </i>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('dailyDelivery')); ?>">
                        <i class="fa fa-heart-o">
                            <span class="menu-text">ដឹកប្រចាំថ្ងៃ</span>
                        </i>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('dailyCommission')); ?>">
                        <i class="fa fa-archive">
                            <span class="menu-text">ទំនិញក្នងស្តុក</span>
                        </i>
                    </a>
                </li>
            </ul>
        </div>
        <div class="bg-loading" id="ajax-loading">
            <div class="lds-ring">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
            <div class="text-loading text-center">
                <span><b>ប្រព័ន្ធដឹកជញ្ជូន</b></span>
            </div>
        </div>
        <?php echo $__env->yieldContent('content'); ?>


</body>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('js/select2/select2.css')); ?>">
<script src="<?php echo e(asset('js/select2/select2.min.js')); ?>"></script>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('js/datepicker/datepicker.min.css')); ?>">
<script src="<?php echo e(asset('js/datepicker/datepicker.min.js')); ?>"></script>
<link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
<script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
<?php echo $__env->yieldContent('script'); ?>
<script>

    $('.Dropdown-trigger').on('click', function(){
        $('.mobile-bell').toggle();
    });
    $('.dropdown-acc').on('click', function(){
        $('.mobile-acc').toggle();
    });

    var loc = window.location.pathname;
    $('#nav').find('a').each(function() {
        $(this).toggleClass('active', $(this).attr('href') == loc);
    });
</script>


<script type="text/javascript">
    $('input[type=text]').prop('autocomplete', 'off');
    // Number Only
    $(document).on('keypress', '.number-only', function(e) {
        if (isNaN(this.value + "" + String.fromCharCode(e.charCode))) return false;
    });
    //Date Picker
    $(".date_picker").datepicker({
        dateFormat: "dd-mm-yy",
        changeMonth: true,
        changeYear: true,
    });

    jQuery(function($){

        if("km" == "<?php echo e(Fun::lang()); ?>"){
            $.datepicker.regional['km'] = {
                closeText: 'រួច​រាល់',
                prevText: 'ថយ​ក្រោយ',
                nextText: 'ទៅ​មុខ',
                currentText: 'ថ្ងៃ​នេះ',
                monthNames: ['ខែ​មករា','ខែ​កុម្ភៈ','ខែ​មិនា','ខែ​មេសា','ខែ​ឧសភា','ខែ​មិថុនា',
                'ខែ​កក្កដា','ខែ​សីហា','ខែ​កញ្ញា','ខែ​តុលា','ខែ​វិច្ឆិកា','ខែ​ធ្នូ'],
                monthNamesShort: ['មក', 'កុ', 'មិនា', 'មេ', 'ឧស', 'មិថុ',
                'កក្ក', 'សី', 'កញ្ញា', 'តុលា', 'វិច្ឆិ', 'ធ្នូ'],
                dayNames: ['ថ្ងៃ​អាទិត្យ', 'ថ្ងៃ​ចន្ទ', 'ថ្ងៃ​អង្គារ', 'ថ្ងៃ​ពុធ', 'ថ្ងៃ​ព្រហស្បត្តិ៍', 'ថ្ងៃ​សុក្រ', 'ថ្ងៃ​សៅរ៍'],
                dayNamesShort: ['អា', 'ចន្ទ', 'អង្គ', 'ពុធ', 'ព្រហ', 'សុ', 'សៅរ៍'],
                dayNamesMin: ['អា','ច','អ','ពុ','ព្រ','សុ','ស'],
                weekHeader: 'Wk',
                dateFormat: 'dd/mm/yy',
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ''};
                $.datepicker.setDefaults($.datepicker.regional['km']);
        }
    });

    $('select').select2();
    window.setTimeout(function() {
        $(".alert-message").fadeOut({
            opacity: 0
        }, 15000).hide('slow');
    }, 4000);

    $("div.alert-message").on("click", "button.close", function() {
        $(this).parent().fadeOut({
            opacity: 0
        }, 15000).hide('slow');
    });
    $('.bg-loading').hide();
    $(document).on({
        ajaxStart: function() {
            $('.bg-loading').show();
        },
        ajaxStop: function() {
            $('.bg-loading').hide();
        }
    });
</script>
</body>
</html>
<?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/layouts/app-mobile-merchant.blade.php ENDPATH**/ ?>