<?php $__env->startSection('content'); ?>
    <?php Fun::lang(); ?>
    <script src="<?php echo e(asset('assets/print_this/printThis.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/report/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/report/jquery-3.5.1.js')); ?>"></script>

    <style>
        thead input {
            width: 100%;
        }

        input[type=text] {
            color: black;
        }

        .buttons-html5 {
            background: coral !important;
        }

        div.dt-button-collection {
            width: 60px !important;
            padding: 1px 1px 1px 1px !important;
            box-shadow: none !important;

        }

        .dt-button {
            color: black !important;
        }

        .redClass td {
            background: #c8ddc8;
        }
    </style>


    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
            <li class="active">Shop Voucher</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="col-md-4 mb-3">
                <label for=""><?php echo e(__('administrator.shop_name')); ?></label>
                <div class="form-group">
                    <?php echo Form::select('shop', $shop, null, [
                        'placeholder' => __('administrator.please_select'),
                        'class' => 'form-control shop_id',
                    ]); ?>

                </div>
            </div>
            <div class="col-md-8 mb-3" style="text-align: right">
                <label for="" style="opacity: 0">a</label><br>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Clear All Shop Voucher')): ?>
                    <span class="btn btn-sm btn-primary clear-all" style="display: none">Clear All</span>
                <?php endif; ?>



                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Export Shop Voucher')): ?>
                    <span class="btn btn-sm btn-info btn-print-qty">Excel QTY</span>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Export Shop Voucher')): ?>
                    <span class="btn btn-sm btn-info btn-print-excel-shop">Excel Shop</span>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Clear All Shop Voucher')): ?>
                    <span class="btn btn-sm btn-primary clear-multi-shop">Clear Multi Shop</span>
                <?php endif; ?>
            </div>
            <div class="table-responsive" style="float: left;">
                <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
                    <thead>
                        <tr>
                            <th width="2%"><?php echo e(__('administrator.no')); ?></th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Clear All Shop Voucher')): ?>
                                <th width="2%">All<input type="checkbox" id="parent" name="scales"></th>
                            <?php endif; ?>
                            <th width="10%"><?php echo e(__('administrator.date')); ?></th>
                            <th><?php echo e(__('administrator.shop_name')); ?></th>
                            <th><?php echo e(__('administrator.phone')); ?></th>
                            <th>Qty Box</th>
                            
                            <th><?php echo e(__('administrator.action')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function() {
            dataTableAjax();
        });
        $(document).on('click', '#parent', function(e) {
            let shop_id = $('.shop_id').val();
            if (!shop_id) {
                e.preventDefault();
            } else {
                if ($(this).is(':checked')) {
                    $(document).find('.sub').prop('checked', true);
                } else {
                    $(document).find('.sub').prop('checked', false);
                }
            }
        });
        $(document).on('click', '.btn-print-excel', function() {
            let shop_id = $('.shop_id').val();
            let per_page = $('select[name=datatable_income_length] :selected').val();
            let route = '<?php echo e(route('shop-voucher-excel')); ?>' + '?shop_id=' + shop_id + '&per_page=' + per_page;
            $.confirm({
                title: '',
                columnClass: 'xl',
                closeIcon: true,
                theme: "bootstrap",
                draggable: true,
                loading: false,
                content: function() {
                    var self = this;
                    return $.ajax({
                        url: route,
                        dataType: 'JSON',
                        method: 'get',
                    }).done(function(response) {
                        self.setContent(response.view);

                    }).fail(function() {
                        self.setContent('Something went wrong.');
                    });
                },
                buttons: {
                    cancel: function() {

                    },
                    printThis: {
                        text: 'Print',
                        btnClass: 'btn-blue',
                        action: function() {
                            document.title = 'Report-<?php echo e(date('d-m-Y')); ?>';
                            $('#tblData').printThis({
                                beforePrint: function() {

                                },
                                afterPrint: function() {

                                }
                            });
                        },
                    },
                    somethingElse: {
                        text: 'Excel',
                        btnClass: 'btn-success',
                        action: function() {
                            window.open(route + '&export_excel=export', '_blank');
                            // tableToExcel('tblData', 'Report-<?php echo e(date('d-m-Y')); ?>');
                        },
                    },
                }
            });
        });
        $(document).on('click', '.btn-print-excel-shop', function() {
            let shop_id = $('.shop_id').val();
            let per_page = $('select[name=datatable_income_length] :selected').val();
            let route = '<?php echo e(route('shop-voucher-excel-shop')); ?>' + '?shop_id=' + shop_id + '&per_page=' + per_page;
            $.confirm({
                title: '',
                columnClass: 'xl',
                closeIcon: true,
                theme: "bootstrap",
                draggable: true,
                loading: false,
                content: function() {
                    var self = this;
                    return $.ajax({
                        url: route,
                        dataType: 'JSON',
                        method: 'get',
                    }).done(function(response) {
                        self.setContent(response.view);

                    }).fail(function() {
                        self.setContent('Something went wrong.');
                    });
                },
                buttons: {
                    cancel: function() {

                    },
                    printThis: {
                        text: 'Print',
                        btnClass: 'btn-blue',
                        action: function() {
                            document.title = 'Report-<?php echo e(date('d-m-Y')); ?>';
                            $('#tblData').printThis({
                                beforePrint: function() {

                                },
                                afterPrint: function() {

                                }
                            });
                        },
                    },
                    somethingElse: {
                        text: 'Excel',
                        btnClass: 'btn-success',
                        action: function() {
                            window.open(route + '&export_excel=export', '_blank');
                            // tableToExcel('tblData', 'Report-<?php echo e(date('d-m-Y')); ?>');
                        },
                    },
                }
            });
        });

        $(document).on('click', '.btn-print-qty', function() {
            let shop_id = $('.shop_id').val();
            let per_page = $('select[name=datatable_income_length] :selected').val();
            let route = '<?php echo e(route('shop-voucher-excel-qty')); ?>' + '?shop_id=' + shop_id + '&per_page=' + per_page;
            $.confirm({
                title: '',
                columnClass: 'xl',
                closeIcon: true,
                theme: "bootstrap",
                draggable: true,
                loading: false,
                content: function() {
                    var self = this;
                    return $.ajax({
                        url: route,
                        dataType: 'JSON',
                        method: 'get',
                    }).done(function(response) {
                        self.setContent(response.view);

                    }).fail(function() {
                        self.setContent('Something went wrong.');
                    });
                },
                buttons: {
                    cancel: function() {

                    },
                    printThis: {
                        text: 'Print',
                        btnClass: 'btn-blue',
                        action: function() {
                            document.title = 'Report-<?php echo e(date('d-m-Y')); ?>';
                            $('#tblData').printThis({
                                beforePrint: function() {

                                },
                                afterPrint: function() {

                                }
                            });
                        },
                    },
                    somethingElse: {
                        text: 'Excel',
                        btnClass: 'btn-success',
                        action: function() {
                            window.open(route + '&export_excel=export', '_blank');
                            // tableToExcel('tblData', 'Report-<?php echo e(date('d-m-Y')); ?>');
                        },
                    },
                }
            });
        });

        var tableToExcel = (function() {
            var uri = 'data:application/vnd.ms-excel;base64,',
                template =
                '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--><meta http-equiv="content-type" content="text/plain; charset=UTF-8"/></head><body><table>{table}</table></body></html>',
                base64 = function(s) {
                    return window.btoa(unescape(encodeURIComponent(s)))
                },
                format = function(s, c) {
                    return s.replace(/{(\w+)}/g, function(m, p) {
                        return c[p];
                    })
                }
            return function(table, name) {

                if (!table.nodeType) table = document.getElementById(table)
                var xlsx = {
                    worksheet: name || 'Worksheet',
                    table: table.innerHTML
                }
                // window.location.href = uri + base64(format(template, xlsx))
                var a = document.createElement('a');
                a.href = uri + base64(format(template, xlsx));
                a.download = name;
                a.click();
            }
        })()
        $(document).on('click', '.clear-all', function() {
            let condition = false;
            let shop_id = $('.shop_id').val();
            let route = '<?php echo e(route('report-for-shop-new.print', ':id')); ?>';
            route = route.replace(':id', shop_id);
            let date = '';
            $.each($('.sub'), function(i, val) {
                let check = $(this).is(':checked');
                let commas = ',';
                if (check == true) {
                    condition = true;
                    date += $(this).data('date') + ',';
                }
            });
            if (!condition) {
                alert('Please Select Shop To Clear');
                return;
            }
            route = route + '?date=' + date;
            $.confirm({
                title: 'Clear All',
                content: 'Do you want to clear all ?',
                type: 'blue',
                typeAnimated: true,
                buttons: {
                    tryAgain: {
                        text: 'Clear',
                        btnClass: 'btn-blue',
                        action: function() {
                            $.get(route.replace(':id', shop_id), {
                                    print_out: "print_out"
                                },
                                function(data, textStatus, jqXHR) {
                                    Toast.fire({
                                        icon: 'success',
                                        title: 'Clear Successfully !'
                                    });
                                    $('#datatable_income').DataTable().ajax.reload();
                                },
                            );
                        }
                    },
                    close: {
                        text: 'Close',
                        btnClass: 'btn-danger',
                        action: function() {

                        }
                    },
                }
            });
        });
        $(document).on('click', '.clear-multi-shop', function() {
            let check = false;
            let arr = [];
            $.each($('.sub'), function(i, v) {
                if ($(this).is(":checked")) {
                    check = true;
                    arr.push({
                        'merchant_id': $(this).data('merchant_id'),
                        'date': $(this).data('date'),
                    });
                }
            });
            if (!check) {
                $.alert("Please Check Shop !");
                return false;
            }
            $.confirm({
                title: 'Clear Multi Shop',
                content: 'Do you want to clear multi shop ?',
                type: 'blue',
                typeAnimated: true,
                buttons: {
                    tryAgain: {
                        text: 'Clear',
                        btnClass: 'btn-blue',
                        action: function() {
                            $.ajax({
                                type: "POST",
                                url: "<?php echo e(route('clear-multi-shop')); ?>",
                                data: {
                                    'obj': arr,
                                    _token: '<?php echo e(csrf_token()); ?>'
                                },
                                dataType: "JSON",
                                success: function(data) {
                                    if (data.status == 200) {
                                        $('#datatable_income').DataTable().ajax.reload();
                                        $('.content-wrapper').prepend(`<div class="alert-message alert-success">
                                            <button type="button" class="close" data-dismiss="alert">×</button>
                                            <i class="fa fa-check"></i>
                                            <h3>Success</h3>
                                            <p>` + data.message + `</p>
                                        </div>`);
                                        window.setTimeout(function() {
                                            $(".alert-message").fadeOut({
                                                opacity: 0
                                            }, 15000).hide('slow');
                                        }, 4000);

                                        $("div.alert-message").on("click", "button.close",
                                            function() {
                                                $(this).parent().fadeOut({
                                                    opacity: 0
                                                }, 15000).hide('slow');
                                            });
                                    }
                                }
                            });
                        }
                    },
                    close: {
                        text: 'Close',
                        btnClass: 'btn-danger',
                        action: function() {

                        }
                    },
                }
            });

        });
        $(document).on("click", ".sub", function() {
            // let check = false;
            // $.each($('.sub'), function (i, v) {
            //     if($(this).is(":checked")){
            //         check = true;
            //     }
            // });
            // if(check){
            //     $('.clear-multi-shop').css('display','');
            // }else{
            //     $('.clear-multi-shop').css('display','none');
            // }
        });
        $(document).on('change', '.shop_id', (evt) => {
            let shop_id = $('.shop_id').val();
            if (shop_id) {
                $('.clear-all').css('display', '');
            } else {
                $('.clear-all').css('display', 'none');
            }


            dataTableAjax('', '', shop_id, '', '');
        })
        $(document).on('click', '.bt-clear', function() {
            let route = $(this).data('route');
            $.confirm({
                title: 'Clear Payment With Shop',
                content: 'Do You Want To Clear ?',
                type: 'blue',
                typeAnimated: true,
                buttons: {
                    tryAgain: {
                        text: 'Clear',
                        btnClass: 'btn-blue',
                        action: function() {
                            $.get(route, {
                                    print_out: "print_out"
                                },
                                function(data, textStatus, jqXHR) {
                                    Toast.fire({
                                        icon: 'success',
                                        title: 'Clear Successfully !'
                                    });
                                    $('#datatable_income').DataTable().ajax.reload();
                                },
                            );
                        }
                    },
                    close: {
                        text: 'Close',
                        btnClass: 'btn-danger',
                        action: function() {

                        }
                    },
                }
            });

        })

        function dataTableAjax(from_date = "<?php echo e(date(' Y-m-d')); ?>", to_date = "<?php echo e(date(' Y-m-d')); ?>", merchant = '',
            status = '', filter_date = 1) {
            $('#datatable_income').DataTable().destroy();
            var table = $('#datatable_income').DataTable({
                "oLanguage": {
                    "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                    "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                    "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                    "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                    "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                    "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                    "oPaginate": {
                        "sFirst": "<?php echo e(__('administrator.first')); ?>",
                        "sLast": "<?php echo e(__('administrator.last')); ?>",
                        "sNext": "<?php echo e(__('administrator.next')); ?>",
                        "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                    },
                },
                ordering: false,
                serverSide: true,
                lengthMenu: [
                    [150, 200, 500, 1000, -1],
                    [150, 200, 500, 1000, 'All']
                ],
                ajax: {
                    url: "<?php echo e(route('report-for-shop-new.index')); ?>",
                    data: {
                        from_date: from_date,
                        to_date: to_date,
                        merchant: merchant,
                        status: status,
                    }
                },
                buttons: [{
                        extend: 'pageLength',
                        text: 'show',
                        className: 'buttons-html5',
                    },
                    {
                        extend: 'excelHtml5',
                        title: 'Report Delivery',
                        autoFilter: true,
                        sheetName: 'Exported data',
                        customize: function(xlsx) {
                            var sheet = xlsx.xl.worksheets['sheet1.xml'];
                            $('row c[r*="2"]', sheet).attr('s', '25');
                            $('row c[r^="C"]', sheet).each(function() {

                            });
                        }
                    },
                ],
                columns: [{
                        data: 'DT_RowIndex',
                        'searchable': false
                    },
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Clear All Shop Voucher')): ?>
                        {
                            data: 'clear_all',
                            'searchable': false
                        },
                    <?php endif; ?> {
                        data: 'date_',
                        'searchable': false
                    },
                    {
                        data: 'shop_name',
                        name: 'shop_name',
                        'searchable': true
                    },
                    {
                        data: 'phone',
                        name: 'phone',
                        'searchable': true
                    },
                    {
                        data: 'status',
                        'searchable': false
                    },
                    // {data: 'pay_to_shop' , 'searchable': false},
                    {
                        data: 'action',
                        'searchable': false
                    },

                ],
                orderCellsTop: true,
                fixedHeader: true,


                "createdRow": function(row, data, dataIndex) {

                    if (data.success >= 1) {
                        $(row).addClass('redClass');
                    }
                }
            });

            $(document).find('.dataTables_filter').prepend(`

                                                <label style="border: solid #ffe4e4 2px;">
                                                    <space class="text-primary">Processing</space>&nbsp; ,
                                                    <space class="text-success">Success</space>&nbsp;,
                                                    <space class="text-warning"> Pending</space>&nbsp;,
                                                    <space class="text-danger">Cancel</space>&nbsp;,
                                                    <space class="text-info">Return to Shop</space>&nbsp;
                                                </label>&nbsp;&nbsp; `);

        }

        $(document).on('change', '.staff_id', function() {
            var id = $(this).val();
            var from_date = $('input[name="from_date"]').val();
            var to_date = $('input[name="to_date"]').val();
            var staff = $(this);
            $.ajax({
                type: 'POST',
                dataType: "json",
                url: "<?php echo e(route('get_merchant_in_report_delivery')); ?>",
                data: {
                    "id": id,
                    "from_date": from_date,
                    "to_date": to_date,
                    "_token": '<?php echo e(csrf_token()); ?>',
                },
                success: function(data) {
                    staff.closest('form').find('.merchant').html(data);

                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/report/shop-new/index.blade.php ENDPATH**/ ?>