
<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="/"><?php echo e(__('administrator.dashboard')); ?></a></li>
	  <li class="active"> <?php echo e(__('administrator.delivery')); ?></li>
	  <li class="active"><?php echo e(__('administrator.driver_voucher')); ?></li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> <?php echo e(__('administrator.driver_voucher')); ?></h3>
	                </div>
	                <div class="pull-right">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Clear Voucher')): ?>
                            <span class="btn btn-sm btn-primary clear-multi-driver">Clear Multi Driver</span>
                        <?php endif; ?>
                    
	                </div>
	            </div>
	        </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for=""><?php echo e(__('administrator.driver')); ?></label>
                    <?php echo Form::select('driver_id', compressDriver(), null, ['class' => 'form-control','placeholder'=>__('administrator.please_select')]); ?>

                </div>
            </div>
	    </div>
    </div>
    <div class="wrapper-table ">
        <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
            <thead>
            <tr>
                <th style="width: 5% !important"><?php echo e(__('administrator.no')); ?></th>
                <th style="width: 5% !important">
                    <input type="checkbox" id="parent" name="scales">
                </th>
                <th><?php echo e(__('administrator.date')); ?></th>
                <th>Total Box</th>
                <th><?php echo e(__('administrator.driver')); ?></th>
                <th><?php echo e(__('administrator.action')); ?></th>
            </tr>
            <tbody class="tbody">

            </tbody>

        </table>
    </div>
</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script type="text/javascript">

    $(document).ready(function () {

        $('#datatable_location').DataTable({
            "oLanguage": {
                "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                "oPaginate": {
                    "sFirst": "<?php echo e(__('administrator.first')); ?>",
                    "sLast": "<?php echo e(__('administrator.last')); ?>",
                    "sNext": "<?php echo e(__('administrator.next')); ?>",
                    "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax:{
                url:'<?php echo e(route('delivery-order-new.index')); ?>',
                data:function(d){
                    d.driver_id = $('select[name=driver_id]').val()
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex','searchable':false},
                    {data: 'clear_all','searchable':false},
                    {data: 'delivery_date'},
                    {data: 'total','searchable':false},
                    {data: 'name'},
                    {data: 'action','searchable':false},

                ],

            "initComplete": function (settings, json) {
            }
        });
        $(document).find('.dataTables_filter').prepend(`

                                                <label style="border: solid #ffe4e4 2px;">
                                                    <space class="text-primary">Processing</space>&nbsp; ,
                                                    <space class="text-success">Success</space>&nbsp;,
                                                    <space class="text-warning"> Pending</space>&nbsp;,
                                                    <space class="text-danger">Cancel</space>&nbsp;
                                                     `);
    });
    $(document).on('change','select[name=driver_id]',function(){
        $('#datatable_location').DataTable().ajax.reload();
    })
    $(document).on('click','#parent',function(e){
        if($(this).is(':checked')){
            $(document).find('.sub').prop('checked',true);
        }else{
            $(document).find('.sub').prop('checked',false);
        }
    })
    $(document).on('click','.clear-multi-driver',function(){
        let check = false;
        let arr = [];
        $.each($('.sub'), function (i, v) {
            if($(this).is(":checked")){
                check = true;
                arr.push({
                    'driver_id':$(this).data('driver_id'),
                    'date':$(this).data('date'),
                    'time_policy':$(this).data('time_policy')
                });
            }
        });
       if(!check){
            $.alert("Please Check Driver !");
            return false;
       }
       $.confirm({
            title: 'Clear Multi Driver',
            content: 'Do you want to clear multi Driver ?',
            type: 'blue',
            typeAnimated: true,
            buttons: {
                tryAgain: {
                    text: 'Clear',
                    btnClass: 'btn-blue',
                    action: function(){
                        $.ajax({
                            type: "POST",
                            url: "<?php echo e(route('clear-multi-driver')); ?>",
                            data: {
                                'obj':arr,
                                _token:'<?php echo e(csrf_token()); ?>'
                            },
                            dataType: "JSON",
                            success: function (data) {
                                if(data.status == 200){
                                    Toast.fire({
                                        icon: 'success',
                                        title: 'Clear Successfully !'
                                    });
                                    $('#datatable_location').DataTable().ajax.reload();
                                }
                            }
                        });
                    }
                },
                close: {
                    text: 'Close',
                    btnClass: 'btn-danger',
                    action: function(){

                    }
                },
            }
        });

    });
    $(document).on('click','.bt_clear_driver',function (e) {
        e.preventDefault();
        let route = $(this).data('route');
        $.confirm({
            title: 'Clear',
            content: 'Do You Want To Clear ?',
            type: 'blue',
            typeAnimated: true,
            buttons: {
                Clear: {
                    text: 'Clear',
                    btnClass: 'btn-primary',
                    action: function(){
                        $.get(route, {

        },
            function (data, textStatus, jqXHR) {
                Toast.fire({
                    icon: 'success',
                    title: 'Clear Successfully !'
                });
                $('#datatable_location').DataTable().ajax.reload();
                // $("#mySelector").printThis({
                //     debug: false,               // show the iframe for debugging
                //     importCSS: true,            // import parent page css
                //     importStyle: false,         // import style tags
                //     printContainer: true,       // print outer container/$.selector
                //     loadCSS: "",                // path to additional css file - use an array [] for multiple
                //     pageTitle: "",              // add title to print page
                //     removeInline: false,        // remove inline styles from print elements
                //     removeInlineSelector: "*",  // custom selectors to filter inline styles. removeInline must be true
                //     printDelay: 333,            // variable print delay
                //     header: null,               // prefix to html
                //     footer: null,               // postfix to html
                //     base: false,                // preserve the BASE tag or accept a string for the URL
                //     formValues: true,           // preserve input/form values
                //     canvas: false,              // copy canvas content
                //     doctypeString: data,       // enter a different doctype for older markup
                //     removeScripts: false,       // remove script tags from print content
                //     copyTagClasses: false,      // copy classes from the html & body tag
                //     beforePrintEvent: null,     // function for printEvent in iframe
                //     beforePrint: null,          // function called before iframe is filled
                //     afterPrint: null            // function called before iframe is removed
                // });
            },
        ).fail(function(xhr) {
            alertErrorFormController(xhr);
        });

                    }
                },
                close: function () {

                }
            }
        });
    });

</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/delivery-order-new/index.blade.php ENDPATH**/ ?>