<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="<?php echo e(route('app_dashboard')); ?>"><?php echo e(__('administrator.dashboard')); ?></a></li>
            <li><a href="<?php echo e(route('import-stock.index')); ?>"><?php echo e(__('administrator.import_stock')); ?></a></li>
            <li><a href="#" class="active"><?php echo e(__('administrator.import_stock_details')); ?></a></li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> <?php echo e(__('administrator.import_stock_details')); ?></h3>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table ">
                <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
                    <thead>
                        <tr>
                            <th width="1%">#</th>
                            <th width="15%"><?php echo e(__('administrator.code')); ?> </th>
                            <th width="15%"><?php echo e(__('administrator.name')); ?></th>
                            <th width="15%"><?php echo e(__('administrator.category')); ?></th>
                            <th width="15%"><?php echo e(__('administrator.quantity')); ?></th>
                            <th width="15%"><?php echo e(__('administrator.price')); ?></th>
                            <th width="15%"><?php echo e(__('administrator.total')); ?> </th>
                            <th width="15%"><?php echo e(__('administrator.action')); ?> </th>
                        </tr>
                    </thead>
                    <thead>
                     <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr align="center">
                                <td><?php echo e(($key+1)); ?></td>
                                <td><?php echo e($val->barcode); ?></td>
                                <td><?php echo e($val->name_km); ?></td>
                                <td><?php echo e($val->category_name); ?></td>
                                <td><?php echo e($val->import_qty); ?></td>
                                <td><?php echo e('$'.$val->sale_price); ?></td>
                                <?php $total  =  $val->sale_price * $val->import_qty ?>
                                <td><?php echo e('$'.$total); ?></td>
                                <td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Edit Stock In')): ?>
                                        <button class="button_sm button_success" data-id="<?php echo e($val->barcode); ?>"  data-import_qty="<?php echo e($val->import_qty); ?>" type="button"><span class="fa fa-edit  "></span> </button>
                                    <?php endif; ?>
                                    <button class="button_sm button_danger" data-id="<?php echo e($val->barcode); ?>"  data-import_qty="<?php echo e($val->import_qty); ?>" type="button"><span class="fa fa-trash  "></span> </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).on('click','.button_danger',function(){
            var import_qty = $(this).data('import_qty');
            var id = $(this).data('id');
            var merchant_id = '<?php echo e($merchant_id); ?>' ;
            var invoice = '<?php echo e($invoice); ?>' ;
            var this_  = $(this);
            $.confirm({
                title: 'Delete',
                theme: 'bootstrap',
                closeIcon: true,
                animation: 'scale',
                type: 'orange',
                content: '',
                buttons: {
                    បិទ: function () {

                    },
                    យល់ព្រម: function () {

                        $.ajax({
                            type: 'POST',
                            url: '<?php echo e(route("import_stock_delete")); ?>',
                            dataType:'text',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>',
                                import_qty: import_qty,
                                id: id,
                                invoice: invoice,
                                merchant_id:merchant_id
                            },
                            success: function (data) {
                                if(data == 'successfully'){
                                    location.reload();

                                }else if(data == 'not success'){
                                    $.alert('មិនអាចលុប');
                                }
                                else{

                                }

                            }
                        });
                    },
                },
            });
        });


        $(document).on('click','.button_success',function(){
            var import_qty = $(this).data('import_qty');
            var id = $(this).data('id');
            var merchant_id = '<?php echo e($merchant_id); ?>' ;
            var invoice = '<?php echo e($invoice); ?>' ;
            var this_  = $(this);
            $.confirm({
                title: 'Edit',
                theme: 'bootstrap',
                closeIcon: true,
                animation: 'scale',
                type: 'orange',
                content: `
                    <form action="" class="formName">
                        <div class="form-group">
                            <div class="row">
                                <div class="col-sm-12 col-xs-12">
                                    <input type="text" name="qty" value="${import_qty}" class="form-control number-only" required placeholder="qty">
                                </div>
                            </div>
                        </div>
                    </form>`,
                buttons: {
                    បិទ: function () {

                    },
                    យល់ព្រម: function () {
                        var qty =$('input[name="qty"]').val();

                        if(qty == ''){
                            $.alert('Select To Driver');
                            return false;
                        }
                        $.ajax({
                            type: 'POST',
                            url: '<?php echo e(route("import_stock_update")); ?>',
                            dataType:'text',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>',
                                qty: qty,
                                id: id,
                                invoice: invoice,
                                merchant_id:merchant_id
                            },
                            success: function (data) {
                                if(data == 'successfully'){
                                    location.reload();

                                }else if(data == 'not success'){
                                    $.alert('ស្តុកមិនកគ្រប់គ្រាន់');
                                }
                                else{

                                }

                            }
                        });
                    },
                },
            });

        });
    </script>
<?php $__env->stopSection(); ?>





<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/import-stock/show.blade.php ENDPATH**/ ?>