 <?php $__env->startSection('content'); ?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
            <li class="active"><?php echo e(__('administrator.report_income')); ?></li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12">
                        <?php echo Form::open(array('route' => 'reportIncomeStatementPrint','method'=>'POST')); ?>

                        <div class="form-search">
                            <div class="form-group col-sm-6 col-xs-6">
                                <?php echo Form::text('from_date', date('d-m-Y',strtotime('first day of this month')), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')); ?>

                            </div>
                            <div class="form-group col-sm-6 col-xs-6">
                                <?php echo Form::text('to_date',date('d-m-Y',strtotime('last day of this month')), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')); ?>

                            </div>
                            <div class="col-sm-12 col-xs-12">
                                <div class="form-group footer-save">
                                    <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search"></span> Searching</button>
                                    <button type="submit" class="button_sm button_info pull-right buttons-print"><span class="fa fa-print"></span> Print</button> 
                                </div>
                            </div>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>

            <div class="container-fluid">
                <div class="income-statement">
                    <div class="list">
                        <div class="left">
                            <div class="col-sm-6">
                                <h2 class="statement_blue">Income</h2>
                            </div>
                            <div class="col-sm-6">
                                <h2 class="statement_blue total_income">$<?php echo e(number_format($total_income,2)); ?></h2>
                            </div>
                        </div>
                        <div class="incomes">
                            <?php $__currentLoopData = $statement['income']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $income): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="col-sm-6">
                                        <h4><?php echo e($income->journal_acccode); ?> <?php echo e($income->acc_name_en); ?> <?php echo e($income->acc_name_km); ?></h4>
                                    </div>
                                    <div class="col-sm-6">
                                        <h4>$<?php echo e(number_format($income->in_total,2)); ?></h4>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="list">
                        <div class="left">
                            <div class="col-sm-6">
                                <h2 class="statement_red ">Expense</h2>
                            </div>
                            <div class="col-sm-6">
                                <h2 class="statement_red total_expense">$<?php echo e(number_format($total_expense,2)); ?></h2>
                            </div>
                        </div>
                        <div class="expenses">
                            <?php $__currentLoopData = $statement['expense']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $exp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="col-sm-6">
                                        <h4><?php echo e($exp->journal_acccode); ?> <?php echo e($exp->acc_name_en); ?> <?php echo e($exp->acc_name_km); ?></h4>
                                    </div>
                                    <div class="col-sm-6">
                                        <h4>$<?php echo e(number_format($exp->ex_total,2)); ?></h4>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="list">
                        <div class="left">
                            <div class="col-sm-6">
                                <h2 class="statement_green">Income Statement</h2>
                            </div>
                            <div class="col-sm-6">
                                <h2 class="statement_green total">$<?php echo e(number_format($total_income-$total_expense,2)); ?></h2>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php $__env->stopSection(); ?> <?php $__env->startSection('script'); ?>
        <script type="text/javascript">
            function searching() {
                var from_date = $('input[name="from_date"]').val();
                var to_date = $('input[name="to_date"]').val();
                var account_code = $('select[name="account_code"]').val();
                var incomes = '', expenses = '';
                var total_income = 0 , total_expense = 0;
                $.ajax({
                    url: "<?php echo e(Route('IncomeStatement')); ?>",
                    method: "POST",
                    dataType: "json",
                    data: { from_date: from_date,
                            to_date: to_date,
                            _token: '<?php echo e(csrf_token()); ?>',
                    },
                    success:function (data) {
                        $.each(data['income'], function(index, val) {
                            total_income += parseFloat(val.in_total);
                            incomes += `
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="col-sm-6">
                                                <h4>${val.journal_acccode} ${val.acc_name_en} ${val.acc_name_km}</h4>
                                            </div>
                                            <div class="col-sm-6">
                                                <h4>$${parseFloat(val.in_total).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</h4>
                                            </div>
                                        </div>
                                    </div>`;
                        });
                        $.each(data['expense'], function(index, val) {
                            total_expense += parseFloat(val.ex_total);
                            expenses += `
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="col-sm-6">
                                                    <h4>${val.journal_acccode} ${val.acc_name_en} ${val.acc_name_km}</h4>
                                                </div>
                                                <div class="col-sm-6">
                                                    <h4>$${parseFloat(val.ex_total).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</h4>
                                                </div>
                                            </div>
                                        </div>`;
                        });
                        $('.total_income').text('$'+parseFloat(total_income).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,'));
                        $('.total_expense').text('$'+parseFloat(total_expense).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,'));
                        $('.statement_green .total').text('$'+parseFloat(total_income-total_expense).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,'));
                        $('.incomes').empty().append(incomes);
                        $('.expenses').empty().append(expenses);
                    }
                });
            }
        </script>
        <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/accounting/report/income-statement.blade.php ENDPATH**/ ?>