<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
	  <li class="active"><?php echo e(__('administrator.report_stock')); ?></li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        <div class="wrapper center-block">
            <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                <div class="panel panel-default">
                <div class="panel-heading active" role="tab" id="headingOne">
                    <h4 class="panel-title">
                    <a role="button" onclick="" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            Filtering
                    </a>
                    <a style="float: right" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            <i class="fa fa-arrow-down"></i>
                    </a>
                    </h4>
                </div>
                <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
                    <div class="panel-body" style="padding: 0 !important;border: none !important;">
                        <br>
                        <div class="col-sm-12">
                            <?php echo Form::open(array('route' => 'stock_balance_print','method'=>'POST')); ?>

                                <?php if(\Globals::is_Administrator() == 'Administrator'): ?>
                                <div class="form-group col-sm-3 col-xs-4">
                                    <label for=""><?php echo e(__('administrator.shop_name')); ?></label>
                                    <?php echo Form::select('merchant', $merchant, null, ['class' => 'form-control' ]); ?>

                                </div>
                                <?php endif; ?>
                                <div class="form-group col-sm-3 col-xs-4">
                                    <label for=""><?php echo e(__('administrator.product_name')); ?></label>
                                    <?php echo Form::select('product', $product, null, ['class' => 'form-control'  ]); ?>

                                </div>
                                <div class="form-group col-sm-3 col-xs-4">
                                    <label for=""><?php echo e(__('administrator.category')); ?></label>
                                    <?php echo Form::select('category', $category, null, ['class' => 'form-control'  ]); ?>

                                </div>
                                <div class="form-group col-sm-3 col-xs-4">
                                    <label for=""><?php echo e(__('administrator.barcode')); ?></label>
                                    <?php echo Form::text('barcode', null, array('placeholder' => __('administrator.barcode'),'class' => 'form-control  ' )); ?>

                                </div>
                                <div class="col-sm-12 col-xs-12">
                                    <div class="form-group footer-save">
                                        <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search"></span><?php echo e(__('administrator.searching')); ?> </button>
                                        <button type="submit" class="button_sm button_info pull-right buttons-print"><span class="fa fa-print"></span> <?php echo e(__('administrator.print')); ?> </button>
                                    </div>
                                </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
                </div>
           
          </div>
        </div>
        <div class="row">
            
           
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th><?php echo e(__('administrator.no')); ?></th>
                    <th><?php echo e(__('administrator.shop_name')); ?></th>
                    <th><?php echo e(__('administrator.phone_number')); ?></th>
                    <th><?php echo e(__('administrator.product_name')); ?></th>
                    <th><?php echo e(__('administrator.product_code')); ?></th>
                    <th><?php echo e(__('administrator.category')); ?></th>
                    <th><?php echo e(__('administrator.price')); ?></th>
                    <th><?php echo e(__('administrator.in_stock')); ?></th>
                    <th><?php echo e(__('administrator.out_stock')); ?></th>
                    <th><?php echo e(__('administrator.balance_stock')); ?></th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>


<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script type="text/javascript">
      $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "<?php echo e(__('administrator.search')); ?>:",
            "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
            "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
            "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
            "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
            "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
            "oPaginate": {
                "sFirst": "<?php echo e(__('administrator.first')); ?>",
                "sLast": "<?php echo e(__('administrator.last')); ?>",
                "sNext": "<?php echo e(__('administrator.next')); ?>",
                "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        // ajax: "<?php echo e(route('datatble_stock_balance')); ?>",
        ajax:{
            url: "<?php echo e(route('datatble_stock_balance')); ?>",
            "data": function ( d ) {
                d.merchant = $('select[name="merchant"]').val(),
                d.category = $('select[name="category"]').val(),
                d.barcode = $('input[name="barcode"]').val(),
                d.product = $('select[name="product"]').val()
            }
           
        },
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'shop_name'},
                {data: 'phone'},
                {data: 'product_name'},
                {data: 'product_code'},
                {data: 'category_name'},
                {data: 'price'},
                {data: 'in_stock'},
                {data: 'out_stock'},
                {data: 'stock_qty'},
            ],

        "initComplete": function (settings, json) {
        }
    });

    function searching()
    {   
        $('#datatable_income').DataTable().ajax.reload();
        return false;
        var merchant = $('select[name="merchant"]').val();
        var category = $('select[name="category"]').val();
        var product = $('select[name="product"]').val();
        var barcode = $('input[name="barcode"]').val();
        var table = '';
        var account_name = '';
        $.ajax({
            url: "<?php echo e(Route('datatble_stock_balance')); ?>",
            method: "POST",
            dataType: "json",
            data: {
                merchant: merchant,
                category: category,
                barcode: barcode,
                product: product,
                _token: '<?php echo e(csrf_token()); ?>',
            },
            success: function (data) {
                $.each(data, function(index, val) {
                    table += `
                        <tr>
                            <td>${ index+1 }</td>
                            <td>${ val.shop_name }</td>
                            <td>${ val.phone }</td>
                            <td>${ val.product_name }</td>
                            <td>${ val.product_code }</td>
                            <td>${ val.category_name }</td>
                            <td> $${ val.price }</td>
                            <td> ${ val.stock_qty }</td>

                        </tr>
                    `;
                });
                $('.tbody').empty().append(table);
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/stock/index.blade.php ENDPATH**/ ?>