<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
	  <li class="active"><?php echo e(__('administrator.cash_on_hand')); ?></li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                <?php echo Form::open(array('route' => 'reportCashOnHandPrint','method'=>'POST')); ?>

                <div class="form-search">
                    <div class="form-group col-sm-6 col-xs-6">
                            <?php echo Form::text('from_date', date('d-m-Y',strtotime('first day of this month')), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')); ?>

                    </div>
                    <div class="form-group col-sm-6 col-xs-6">
                            <?php echo Form::text('to_date',date('d-m-Y',strtotime('last day of this month')), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')); ?>

                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search"></span> Searching</button>
                            <button type="submit" class="button_sm button_info pull-right buttons-print"><span class="fa fa-print"></span> Print</button>
                        </div>
                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('administrator.date')); ?></th>
                    <th><?php echo e(__('administrator.account_name')); ?></th>
                    <th><?php echo e(__('administrator.description')); ?></th>
                    <th><?php echo e(__('administrator.reference')); ?></th>
                    <th><?php echo e(__('administrator.cash_in')); ?></th>
                    <th><?php echo e(__('administrator.cash_out')); ?></th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
            <tfoot class="tfoot">
                <tr>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th class="bg_green"></th>
                    <th class="bg_red"></th>
                </tr>
                <tr>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th class="bg_green"></th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>


<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script type="text/javascript">

    $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "<?php echo e(__('administrator.search')); ?>:",
            "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
            "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
            "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
            "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
            "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
            "oPaginate": {
                "sFirst": "<?php echo e(__('administrator.first')); ?>",
                "sLast": "<?php echo e(__('administrator.last')); ?>",
                "sNext": "<?php echo e(__('administrator.next')); ?>",
                "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        ajax: "<?php echo e(route('getCashOnHand')); ?>",
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'journal_paydate'},
                {data: 'account_name'},
                {data: 'journal_des'},
                {data: 'journal_invoice'},
                {data: 'cash_in'},
                {data: 'cash_out'},
            ],

        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                      i : 0;
            };
            var journal_credit = api
                .column( 5 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
            }, 0 );

            var journal_debit = api
                .column( 6 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
            }, 0 );

            var numFormat = $.fn.dataTable.render.number( '\,', '.', 2, '$ ' ).display;

            var total_balance = (journal_credit - journal_debit);
            $( api.column( 5 ).footer() ).html(numFormat(journal_credit));
            $( api.column( 6 ).footer() ).html(numFormat(journal_debit));
            $('tr:eq(1) th:eq(6)', api.table().footer()).html(numFormat(total_balance));
        },

        "initComplete": function (settings, json) {

        }
    });

    function searching()
    {
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var table = '';
        var tfoot = '';
        var cash_out = 0 , cash_in = 0;
        var account_name = '';
        $.ajax({
            url: "<?php echo e(Route('getCashOnHand')); ?>",
            method: "POST",
            dataType: "json",
            data: {
                from_date: from_date,
                to_date: to_date,
                _token: '<?php echo e(csrf_token()); ?>',
            },
            success: function (data) {
                $.each(data, function(index, val) {

                    str = val.journal_paydate;
                    st2 = str.split("-");
                    yr = st2[0];
                    mo = st2[1];
                    dy = st2[2];
                    var new_date = dy+'-'+mo+'-'+yr;
                    if('<?php echo e(\Globals::check_lang()); ?>' =='en'){
                        account_name = val.account_code+' '+val.acc_name_en;
                    }else{
                        account_name = val.account_code+' '+val.acc_name_km;
                    }
                    table += `
                        <tr>
                            <td>${index+1}</td>
                            <td>${new_date}</td>
                            <td>${account_name}</td>
                            <td>${val.journal_des}</td>
                            <td>${val.journal_invoice}</td>
                            <td>$${parseFloat(val.journal_debit).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                            <td>$${parseFloat(val.journal_credit).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                        </tr>
                    `;
                    cash_in += parseFloat(val.journal_debit);
                    cash_out += parseFloat(val.journal_credit);
                });
                $('.tfoot').empty().append(`
                        <tr>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th class="bg_green">$${parseFloat(cash_in).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</th>
                            <th class="bg_red">$${parseFloat(cash_out).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</th>
                        </tr>
                        <tr>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th class="bg_green">$${parseFloat(cash_in-cash_out).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</th>
                        </tr>
                    `);
                $('.tbody').empty().append(table);
            }
        });
    }


</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/accounting/report/report-cash-on-hand.blade.php ENDPATH**/ ?>