<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sammaki Delivery</title>
    <meta property="og:type" content="website" />
    <meta property="og:title" content="2U Delivery" />
    <meta property="og:image" content="<?php echo e(asset('images/logo.jpg')); ?>" />
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('images/logo.jpg')); ?>">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('assets/font-awesome-4.7.0/css/font-awesome.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/AdminLTE/AdminLTE.min.css')); ?>">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

    <script src="<?php echo e(asset('assets/js/jquery3.4.1.min.js')); ?>"></script>
    <link rel="stylesheet" href="<?php echo e(asset('assets/jquery-confirm/css/jquery-confirm.min.css')); ?>">
        
</head>

<body>

    <style type="text/css">
        body,
        #main-container {
            height: auto;
        }
        .table-bordered>thead>tr>th,
        .table-bordered>tbody>tr>th,
        .table-bordered>tfoot>tr>th,
        .table-bordered>thead>tr>td,
        .table-bordered>tbody>tr>td,
        .table-bordered>tfoot>tr>td {
            border: 1px solid black !important;
        }
        .table-striped{
            font-size: 16px !important;
        }
    </style>


    <div class="wrapper" id="main-container">
        <!-- Main content -->
        <section class="invoice">
            <!-- title row -->
            <div class="row">
                <div class="col-xs-12">
                    <h2 class="page-header">
                        <img src="<?php echo e(asset('images/logo.jpg')); ?>" width="70px;" height="70px;">Sammaki Delivery
                        <small class="pull-right bt-date"  > Date: <?php echo e(date("m-d-Y")); ?> </small>
                    </h2>
                </div>
            </div>
            <div class="row invoice-info">
                <div class="col-sm-4 invoice-col">
                    From
                    <address>
                        <strong>Sammaki Delivery</strong><br>
                        Address: <?php echo e($branch->address); ?><br>
                        Phone: <?php echo e($branch->phone); ?> <br>
                    </address>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th rowspan="2">#</th>
                                <th rowspan="2" > Code</th>
                                <th rowspan="2" > Shop</th>
                                <th rowspan="2" > Phone Number</th>
                                <th rowspan="2" > Zone</th>
                                <th rowspan="2" > Driver</th>
                                <th rowspan="2" > Import Date</th> 
                                <th rowspan="2" > Export Date</th> 
                                <th rowspan="2" > Delivery Fee</th>
                                <th rowspan="2" > Car service</th>
                                <th rowspan="2" > Price</th>
                                
                                <th colspan="2" style="text-align: center;"> Collected Prices</th>
                                <th colspan="2" style="text-align: center;"> Collected Prices From Customer</th>
                                <th rowspan="2" > Description</th>
                            </tr>
                            <tr>
                                <th > Dollar</th>
                                <th > Riel</th>
                                
                                <th > Dollar</th>
                                <th > Riel</th>
                                

                            </tr>
                        </thead>
                        <tbody>

                            <?php
                                $total_riel                             = 0 ;
                                $total_dollar                           = 0 ;
						        $total_delivery_fee                     = 0;
                                $arrangement_service                    = 0;
                                $total_item                             = 0;
                                $total_car_service                      = 0;
                                $total_extra_fee                        = 0;
                                $total_service_charge                   = 0;
                                $total_other_fee                        = 0;
                                $សេវាផ្សេងៗ                               = 0;
                                $total_net_price_list                   =0;
                                $total_aba_to_shop                      =0;
                                $total_aba_to_delivery                  =0;
                                $last_delivery_fee                      =0;
                                $last_driver_fee                        =0;
                                $last_taxi_fee                          = 0;
                                $last_delivery_fee_riel                  = 0;
                                $last_delivery_fee_dollar                = 0;

                                
                                
                            ?>
 
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $last_delivery_fee_riel                  = 0;
                                $last_delivery_fee_dollar                = 0;
                                $Paid  =0;
                                $delivery_fee_shop = 0;
                                if($value->status == 4){
                                    $style = 'background: #f3cccf !important';
                                }else if($value->status == 2){
                                    $style = 'background: #ddd !important';
                                }else if($value->status == 1){
                                    $style = 'background: #fefdf0 !important';
                                }else{
                                    $style = '';
                                }
                            ?>
                                <tr style="<?php echo e($style); ?>" >
                                    <td><?php echo e($key + 1); ?></td>
                                    <td><?php echo e($value->box_code); ?></td>

                                    <td><?php echo e($value->shop_name); ?>  </td>
                                    <td style="width:120px ;"><?php echo e($value->customer_receive); ?></td>
                                    <td><?php echo e($value->location_name); ?></td>
                                    <td><?php echo e($value->driver_name); ?></td>
                                    <td><?php echo e(date('d-m-Y', strtotime($value->export_date))); ?></td>
                                    <td><?php echo e(date('d-m-Y', strtotime($value->delivery_date))); ?></td>
                                    
                                    
                                 
                                    <td>
                                        <?php

                                            $delivery_fee   = 0;
                                            $discount = 0;
                                            if( $value->discount_id != null)
                                            {
                                                $dis = DB::table('nso007_discount')->find($value->discount_id);
                                                if($dis->discount_type == 1){
                                                    $delivery_fee = $dis->discount;
                                                }
                                                elseif($dis->discount_type == 2){
                                                    $delivery_fee = ( (100 - $dis->discount )* $value->delivery_fee ) / 100;
                                                }
                                                else{
                                                    $delivery_fee =$value->delivery_fee;

                                                    if($value->delivery_status == 1){
                                                        $discount = ($dis->discount/100)*$value->delivery_fee;

                                                    }
                                                    else{
                                                        $discount = 0;
                                                    }
                                                    /* echo $discount; */
                                                }
                                            }
                                            else{
                                                $delivery_fee  =  $value->delivery_fee;
                                            }
                                            if($value->delivery_status == 1){                                                
                                                $delivery_fee_view  =  '$'.numberFormat( $delivery_fee) . ' s';
                                                if($value->delivery_fee_symbol == '៛'){
                                                    $delivery_fee_view  =  numberFormat( $delivery_fee) . '៛ s';
                                                }
                                                
                                            }else{
                                                $delivery_fee_view =   '$'.numberFormat( $delivery_fee) . ' c';
                                                
                                                if($value->delivery_fee_symbol == '៛'){
                                                    $last_delivery_fee_riel = $value->delivery_fee;
                                                    $delivery_fee_view  =  numberFormat( $delivery_fee) . '៛ c';
                                                }
                                                if($value->delivery_fee_symbol == '$'){
                                                    $last_delivery_fee_dollar = $value->delivery_fee;
                                                }
                                                
                                            }
                                            // if($value->delivery_pay_or_paid == 'paid'){
                                            //     echo  '  <strike> '.$delivery_fee_view . '  </strike>';
                                            //     $delivery_fee  = 0;
                                            // }else{
                                            //     if($value->status == 2 || $value->status == 4){
                                            //         echo  0 ;
                                            //     }else{
                                            //         echo  $delivery_fee_view  ;

                                            //     }
                                            // }


                                        ?>
                                        <?php echo e($delivery_fee_view); ?>

                                    </td>
                                    <td>
                                            ​<?php if($value->taxi_status  == '1'): ?>
                                                <?php if($value->taxi_fee_symbol == '$'): ?>
                                                <?php echo e($value->taxi_fee ? '$ '.numberFormat( $value->taxi_fee ).' s' : ''); ?>

                                                <?php else: ?>
                                                <?php echo e($value->taxi_fee ? numberFormat( $value->taxi_fee ).'៛ s' : ''); ?>

                                                <?php endif; ?>
                                            <?php else: ?>
                                                    <?php if($value->taxi_fee_symbol == '$'): ?>
                                                        <?php echo e($value->taxi_fee ? '$ '.numberFormat( $value->taxi_fee ).' c' : ''); ?>

                                                    <?php else: ?>
                                                        <?php echo e($value->taxi_fee ? numberFormat( $value->taxi_fee ).'៛ c' : ''); ?>

                                                    <?php endif; ?>
                                                    <?php
                                                        $last_taxi_fee = $value->taxi_fee;
                                                        $value->taxi_fee = 0;
                                                    ?>
                                                <?php endif; ?>
                                            
                                    </td>
                                    <td>
                                       
                                        <?php echo e($value->total_product_symbol == '$' ? '$'.number_format($value->total_price,2) : number_format($value->total_price).' ៛'); ?>

                                        
                                       
                                    </td> 
                                    <td> 
                                        <?php
                                        $total_price = 0;
                                        if($value->total_product_symbol == "$")
                                            $total_price = $value->total_price;

                                        ?>
                                        <?php echo e($total_price + $last_delivery_fee_dollar); ?>

                                        
                                            
                                    </td>
                                    
                                    
                                    
                                    <td>
                                        <?php
                                        $total_price = 0;
                                        if($value->total_product_symbol == "៛")
                                            $total_price = $value->total_price;
                                        ?>
                                        <?php echo e($total_price + $last_delivery_fee_riel); ?>

                                    </td>
                                    

                                    <td>
                                        
                                    </td>

                                    
                                    <td>
                                        
                                    </td>
                                    <td>
                                        <?php echo e($value->description); ?>

                                    </td>
                                </tr>
                                <?php
                                 


                                    if($value->delivery_status == 1){
                                        $delivery_fee = 0; 
                                    }   
                                    if($value->extra_fee_type == 1){
                                        $extra_fee_shop = 0; 
                                    }   
                                    
                                    
                                    if(  $value->status == 3 && $value->clear_box_code != 1 ){
                                        $total_riel                         +=  $value->total_riel;
                                        $total_dollar                       +=  $value->total_dollar;
                                        $total_delivery_fee                 +=  $delivery_fee   + $extra_fee_shop ;
                                        $total_item                         +=  $value->total_product ;
                                        $total_car_service                  +=  $value->taxi_fee;
                                        $total_service_charge               +=  $value->service_charge;
                                        $total_other_fee                    +=  $value->other_services_fee;

                                        if ($value->pay_to == 'delivery'){
                                            $total_aba_to_delivery              +=   $value->amount_pay_to;
                                        }
                                        if ($value->pay_to == 'shop'){
                                            $total_aba_to_shop              +=   $value->amount_pay_to;
                                        } 
                                        //$សេវារៀបចំ                          +=   $value->service_charge ;
                                    }

                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        
                    </table>
                </div>
            </div>
        </section>
    </div>


    
</body>

</html>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('js/datepicker/datepicker.min.css')); ?>">
    <script src="<?php echo e(asset('js/datepicker/datepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/barcode/barcode.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/mobile/js/jquery-confirm.js')); ?>"></script>
    <script>

        
    </script>


    </body>

</html>

<?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/delivery-order-new/list-delivery-in_processing_print.blade.php ENDPATH**/ ?>