<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="/"><?php echo e(__('administrator.dashboard')); ?></a></li>
	  <li class="active"> <?php echo e(__('administrator.delivery')); ?></li>
	  <li class="active"><?php echo e(__('administrator.clear_invoice_history')); ?></li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> <?php echo e(__('administrator.clear_invoice_history')); ?></h3>
	                </div>
	            </div>
	        </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for=""><?php echo e(__('administrator.driver')); ?></label>
                    <?php echo Form::select('driver_id', compressDriver(), null, ['class' => 'form-control','placeholder'=>__('administrator.please_select')]); ?>

                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="exampleInputEmail1"><?php echo e(__('administrator.from')); ?></label>
                    <input type="text" class="form-control date-year" id="from_date"
                           placeholder="<?php echo e(__('administrator.from')); ?>" value="<?php echo e(date("Y-m-d")); ?>">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="exampleInputEmail1"><?php echo e(__('administrator.to')); ?></label>
                    <input type="text" class="form-control date-year" id="to_date"
                           placeholder="<?php echo e(__('administrator.to')); ?>" value="<?php echo e(date("Y-m-d")); ?>">
                </div>
            </div>
	    </div>
    </div>
    <div class="wrapper-table ">
        <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
            <thead>
            <tr>
                <th style="width: 5% !important"><?php echo e(__('administrator.no')); ?></th>
                <th><?php echo e(__('administrator.date')); ?></th>
                <th><?php echo e(__('administrator.clear_invoice')); ?></th>
                <th><?php echo e(__('administrator.driver')); ?></th>
                <th><?php echo e(__('administrator.action')); ?></th>
            </tr>
            <tbody class="tbody">

            </tbody>

        </table>
    </div>
</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script type="text/javascript">

    $(document).ready(function () {

        $('#datatable_location').DataTable({
            "oLanguage": {
                "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                "oPaginate": {
                    "sFirst": "<?php echo e(__('administrator.first')); ?>",
                    "sLast": "<?php echo e(__('administrator.last')); ?>",
                    "sNext": "<?php echo e(__('administrator.next')); ?>",
                    "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax:{
                url:'<?php echo e(route('clear-driver-voucher-history')); ?>',
                data:function(d){
                    d.driver_id = $('select[name=driver_id]').val()
                    d.from_date = $('#from_date').val()
                    d.to_date = $('#to_date').val()
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex','searchable':false},
                    {data: 'delivery_date'},
                    {data: 'clear_box_code'},
                    {data: 'driver_name'},
                    {data: 'action','searchable':false},

                ],

            "initComplete": function (settings, json) {
            }
        });
    });
    $(document).on('change','select[name=driver_id],#from_date,#to_date',function(){
        $('#datatable_location').DataTable().ajax.reload();
    })
    $('.date-year').datepicker({
        changeMonth: true,
        changeYear: true,

        onClose: function(dateText, inst) {

        }
    });

</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/delivery-order-new/clear_history.blade.php ENDPATH**/ ?>