<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<div class="top-header">
<ol class="breadcrumb">
    <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
    <li class="active"><?php echo e(__('administrator.list_pickup')); ?></li>
</ol>
</div>
<div class="page">
<div class=container-fluid>
<div class="top-content">
    <div class="row">
        <div class="col-sm-12">
            <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                <?php echo csrf_field(); ?>
            <div class="form-search">
                <?php if(\Globals::is_Administrator() == 'Administrator'): ?>
                <div class="form-group col-sm-3 col-xs-3">
                    <?php echo Form::select('drivers', $drivers, null, ['class' => 'form-control drivers']); ?>

                </div>
                <?php endif; ?>
                <div class="form-group col-sm-3 col-xs-3">
                    <?php echo Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')); ?>

                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <?php echo Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')); ?>

                </div>

                <div class="col-sm-12 col-xs-12">
                    <div class="form-group footer-save">
                        <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search"></span> <?php echo e(__('administrator.searching')); ?> </button>
                        <button type="button" class="button_sm button_info pull-right buttons-print bt_print" style="display: none"><span class="fa fa-print"></span>   <?php echo e(__('administrator.print')); ?></button>
                    </div>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>

<div class="wrapper-table ">
    <table id="datatable-list-pickup" width="100%" class="table table-striped table-hover  ">
        <thead>
            <tr>
                <th><?php echo e(__('administrator.no')); ?></th>
                <th><?php echo e(__('administrator.date')); ?></th>
                <th><?php echo e(__('administrator.shop_name')); ?></th>
                <th><?php echo e(__('administrator.box_qty')); ?></th>
                <th><?php echo e(__('administrator.description')); ?></th>
                <th><?php echo e(__('administrator.driver_name')); ?></th>
                <th><?php echo e(__('administrator.invoice_pickup')); ?></th>
                <th><?php echo e(__('administrator.type_of_pickup')); ?></th>
            </tr>
        </thead>
        <tbody class="tbody">

        </tbody>
    </table>
</div>
</div>


<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script type="text/javascript">

    $(document).ready(function(){
        $(document).on('change','.drivers',function(){
            if($(this).val() != ''){
                $('.buttons-print').show();
            }
            else{
                $('.buttons-print').hide();

            }
        });
    });






    $('#datatable-list-pickup').DataTable({
            "oLanguage": {
                "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                "oPaginate": {
                    "sFirst": "<?php echo e(__('administrator.first')); ?>",
                    "sLast": "<?php echo e(__('administrator.last')); ?>",
                    "sNext": "<?php echo e(__('administrator.next')); ?>",
                    "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax: "<?php echo e(route('list_pickup')); ?>",
            columns:
                [
                {data: 'DT_RowIndex'},
                {data: 'date' },
                {data: 'shop_name' },
                {data: 'count_' },
                {data: 'description' },
                {data: 'driver_name' },
                {data: 'invoice_pickup' },
                {data: 'status' },
                // {data: 'action' },
                ],

            "initComplete": function (settings, json) {
            }
    });


    function searching()
{
    var from_date = $('input[name="from_date"]').val();
    var to_date = $('input[name="to_date"]').val();
    var drivers = $('.drivers').val();
    var table = '';
    $.ajax({
        url: "<?php echo e(Route('search_history_pickup')); ?>",
        method: "get",
        dataType: "json",
        data: {
            from_date: from_date,
            to_date: to_date,
            drivers: drivers,
            _token: '<?php echo e(csrf_token()); ?>',
        },
        success: function (data) {
          if(data.search){
             $('#datatable-list-pickup tbody').replaceWith(data.search);
          }
        }
    });
}

$(document).on('click','.bt_print',function(){
        $( ".submit" ).submit();
        $('.submit').attr('action', '<?php echo e(route("history_pickup_print")); ?>').submit();
    });

</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/pick-up/history_pickup.blade.php ENDPATH**/ ?>