<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
    <div class="panel panel-default">
    <div class="panel-heading active" role="tab" id="headingOne">
        <h4 class="panel-title">
        <a role="button" onclick="" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                Filtering
        </a>
        <a style="float: right" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                <i class="fa fa-arrow-down"></i>
        </a>
        </h4>
    </div>
    <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
        <div class="panel-body" style="padding: 0 !important;border: none !important;">
            
            <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                <?php echo csrf_field(); ?>
                <div class="form-search" style="margin: 0 !important">
                <div class="form-group col-sm-3 col-xs-3">
                    <label for=""><?php echo e(__('administrator.shop_name')); ?></label>
                    <?php echo Form::select('merchant', $merchant_show, null, ['class' => 'form-control in_stock_merchant']); ?>

                </div>
                
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">City / Province</label>
                    <select name="province_or_city[]" id="in_stock_province_or_city" class="form-control chosen-select">
                        <option value="">  <?php echo e(__('administrator.please_choose')); ?> </option>
                        <option value="pp">  Phnom Penh </option>
                        <option value="No">  Provice </option>
                    </select>
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">From Date</label>
                    <?php echo Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control in_stock_from_date date_picker')); ?>

                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">To Date</label>
                    <?php echo Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control in_stock_to_date date_picker')); ?>

                </div>

                
                </div>
            </form>
        </div>
    </div>
    </div>

</div>
<div class="wrapper-table ">
    <table id="datatable_in_stock_delivery" width="100%" class="table table-striped hover">
        <thead>
        <tr>
            <th><?php echo e(__('administrator.no')); ?></th>
            
            <th><?php echo e(__('administrator.driver_name')); ?></th>
            
            <th><?php echo e(__('administrator.day_delivery')); ?></th>
            <th><?php echo e(__('administrator.box_code')); ?></th>
            <th><?php echo e(__('administrator.shop_name')); ?></th>
            <th><?php echo e(__('administrator.customer_receive')); ?></th>
            <th><?php echo e(__('administrator.location')); ?></th>
            <th><?php echo e(__('administrator.price')); ?></th>
            <th><?php echo e(__('administrator.delivery_fee')); ?></th>
            <th><?php echo e(__('administrator.delivery_option')); ?></th>
            
            <th><?php echo e(__('administrator.status')); ?></th>
            <th><?php echo e(__('administrator.action')); ?></th>
        </tr>
        <tbody class="tbody">
        </tbody>
    </table>
</div>



<script>
    $(document).ready(function () {
        dataTableAjax();
        function dataTableAjax(from_date= "", to_date="", merchant= '',status='',pro_or_city=''){
            $('#datatable_in_stock_delivery').DataTable().destroy();
            $('#datatable_in_stock_delivery').DataTable({
                "oLanguage": {
                    "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                    "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                    "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                    "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                    "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                    "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                    "oPaginate": {
                        "sFirst": "<?php echo e(__('administrator.first')); ?>",
                        "sLast": "<?php echo e(__('administrator.last')); ?>",
                        "sNext": "<?php echo e(__('administrator.next')); ?>",
                        "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                    },
                },
                ordering: false,
                serverSide: true,
                ajax:{
                    url: '<?php echo e(route('in_stock_delivery')); ?>',
                    data:{
                        from_date:from_date,
                        to_date:to_date,
                        merchant:merchant,
                        status:status,
                        pro_or_city:pro_or_city
                    }
                },
            

                lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
                columns:
                    [
                        {data: 'DT_RowIndex'            ,  'searchable': false},
                        // {data: 'share_link'             ,  'searchable': false},
                        {data: 'driver_name'             ,  'searchable': false},
                        // {data: 'export_date'            ,  'searchable': false},
                        // {data: 'create_by_name'         , name:  'nso007_export_stock.create_by_name'   ,  'searchable': true},
                        {data: 'delivery_date'          ,  'searchable': false},
                        {data: 'box_code'               , name:  'nso007_export_stock.box_code'         ,  'searchable': true},
                        {data: 'shop_name'              , name:  'nso007_export_stock.shop_name'        ,  'searchable': true},
                        {data: 'customer_receive'       , name:  'nso007_export_stock.customer_receive'        ,  'searchable': true},
                        {data: 'location_name'          , name:  'nso007_export_stock.location_name'        ,  'searchable': true},
                        {data: 'total_price'            ,  'searchable': false},
                        {data: 'delivery_fee'           ,  'searchable': false},
                        {data: 'delivery_option'        ,  'searchable': false},
                        // {data: 'description'            ,  'searchable': false},
                        {data: 'status'                 ,  'searchable': false},
                        {data: 'action'                 ,  'searchable': false},
                    ],
                "initComplete": function (settings, json) {
                    
                }
            });
        }
        $(document).on('change','.in_stock_merchant,#in_stock_province_or_city,.in_stock_from_date,.in_stock_to_date',function(){
            let from_date = $('.in_stock_from_date').val();
            let to_date = $('.in_stock_to_date').val();
            let merchant = $('.in_stock_merchant').val();
            let provice = $('#in_stock_province_or_city').val();
            dataTableAjax(from_date,to_date,merchant,'',provice);
        });
        $(document).on('click','.bt-print',function () {
        var href = $(this).data('href');
            $.ajax({
                url: href,
                success: function (data) {
                    var content_ = (data);
                    $.confirm({
                        title: '',
                        content: content_,
                        boxWidth: '50%',
                        useBootstrap: false,
                        buttons: {
                            close: {
                                text: '<?php echo e(__('administrator.close')); ?>',
                                btnClass: 'button_warning',
                                keys: ['esc'],
                                action: function () {

                                }
                            },
                            print: {
                                text: '<?php echo e(__('administrator.print')); ?>',
                                btnClass: 'button_info button_info_',
                                keys: ['enter'],
                                action: function () {
                                    $('.container1').printThis({
                                        loadCSS: "<?php echo e(asset('assets/print_this/pos-invoice.css')); ?>",
                                        afterPrint: function () {


                                        }
                                    });
                                }
                            },
                        }
                    });
                    $('.loading_btn').hide();
                    $('input[type=submit]').show();
                    $('button[type=submit]').show();
                }
            });
            setTimeout(function(){
                let aa =$(document).find('.button_info_').trigger('click');
            },500);
    });
        $(document).on('click','.bt-delete',function () {
            var href = $(this).data('href');
            var this_ = $(this);
            $.confirm({
                icon: 'fa fa-trash',
                theme: 'modern',
                title: 'Delete!',
                closeIcon: true,
                animation: 'scale',
                type: 'red',buttons: {
                    cancel: function () {

                    },
                    confirm: {
                        text: 'Confirm',
                        btnClass: 'btn-red',
                        keys: ['enter', 'shift'],
                        action: function(){
                            $.ajax({
                                url: href,
                                success: function (response) {
                                    if (response.success == true) {
                                        this_.closest('tr').remove();
                                    } else {
                                        $.alert({
                                            title: "Error",
                                            content: response.error,
                                            buttons: {
                                                formSubmit: {
                                                    text: 'Submit',
                                                    btnClass: 'btn-blue',
                                                    action: function () {
                                                    
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                }
            });
        });
    });
</script><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/delivery-list/instock-delivery.blade.php ENDPATH**/ ?>