<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="<?php echo e(route('app_dashboard')); ?>"><?php echo e(__('administrator.dashboard')); ?></a></li>
            <li><a href=""><?php echo e(__('administrator.bus_list')); ?></a></li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><?php echo e(__('administrator.manage_bus')); ?></h3>
                            </div>
                            <div class="pull-right">
                                <a href="<?php echo e(route('bus.create')); ?>" class="button_sm button_info"><span
                                            class="fa fa-plus"></span> <?php echo e(__('administrator.new_bus')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table ">
                <table id="data_table" width="100%" class="table table-striped table-hover  ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo e(__('administrator.company_name')); ?></th>
                        <th><?php echo e(__('administrator.price')); ?></th>
                        <th><?php echo e(__('administrator.action')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key+1); ?></td>
                            <td><?php echo e($value->company_name); ?></td>
                            <td>$<?php echo e(number_format( $value->price,2)); ?></td>
                            <td>
                                <a href="<?php echo e(route('bus.edit',$value->id)); ?>"
                                   class="button_info"><?php echo e(__('administrator.edit')); ?>

                               </a>
                                <a class="button_sm <?php if($value->status==1): ?> button_primary <?php else: ?> button_danger <?php endif; ?>"
                                   onclick="status('<?php echo e($value->id); ?>','<?php echo e($value->status); ?>')"><?php if($value->status==1): ?> <?php echo e(__('administrator.active')); ?> <?php else: ?> <?php echo e(__('administrator.deactive')); ?> <?php endif; ?></a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="modal fade bs-modal-lg" id="form_delete" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h3 class="modal-title">Are you sure?</h3>
                </div>
                <br/>
                <form role="form" method="delete" id="delete">
                    <?php echo e(csrf_field()); ?>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="col-md-10">
                                <h4>Are you want to delete?</h4>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" data-dismiss="modal" class="button_danger"><i class="fa fa-close"></i> No
                        </button>
                        <button type="button" data-dismiss="modal" class="button_primary deleteRecord"
                                data-toggle="modal"><i class="fa fa-save"></i> OK
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id=model_image class="modal_img">
        <span class="close_image" style="margin-top: 45px;" >&times;</span>
        <img class="modal-content" id="img01">
        <div id="caption"></div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript"> 
        $(document).ready(function () {
            $('#data_table').DataTable({
                "oLanguage": {
                    "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                    "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                    "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                    "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                    "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                    "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                    "oPaginate": {
                        "sFirst": "<?php echo e(__('administrator.first')); ?>",
                        "sLast": "<?php echo e(__('administrator.last')); ?>",
                        "sNext": "<?php echo e(__('administrator.next')); ?>",
                        "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                    },
                },
                lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            });


            $(document).on('click', '.delete_bus', function () {
                $('#form_delete').modal('show');
                var id = $(this).data("id");
                $(".deleteRecord").click(function () {
                    var token = $("meta[name='csrf-token']").attr("content");
                    $.ajax({
                        type: 'GET',
                        dataType: "json",
                        url: "",
                        data: {
                            "id": id,
                            "_token": token,
                        },
                        success: function () {
                            $('#form_delete').modal('hide');
                            location.reload();
                        }
                    });

                });
            });


            
            function status(id, status) {
                $('#loading').show();
                var check_status = status == 1 ? 0 : 1;
                var statusvalue = "";
                if (status == 0) {
                    statusvalue = "<span style='color:blue;'><?php echo e(__('administrator.active')); ?></span>";
                }
                else {
                    statusvalue = "<span style='color:blue;'><?php echo e(__('administrator.deactive')); ?></span>";
                }
                if ($.confirm({
                    title: '<strong style="color:darkcyan;"><?php echo e(__('administrator.change_status')); ?></strong>',
                    content: "<b> <?php echo e(__('administrator.status_alert')); ?> "
                    + statusvalue + " ?</b>",
                    type: "red",
                    buttons: {

                        '<?php echo e(__('administrator.cancel')); ?>':
                            {
                                btnClass: 'btn-red',
                                action:
                                    function () {
                                    }
                            }
                        ,
                        '<?php echo e(__('administrator.ok')); ?>':
                            {
                                btnClass: 'btn-blue',
                                action:

                                    function () {
                                        $.ajax({
                                            type: "GET",
                                            dataType: "json",
                                            url: '<?php echo e(route("bus_changeStatus")); ?>',
                                            data: {'status': check_status, 'id': id},
                                            success: function (data) {
                                                $('#loading').hide();
                                                location.reload();

                                            }

                                        });
                                    }
                            }
                    }
                }))

                    return false;
            }
        });

    </script>
<?php $__env->stopSection(); ?>





<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/bus/index.blade.php ENDPATH**/ ?>