<?php

use App\BranchModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailPaddingModel;
use App\DeliveryOrderDetailProccessingModel;
use App\DeliveryOrderDetailShopModel;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderModel;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use App\InvoicePaymentModel;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

Route::get('/en', 'LanguageController@en')->name('en');
Route::get('/km', 'LanguageController@km')->name('km');
Route::get('clear-cache', function () {
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    return redirect()->back();
});
// Route::get('clear-all-data',function(){
//     DB::table('nos007_inport_stock')->truncate();
//     DB::table('nos007__stocks')->truncate();
//     DB::table('nos007_inport_stock_details')->truncate();
//     DB::table('nso007_export_stock')->truncate();
//     DB::table('nso007_export_stock_details')->truncate();

//     //delivery
//     DB::table('nso007_delivery_order_detail_cancel')->truncate();
//     DB::table('nso007_delivery_order_detail_return_to_shop')->truncate();
//     DB::table('nso007_delivery_order_detail_proccessing')->truncate();
//     DB::table('nso007_delivery_order_detail_padding')->truncate();
//     DB::table('nso007_delivery_order')->truncate();
//     DB::table('nso007_delivery_order_detail_success')->truncate();
//     DB::table('nso007_delivery_order_detail')->truncate();
//     //invoice
//     DB::table('nso007_invoice_payment')->truncate();
//     //history
//     DB::table('nso007_box_history')->truncate();
//     Artisan::call('cache:clear');
//     return redirect()->back()->with('success','Data Has Been Clear Successful!');
// });
Route::get('key', function () {
    return Artisan::call('key:generate');
});
Route::get('update-box_code',function(){
    $data = DB::table('nso007_export_stock')->orderBy('id','DESC')->chunk(100,function($data){
        foreach($data as $val){
          $new_box_code = substr($val->box_code, 0, 3).'0'.preg_replace('/\D/', '',  $val->box_code);
          DB::table('nso007_export_stock')->where('box_code',$val->box_code)->update(['box_code'=>$new_box_code]);
        }
    });
});
Route::get('update-shop-prefix',function(){
    $data = DB::table('users')->where('user_type',3)->orderBy('id','ASC')->chunk(100,function($data){
        foreach($data as $key=>$val){
            $prefix_code = $key + 1;
          DB::table('users')->where('id',$val->id)->update(['prefix_pdf'=>$prefix_code]);
        }
    });
});
Route::get('storage:link', function () {
    Artisan::call('storage:link');
    return redirect()->back();
});
Auth::routes(['verify' => true]);
Auth::routes();

// Route::group(['middleware' => 'Administrator', ['auth']], function () {
//     Route::get('/','Administrator\DashboardController@index')->name('app_dashboard');
// });
Route::group(['middleware' => ['auth']], function () {
    Route::get('/', 'Administrator\DashboardController@index')->name('app_dashboard');
    Route::POST('/dashboard', 'Administrator\DashboardController@dashboard')->name('dashboard1');

});
// Route::get('qr-code-g', function () {
//     \QrCode::size(500)
//               ->format('png')
//               ->generate('ItSolutionStuff.com', public_path('images/qrcode.png'));
//     return view('qrCode');
//   });


// Route::get('/share-link-public/{id}', 'LanguageController@km')->name('km');


Route::resource('/share-link', 'Administrator\ShareLinkConroller');
Route::get('/share-links/{id}/{date?}', 'Administrator\ShareLinkConroller@share_links')->name('share-links');



Route::group(['middleware' => 'MultipleAccess', ['auth'], 'namespace' => 'Administrator', 'prefix' => 'nso'], function () {
    // Route::get('delete-data',function(){
    //     $export = ExportStockModel::where('nso007_export_stock.export_date','<',date('Y-m-d',strtotime("2022-05-15")));
    //     foreach($export->cursor() as $val){
    //         ExportStockdetailsMode::where('export_id',$val->id)->delete();
    //     }
    //     $export->delete();
    //     $delivery = DeliveryOrderModel::where('delivery_date','<',date('Y-m-d',strtotime("2022-05-15")));
    //     foreach($delivery->cursor() as $val){
    //         DeliveryOrderDetailModel::where('delivery_order_id',$val->id)->delete();
    //         DeliveryOrderDetailShopModel::where('delivery_order_id',$val->id)->delete();
    //         DeliveryOrderDetailCancelModel::where('delivery_order_id',$val->id)->delete();
    //         DeliveryOrderDetailPaddingModel::where('delivery_order_id',$val->id)->delete();
    //         DeliveryOrderDetailSuccessModel::where('delivery_order_id',$val->id)->delete();
    //         DeliveryOrderDetailProccessingModel::where('delivery_order_id',$val->id)->delete();
    //     }
    //     $delivery->delete();
    //     InvoicePaymentModel::where('date','<',date('Y-m-d',strtotime("2022-05-15")))->delete();

    // });
    Route::resource('clear-data', 'ClearDataController');
    Route::resource('currency', 'CurrencyController');
    Route::GET('/appearance', 'DashboardController@appearance')->name('admin.appearance');
    Route::POST('/appearance-update/{id}', 'DashboardController@appearance_update')->name('admin.appearance.update');
    Route::GET('/account-profile', 'AccountProfileController@account_profile')->name('account_profile');
    Route::POST('/account-profile/change-password', 'AccountProfileController@change_password')->name('change_password');

    Route::resource('/roles', 'RoleController');
    Route::resource('/users', 'UserController');

    Route::GET('user-status', 'UserController@user_status');

    route::resource('/category', 'CategoryController');
    route::get('/category-changeStatus', 'CategoryController@category_changeStatus')->name('category_changeStatus');
    route::get('/category-delete/{id}', 'CategoryController@destroy')->name('delete_category');

    route::resource('/location', 'LocationController');
    route::resource('/location-with-zone', 'LocationWithZoneController');
    route::POST('/location-import', 'LocationWithZoneController@import')->name('location-import');
    route::resource('/bus', 'BusController');
    route::get('/bus-changeStatus', 'BusController@bus_changeStatus')->name('bus_changeStatus');


    route::get('/find-price-bus', 'BusController@price')->name('find_price_bus');


    route::POST('/location-save', 'LocationController@locationSave')->name('locationSave');
    route::POST('/location-save-new', 'LocationController@locationSaveNew')->name('locationSave_new');
    route::get('/get-location', 'LocationController@getLocation')->name('getLocation');
    route::POST('/get-location-edit', 'LocationController@getLocation_edit')->name('getLocation_edit');
    route::POST('/get-location_new-edit', 'LocationController@getLocation_new_edit')->name('getLocation_new_edit');
    route::POST('/location-delete', 'LocationController@location_delete')->name('location_delete');

    route::resource('/location-price-list', 'LocationPriceListController');



    route::resource('/product', 'ProductsController');
    route::get('/get-product', 'ProductsController@getProduct')->name('getProduct');
    route::get('/product-delete/{id}', 'ProductsController@destroy')->name('product_delete');
    route::resource('/driver', 'DriverController');

    Route::GET('driver-status', 'DriverController@driver_status');
    Route::GET('/driver-info/{id}', 'DriverController@driver_info');

    Route::GET('history-driver-list', 'DriverController@history_driver')->name('history_driver');
    Route::GET('history-driver-list-detail', 'DriverController@history_driver_detail')->name('history_driver_detail');
    Route::GET('history-by-driver-list', 'DriverController@history_by_driver')->name('history_by_driver');

    Route::GET('summary-driver-list', 'DriverController@summary_driver')->name('summary_driver');
    Route::match(['GET', 'POST'], 'summary-driver-data', 'DriverController@datable_summary_driver')->name('datatable.datable_summary_driver');

    Route::GET('export-to-excel', 'ClearInvoiceController@export_to_excel')->name('export_to_excel');


    // Route::POST('report-for-shop-print/{type}', 'DeliveryController@report_for_shop_print')->name('report_for_shop_print');

    route::GET('history-driver-list-show', 'DriverController@history_driver_show')->name('history_driver_show');

    Route::match(['GET', 'POST'], 'history-driver-data', 'DriverController@datable_history_driver')->name('datatable.datable_history_driver');
    Route::POST('history-driver-print', 'DriverController@history_driver_print')->name('history_driver_print');

    Route::get('/delivery-action/{id}/{status}/{reason?}', 'DriverDetailController@deliveryAction');


    Route::POST('driver-clear-box', 'DriverController@driver_clear_box')->name('driver.clear_box');

    Route::get('verify-by/{id},{delivery_order_id}', 'DriverController@verify_by')->name('driver.verify_by');



    Route::resource('/merchant', 'MerchantController');
    Route::GET('merchant-status', 'MerchantController@merchant_status');
    Route::POST('datable-merchant', 'MerchantController@datable_merchant')->name('datatable.datable_merchant');
    Route::GET('/merchant-info/{id}', 'MerchantController@merchant_info');

    Route::resource('/import-stock', 'ImportStockController');
    Route::match(['GET', 'POST'], 'add-cart-produc', 'ImportStockController@get_product')->name('get_product');
    Route::get('get-product-update', 'ImportStockController@get_product_upadate')->name('get_product_upadate');
    Route::post('stock-removecart', 'ImportStockController@stock_removecart')->name('stock_removecart');
    Route::POST('autocomplete', 'ImportStockController@autocomplete')->name('autocomplete');
    Route::post('import-stock-update', 'ImportStockController@update_all')->name('import-stock-update');
    Route::post('import-stockupdate', 'ImportStockController@import_stock_update')->name('import_stock_update');
    Route::post('import-stockudelete', 'ImportStockController@import_stock_delete')->name('import_stock_delete');
    Route::post('import-stock-main-delete', 'ImportStockController@import_stock_main_delete')->name('import_stock_main_delete');


    //    --------------  Export create  -----------
    Route::resource('/export-stock', 'ExportStockController');
    Route::get('/print-all-box', 'ExportStockController@print')->name('print-all-box');

    Route::get('/print-return-to-shop', 'ExportStockController@print_return_shop')->name('print-return-to-shop');

    Route::resource('/delivery-list', 'DeliveryListController');
    Route::get('delivery-list-new','DeliveryListController@list_new')->name('delivery-list-new');
    Route::POST('back-bage', 'ExportStockController@back_bage')->name('back_bage');
    Route::GET('/export-stock-delete-box/{id}/{status}', 'ExportStockController@deleteBox')->name('export_stock_delete_box');

    Route::resource('/export-stock-new', 'ExportStockNewController');

    Route::POST('export-stock-find-show-product', 'ExportStockController@get_show_product')->name('get_show_product');
    Route::match(['GET', 'POST'], 'export-stock-find-product', 'ExportStockController@get_product')->name('get_product_export_stock');
    Route::post('export-stock-removecart', 'ExportStockController@export_stock_removecart')->name('export_stock_removecart');
    Route::post('update-all-export-stock', 'ExportStockController@update_all')->name('update-all-export-stock');
    Route::get('export-stock-view-list', 'ExportStockController@get_product_view_list')->name('get_product_view_list');
    Route::GET('find-main-location', 'ExportStockController@find_location')->name('find-main-location');
    Route::GET('find-location-price', 'ExportStockController@find_price_location')->name('find_price_location');

    //    --------------  Export Edit  -----------
    Route::POST('export-stock-find-show-product-edit', 'ExportStockController@get_show_product_edit')->name('get_show_product_edit');
    Route::get('export-stock-view-list-edit', 'ExportStockController@get_product_view_list_edit')->name('get_product_view_list_edit');
    Route::match(['GET', 'POST'], 'export-stock-find-product-edit', 'ExportStockController@get_product_edit')->name('get_product_export_stock_edit');
    Route::post('export-stock-removecart-edit', 'ExportStockController@export_stock_removecart_edit')->name('export_stock_removecart_edit');
    Route::post('update-all-export-stock-edit', 'ExportStockController@update_all_edit')->name('update-all-export-stock_edit');


    Route::resource('/out-stock', 'OutStockController');
    Route::match(['GET', 'POST'], 'out-stock-category', 'OutStockController@get_product')->name('get_product-outstock');
    Route::POST('out-fstock-find-category', 'OutStockController@autocomplete')->name('autocomplete-find-category');


    Route::resource('/out-stock-new', 'OutStockNewController');
    Route::get('/out-stock-add-box', 'OutStockNewController@add_box')->name('add-box');
    Route::match(['GET', 'POST'], 'find-merchant/{id?}', 'OutStockNewController@find_merchant')->name('find-merchant');

    ////////////////////////////////DeliveryController////////////////////////////////
    Route::resource('/delivery-order', 'DeliveryController');
    Route::match(['GET', 'POST'], 'search-box', 'DeliveryController@get_product')->name('search-box');
    Route::match(['GET', 'POST'], 'search-box-array', 'DeliveryController@get_product_array')->name('search-box-array');
    Route::POST('delivery-order-autocomplete', 'DeliveryController@autocomplete')->name('delivery-order-autocomplete');
    Route::get('get-delivery-order-view-list', 'DeliveryController@get_list_view')->name('get_list_view');
    Route::post('stock-list-delivery-order', 'DeliveryController@delivery_order_removecart')->name('delivery_order_removecart');

    Route::resource('/delivery-order-new', 'DeliveryNewController');
    Route::get('delivery-order-print-voucher/{id?}','DeliveryNewController@print_voucher')->name('delivery-order-print-voucher');
    Route::get('delivery-order-clear-driver-voucher/{id?}','DeliveryNewController@clear_driver_voucher')->name('delivery-order-clear-driver-voucher');


    Route::get('clear-driver-voucher-history/{id?}','DeliveryNewController@clear_driver_voucher_history')->name('clear-driver-voucher-history');
    Route::get('delivery-order-print-voucher-to-driver/{id?}','DeliveryNewController@print_voucher_to_driver')->name('delivery-order-print-voucher-to-driver');
    Route::get('delivery-order-print-voucher-clear-driver/{id?}','DeliveryNewController@print_voucher_clear_driver')->name('delivery-order-print-voucher-clear-driver');

    Route::get('/update-taxi-option', 'DeliveryNewController@update_taxi_option')->name('update_taxi_option');
    Route::get('/update-description', 'DeliveryNewController@update_description')->name('update-description');
    Route::get('/update-update-cus_is_recieve', 'DeliveryNewController@update_cus_is_recieve')->name('update-cus_is_recieve');
    Route::get('/clear_by_driver/{id?}', 'DeliveryNewController@clear_by_driver')->name('clear-by-driver');
    Route::POST('/clear-multi-driver', 'DeliveryNewController@clear_by_multi_driver')->name('clear-multi-driver');

    Route::resource('/assign-driver', 'AssignDriverController');

    Route::get('get-delivery-item-show-hide', 'DeliveryController@get_item_show_hide')->name('get_item_show_hide');
    Route::get('get-delivery-item-show-hide-edit', 'DeliveryController@get_item_show_hide_edit')->name('get_item_show_hide_edit');

    route::GET('list-delivery-seccess', 'DeliveryController@list_delivery_seccess')->name('list_delivery_seccess');
    route::GET('list-delivery-cancel', 'DeliveryController@list_delivery_cancel')->name('list_delivery_cancel');
    route::GET('list-delivery-padding', 'DeliveryController@list_delivery_padding')->name('list_delivery_padding');
    Route::post('delivery-order-cencel', 'DeliveryController@delivery_order_cencel')->name('delivery_order_cencel');
    Route::post('add-to-stock', 'DeliveryController@add_to_stock')->name('add_to_stock');

    Route::post('add-to-stock-multi', 'DeliveryController@add_to_stock_multi')->name('add-to-stock-multi');
    Route::post('return-to-shop-multi', 'DeliveryController@return_to_shop_multi')->name('return-to-shop-multi');
    Route::post('back-to-processing-multi', 'DeliveryController@back_to_process_multi')->name('back-to-processing-multi');
    Route::post('approve-return-to-shop','DeliveryController@appove_return_to_shop')->name('approve-return-to-shop');




    Route::GET('history-delivery-list', 'ReportController@history_delivery')->name('history_delivery');
    Route::GET('history-delivery-box', 'ReportController@history_box')->name('history_box');
    Route::GET('history-delivery-box-show', 'ReportController@history_box_show')->name('history_box_show');
    Route::POST('get-merchant-in-report-delivery', 'ReportController@get_merchant')->name('get_merchant_in_report_delivery');

    Route::match(['GET', 'POST'], 'history-delivery_data', 'ReportController@datable_history_delivery')->name('datatable.history_delivery');

    Route::get('report-for-shop-print/{type}', 'ReportController@report_for_shop_print')->name('report_for_shop_print');
    Route::get('report-for-shop-print-new/{type}', 'ReportNewController@report_for_shop_print')->name('report_for_shop_print-new');
    Route::GET('summary-delivery-list', 'ReportController@SummaryDeliveryList')->name('summary-delivery-list');
    Route::GET('summary-delivery-print/{from_date}/{to_date}/{merchant_id}/{data_view}/{status?}', 'ReportController@SummaryDeliveryPrint')->name('summary-delivery-print');
    Route::POST('summary-delivery-print-all', 'ReportController@SummaryDeliveryListAll')->name('summary-delivery-list-all');



    Route::POST('history-delivery-print/{type}', 'DeliveryController@history_delivery_print')->name('history_delivery_print');
    // Route::GET('history-in_processing-list', 'DeliveryController@in_processing')->name('in_processing');
    Route::match(['GET', 'POST'], 'in-processing-list', 'DeliveryController@in_processing')->name('in_processing');
    Route::match(['GET', 'POST'], 'in-stock-delivert-list', 'DeliveryController@in_stock_delivery')->name('in_stock_delivery');

    ////////////////////////////////EDIT////////////////////////////////
    Route::get('get-delivery-order-view-list-edit', 'DeliveryController@get_list_view_edit')->name('get_list_view_edit');
    Route::match(['GET', 'POST'], 'search-box-edit', 'DeliveryController@get_product_edit')->name('search-box-edit');
    Route::POST('out-stock-find-category-edit', 'DeliveryController@autocomplete_edit')->name('autocomplete-find-category-edit');
    Route::get('get-delivery-order-view-list-delete', 'DeliveryController@get_list_view_delete')->name('get_list_view_delete');
    Route::POST('reset-session', 'DeliveryController@reset_session')->name('reset-session');
    Route::GET('/delivery-order-list/{id}', 'DeliveryController@delivery_order_list')->name('delivery_order_list');
    Route::get('datable-delivery-order-list', 'DeliveryController@datable_delivery_order_list')->name('datable_delivery_order_list');
    Route::get('delivery-order-action/{id}/{status}/{reason?}', 'DeliveryController@delivery_order_action');
    Route::get('delivery-order-action-ajax/{id}/{status}/{reason?}', 'DeliveryController@delivery_order_action_ajax')->name('delivery-order-action-ajax');

    Route::POST('update-to-pending','DeliveryController@update_to_pending')->name('update-to-pending-ajax');
    Route::POST('update-to-cancel','DeliveryController@update_to_cancel')->name('update-to-cancel-ajax');
    Route::POST('update-to-return-to_shop','DeliveryController@update_to_return_to_shop')->name('update-to-return-to_shop-ajax');
    Route::POST('update-to-return-proccess','DeliveryController@update_to_return_proccess')->name('update-to-return-proccess-ajax');


    Route::POST('/delivery-action-edit-price-car', 'DeliveryController@deliveryActionEditPrice')->name('deliveryActioneditPrice');
    Route::POST('/delivery-action-change-price', 'DeliveryController@deliveryActionChangePrice')->name('deliveryActionChangePrice');

    Route::POST('delivery-done-all', 'DeliveryController@done_all')->name('delivery.done_all');
    route::GET('delivery-payable-show', 'DeliveryController@delivery_payable_show')->name('delivery_payable_show');


    Route::POST('delivery-change-driver', 'DeliveryController@changeDriver')->name('delivery.change-driver');
    Route::POST('delivery-change-driver-multi', 'DeliveryController@changeDriverMulti')->name('delivery.change-driver-multi');


    ////////////////////////////////EDIT////////////////////////////////
    Route::resource('/stock', 'StockController');
    Route::match(['get', 'post'], 'stock-balance', 'StockController@datatble_stock_balance')->name('datatble_stock_balance');
    Route::POST('stock-balance-print', 'StockController@stock_balance_print')->name('stock_balance_print');

    Route::resource('/payment', 'PaymentController');
    Route::match(['GET', 'POST'], 'datatable-payment', 'PaymentController@datatable_payment')->name('datatable_payment');
    route::GET('payment-show', 'PaymentController@paymente_show')->name('paymente_show');
    Route::get('payment-store/{id}', 'PaymentController@store');
    Route::get('payment-show/{id}', 'PaymentController@show');

    Route::get('delivery-return-in-processing/{id}/{statu}', 'DeliveryController@delivery_return_processing');
    Route::get('return-in-processing/{id}/{statu}/{from_status}', 'DeliveryController@return_to_processing');
    Route::get('return-in-shop/{id}/{statu}/{from_status}', 'DeliveryController@return_to_shop');
    Route::get('return-in-shop-excel','ExportStockController@return_export_excel')->name('return-in-shop-excel');

    Route::resource('/clear-invoice', 'ClearInvoiceController');
    Route::get('clear-invoice-export','ClearInvoiceController@export_excel')->name('clear-invoice-export');
    Route::resource('/clear-invoice-new', 'ClearInvoiceNewController');
    Route::GET('pay-later/{id}', 'ClearInvoiceController@pay_later');


    Route::resource('/clear-dirver', 'ClearInvoiceDriverContrller');
    Route::get('/clear-invoice-dirver/{driver_voucher}', 'ClearInvoiceDriverContrller@clearinvoicedirver');

    Route::get('/driver-report', 'ReportController@report_driver')->name('driver-report');

    Route::resource('/assign-to-driver-1', 'AssignToDriverController1');
    Route::get('/list-pickup', 'AssignToDriverController1@list_pickup')->name('list_pickup');
    Route::GET('history-list-pickup', 'AssignToDriverController1@history_pickup')->name('history_pickup');
    Route::get('search-history-pickup', 'AssignToDriverController1@search_history_pickup')->name('search_history_pickup');
    Route::POST('history-pickup-print', 'AssignToDriverController1@history_pickup_print')->name('history_pickup_print');

    Route::get('assign-show','AssignToDriverController1@assign_show')->name('assign_show');

    Route::POST('box-pickup-edit', 'AssignToDriverController1@box_pickup_edit')->name('box_pickup_edit');

    Route::POST('box-pickup-show-list', 'AssignToDriverController1@box_pickup_show_list')->name('box_pickup_show_list');
    Route::POST('assign-driver-pickup', 'AssignToDriverController1@assign_driver_pickup')->name('assign_driver_pickup');

    // Route::get('assign-to-order/{list_id}', 'AssignToDriverController1@assign_to_order');
    Route::get('go-to-order/{list_id}/{status}', 'AssignToDriverController1@go_to_order');

    Route::POST('box-pickup-done', 'AssignToDriverController1@box_pickup_done')->name('box_pickup_done');

    Route::POST('box-pickup-delete', 'AssignToDriverController1@box_pickup_delete')->name('box_pickup_delete');
    Route::POST('box-pickup-delete-main', 'AssignToDriverController1@box_pickup_delete_main')->name('box_pickup_delete_main');

    Route::GET('find-main-location-pick-up', 'AssignToDriverController1@find_location')->name('find-main-location-pick-up');
    Route::GET('find-location-price-pick-up', 'AssignToDriverController1@find_price_location')->name('find_price_location-pick-up');
    Route::POST('box-pickup-update', 'AssignToDriverController1@update')->name('pickup-update');



    Route::resource('/roles-commitment', 'RolesCommitmentController');
    Route::Post('/roles-commitment/delivery', 'RolesCommitmentController@delivery_store')->name('roles-commitment.delivery_store');


    Route::resource('/discount', 'DiscountController');
    Route::POST('/discount_daliy', 'DiscountController@discount_daliy')->name('discount_daliy');
    Route::get('/discount-for-shop', 'DiscountController@forshop')->name('discount-for-shop');

    Route::POST('/approve', 'ReportController@approve')->name('approve');

    Route::resource('/driver-task', 'DriverTaskController');

    Route::resource('report-for-shop-new', 'ReportShopNewController');
    Route::get('report-shop-detail-new/{id}', 'ReportShopNewController@print_detail')->name('report-for-shop-new.print');
    Route::POST('clear-multi-shop', 'ReportShopNewController@clear_multi')->name('clear-multi-shop');
    Route::get('shop-voucher-excel','ReportShopNewController@excel')->name('shop-voucher-excel');
    Route::get('shop-voucher-excel-shop','ReportShopNewController@excel_shop')->name('shop-voucher-excel-shop');
    Route::get('shop-voucher-excel-qty','ReportShopNewController@excel_qty')->name('shop-voucher-excel-qty');

    Route::resource('report-for-shop', 'ReportShopController');
    Route::get('report-shop', 'ReportShopController@report_shop')->name('report-shop');


    Route::get('report-shop-detail/{id}', 'ReportShopController@print_detail')->name('report-for-shop.print');
    Route::get('report-shop-print/{type}', 'ReportShopController@print')->name('report_shop_print');

    Route::POST('edit-price/{id}', 'DriverController@edit_price')->name('driver.edit_price');

    Route::get('change-menu', 'DashboardController@change_menu')->name('change-menu');


    Route::get('report-for-shop-datatable', 'ReportShopController@datatable')->name('report-for-shop-datatable');


    Route::resource('daily-report', 'DailyReportController');
    //Pickup admin
    Route::resource('pickup-admin','PickupAdminController');
    Route::post('pickup-assign-driver','PickupAdminController@assign_driver')->name('pickup-assign-driver');
    Route::post('change-driver/{pickupadminid?}','PickupAdminController@change_driver')->name('change-driver');
    Route::get('driver-pickup-admin-list','PickupAdminController@driverPickup')->name('driver-pickup-list');
    Route::match(["GET","POST"],"return-pickup-admin/{id}","PickupAdminController@return")->name('return-pickup-admin');
    Route::match(["GET","POST"],"approve-pickup-admin/{id}","PickupAdminController@approve")->name('approve-pickup-admin');
    Route::get('pickup-admin-success','PickupAdminController@pickupSuccess')->name('pickup-admin-success');




    // New System V2
    ////////////////////////////////DeliveryController////////////////////////////////
    Route::resource('/delivery-orders', 'DeliveryOrderController');
    Route::GET('/delivery-order-lists/{id}', 'DeliveryOrderController@delivery_order_list')->name('delivery_order_lists');
    Route::get('datable-delivery-order-lists', 'DeliveryOrderController@datable_delivery_order_list')->name('datable_delivery_order_lists');



    // Report Driver
    Route::resource('report-driver','ReportDriverControler')->only(['index','show']);
    Route::get('report-driver-pickup','ReportDriverControler@report_pickup')->name('report-driver-pickup');
    // Report Driver Income
    Route::resource('report-driver-revenue','ReportDriverRevenueController')->only(['index','show']);
    // Report Shop
    Route::resource('report-shox-box','ReportShopLastController')->only(['index','show']);
    // Report Shop Income
    Route::resource('report-shox-income','ReportShopIncomeController')->only(['index','show']);
    Route::get("update-dpl-code",function(){
        $data = DB::table('nso007_export_stock')
                ->selectRaw('id,box_code,COUNT(box_code) as count')
                ->groupby('box_code')
                ->having('count', '>', 1);
            foreach ($data->cursor() as $key => $val) {
                $data1 = DB::table('nso007_export_stock')
                    ->where('box_code', $val->box_code)
                    ->orderBy('box_code');
                foreach($data1->cursor() as $key1=> $update){
                        if ($key1 > 0) {
                            $last_id = ExportStockModel::max('id');
                            $header_invoice = BranchModel::first();
                            if ($last_id) {
                                $box_code = ExportStockModel::select('box_code')->orderBy('box_code','DESC')->first();
                                $tran_num = substr($box_code->box_code, 3);
                                $increas = $header_invoice->header_invoice_import . sprintf('%09d', ($tran_num + 1));
                            } else {
                                $increas = $header_invoice->header_invoice_import . '000000001';
                            }
                            DB::table('nso007_export_stock')->where('id', $update->id)->update(['box_code' => $increas]);
                        }
                }
            }
        return redirect()->back();
    });
    Route::get('update',function(){
        $delivery = DeliveryOrderModel::orderby('id','DESC');
        foreach($delivery->cursor() as $key => $val){
            DeliveryOrderDetailModel::where('delivery_order_id',$val->id)->update(['done_date'=>$val->delivery_date]);
        }
        $delivery_order_detail = DeliveryOrderDetailModel::orderby('id','DESC')->chunk(100,function($delivery_order_detail){
            foreach($delivery_order_detail as $val){
                ExportStockModel::where('id',$val->export_id)->update(['done_date'=>$val->done_date]);
            }
        });

    });
});

Route::group(['middleware' => ['auth'], 'namespace' => 'Accounting', 'prefix' => 'nso'], function () {

    Route::resource('/account-chart', 'AccountChartController');
    Route::resource('/account-receivable', 'AccountReceivableController');
    Route::resource('/account-payable', 'AccountPayableController');

    ////////////////////////////////INCOME////////////////////////////////
    Route::resource('/income', 'IncomeController');
    Route::get('report-income', 'IncomeController@reportIncome')->name('reportIncome');
    Route::match(['get', 'post'], 'get-report-income', 'IncomeController@getReportIncome')->name('getReportIncome');
    Route::POST('report-income-print', 'IncomeController@reportIncomePrint')->name('reportIncomePrint');
    Route::POST('delete-income', 'IncomeController@delete_income')->name('delete_income');


    ////////////////////////////////EXPENSE////////////////////////////////
    Route::resource('/expense', 'ExpenseController');
    Route::get('report-expense', 'ExpenseController@reportExpense')->name('reportExpense');
    Route::match(['get', 'post'], 'get-report-expense', 'ExpenseController@getReportExpense')->name('getReportExpense');
    Route::POST('report-expense-print', 'ExpenseController@reportExpensePrint')->name('reportExpensePrint');
    Route::POST('delete-expense', 'ExpenseController@delete_expense')->name('delete_expense');

    ////////////////////////////////CASH ON HAND////////////////////////////////

    Route::get('cash-on-hand', 'CashOnHandController@index')->name('cash-on-hand');
    Route::match(['get', 'post'], 'get-cash-on-hand', 'CashOnHandController@getCashOnHand')->name('getCashOnHand');
    Route::POST('report-cash-on-hand-print', 'CashOnHandController@reportCashOnHandPrint')->name('reportCashOnHandPrint');


    ////////////////////////////////INCOMESTATEMENT////////////////////////////////
    Route::match(['get', 'post'], 'income-statement', 'IncomeStatementController@IncomeStatement')->name('IncomeStatement');
    Route::POST('report-income-statement-print', 'IncomeStatementController@reportIncomeStatementPrint')->name('reportIncomeStatementPrint');

});

Route::group(['middleware' => 'Driver', ['auth'], 'namespace' => 'Driver'], function () {
    Route::get('/drivers', 'DashboardController@index')->name('dashboard_driver');

    Route::get('driver-pickup-admin','DriverDetailController@pickupAdmin')->name('driver-pickup-admin');
    Route::get('driver-pickup-admin-history','DriverDetailController@pickupAdminHistory')->name('pickup-admin-history');
    Route::match(["GET","POST"],'confirm-pickup/{id?}','DriverDetailController@confirmPickup')->name('confirm-pickup');

    Route::match(['get', 'post'],'/on-delivery-to-day', 'DriverDetailController@onDeliveryToDay')->name('onDeliveryToDay');
    Route::get('/delivery-to-successful', 'DriverDetailController@deliveryToSuccessful')->name('deliveryToSuccessful');
    Route::get('/history-driver', 'DriverDetailController@historyDriver')->name('historyDriver');

    Route::get('/daily-collect-money', 'DriverDetailController@dailyDailyCollectMoney')->name('dailyDailyCollectMoney');
    Route::get('/daily-delivery', 'DriverDetailController@dailyDelivery')->name('dailyDelivery');
    Route::get('/daily-delivery-detail/{date}', 'DriverDetailController@dailyDeliveryDetail')->name('dailyDeliveryDetail');
    Route::get('/daily-commission', 'DriverDetailController@dailyCommission')->name('dailyCommission');

    Route::get('/delivery-action/{id}/{status}/{reason?}', 'DriverDetailController@deliveryAction');
    Route::POST('/delivery-action-edit-price', 'DriverDetailController@deliveryActionEditPrice')->name('deliveryActionEditPrice1');
    Route::resource('/pickup', 'DriverPickupController');

    Route::get('/pickup/show/{id}', 'DriverPickupController@create')->name('pickup-show');
    Route::POST('/pickup/delect', 'DriverPickupController@pickup_delect')->name('pickup_delect');
    Route::POST('/pickup/edit', 'DriverPickupController@edit')->name('pickup_edit');
    Route::POST('/pickup/update', 'DriverPickupController@update')->name('pickup_update');
    Route::POST('/pickup/done', 'DriverPickupController@pickup_done')->name('pickup_done');
    Route::GET ('/print-iteam/{id}', 'DriverPickupController@print_iteam')->name('pickup.print_iteam');
    Route::GET ('/print-invoice/{id}', 'DriverPickupController@print_invoice')->name('pickup.print_invoice');

    Route::get('/pickup-history', 'DriverPickupController@pickup_history')->name('pickup_history');


    Route::GET('find-pickup-main-location', 'DriverPickupController@find_location')->name('find-pickup-main-location');
    Route::GET('find-pickup-location-price', 'DriverPickupController@find_price_location')->name('find-pickup-price-location');
    Route::post('pending_pickup-store', 'DriverPickupController@backup_item_store')->name('backup_item_store');
    Route::post('pending_pickup-edit', 'DriverPickupController@backup_item_edit')->name('backup_item_edit');
    Route::post('pending_pickup-update', 'DriverPickupController@backup_item_update')->name('backup_item_update');
    Route::post('pending_pickup-delete', 'DriverPickupController@pending_pickup_delete')->name('pending_pickup_delete');
});


Route::group(['middleware' => 'Merchant', ['auth'], 'namespace' => 'Merchant'], function () {
    Route::get('/dashboard-merchant', 'DashboardController@index')->name('dashboard_merchant');
    Route::get('/dashboard-merchant/pick-up/show/{id}', 'RequestController@show')->name('show');
    Route::get('/dashboard-merchant/pick-up/cancel/{id}', 'RequestController@cancel')->name('cancel');
    Route::Post('/dashboard-merchant/request', 'RequestController@store')->name('merchant_request');
    Route::get('/dashboard-merchant/pick-up', 'RequestController@index')->name('merchant_pickup');
    Route::post('/dashboard-merchant/pick-up/merchant-in/import-stock/store', 'RequestController@merchant_in_import_stock')->name('merchant_in_pickup.import_stock_store');

    Route::get('/dashboard-merchant/pick-up/create', 'PickUpController@create')->name('merchant_pickup.create');
    Route::GET('merchant-find-location', 'PickUpController@find_location')->name('merchant_find_location');
    Route::GET('merchant-find-delivery-fee', 'PickUpController@find_delivery_fee')->name('find_delivery_fee');
    Route::post('merchant_pending_pickup/store', 'PickUpController@merchant_pending_pickup_store')->name('merchant_pending_pickup.store');
    Route::post('merchant_pending_pickup/edit', 'PickUpController@merchant_pending_pickup_edit')->name('merchant_pending_pickup.edit');
    Route::post('merchant_pending_pickup/delete', 'PickUpController@merchant_pending_pickup_delete')->name('merchant_pending_pickup.delete');
    Route::post('merchant_pending_pickup/update', 'PickUpController@merchant_pending_pickup_update')->name('merchant_pending_pickup.update');


    //Merchent in stock
    Route::get('/dashboard-merchant/pick-up/merchant-in/create', 'PickUpController@create_merchant_in')->name('merchant_in_pickup.create');
    Route::get('/dashboard-merchant/pick-up/merchant-in/import-stock', 'PickUpController@merchant_in_import_stock')->name('merchant_in_pickup.import_stock');

    Route::Post('/dashboard-merchant/pick-up/show-store', 'RequestController@show_store')->name('merchant_request_pickup_show.store');
    Route::Post('/dashboard-merchant/pick-up/show-edit', 'RequestController@show_edit')->name('merchant_request_pickup_show.edit');
    Route::Post('/dashboard-merchant/pick-up/show-update', 'RequestController@show_update')->name('merchant_request_pickup_show.update');
    Route::Post('/dashboard-merchant/pick-up/show-delete', 'RequestController@show_delete')->name('merchant_request_pickup_show.delete');

    Route::get('/dashboard-merchant/pick-up/merchant-in/stock', 'PickUpController@merchant_in_stock')->name('merchant_in_pickup.stock');


    Route::get('/dashboard-merchant/report-stock', 'ReportController@report_stock')->name('report_stock');
    Route::get('/dashboard-merchant/report-inprocessing', 'ReportController@report_inprocessing')->name('report_inprocessing');
    Route::get('/dashboard-merchant/report-success', 'ReportController@report_success')->name('report_success');
    Route::get('/dashboard-merchant/report-cancel', 'ReportController@report_cancel')->name('report_cancel');
    Route::get('/dashboard-merchant/report-pending', 'ReportController@report_pending')->name('report_pending');
    Route::get('/dashboard-merchant/report-history-delivery', 'ReportController@report_history_delivery')->name('report_history_delivery');
    Route::get('/dashboard-merchant/report-history-pickup', 'ReportController@report_history_pickup')->name('report_history_pickup');
    Route::get('/dashboard-merchant/history-pickup-detail/{date}', 'ReportController@history_pickup_detail')->name('history_pickup_detail');

    Route::get('/dashboard-merchant/report-package', 'ReportController@report_package')->name('report_package');




});
