<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group([
    'prefix' => 'auth'
], function () {
    Route::post('login', 'api\LoginController@login');
  
    Route::group([
      'middleware' => 'auth:api'
    ], function() {
        Route::get('logout', 'api\LoginController@logout');
        Route::get('user', 'api\LoginController@user');
        Route::get('/driver/dashboard', 'api\driver\DashboardController@index');
        Route::get('/driver/on-delivery-today', 'api\driver\DriverDetailController@onDeliveryToDay');
        
        Route::get('/driver/on-success', 'api\driver\DriverDetailController@deliveryToSuccessful');
        Route::get('/driver/daily-commission', 'api\driver\DriverDetailController@dailyCommission');
        Route::get('/driver/daily-delivery-detail/{date}','api\driver\DriverDetailController@dailyDeliveryDetail');
        Route::get('/driver/delivery-action/{id}/{status}/{reason?}','api\driver\DriverDetailController@deliveryAction');
        Route::get('/driver/history-delivery','api\driver\DriverDetailController@historyDriver');

        //pickup
        Route::get('/driver/history-pickup','api\driver\DriverPickupController@pickup_history');
        Route::get('/driver/print-pickup/{id}','api\driver\DriverPickupController@pickup_print');

    });
});
