@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
  <ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li><a href="{{route('customers.index')}}">{{__('administrator.customer')}}</a></li>
    <li class="active">{{__('administrator.customer')}}</li>
  </ol>
</div>
<div class="page">
<div class=container-fluid>
  <div class="top-content">
    <div class="row">
          <div class="col-sm-12 col-xs-12">
              <div class="title-add">
                  <div class="pull-left">
                      <h3>{{__('administrator.customer')}}</h3>
                  </div>
                  <div class="pull-right">
                     <a href="{{route('customers.create')}}" class="button_sm button_info"><span class="fa fa-plus"></span> {{__('administrator.new_customer')}}</a>
                  </div>
              </div>
          </div>
      </div>
  </div>
    <div class="container-fluid">
        <div class="wrapper-form">
            {!! Form::model($data, ['method' => 'POST','enctype'=>'multipart/form-data','route' => ['setting_system_updated', $data->id]]) !!}

        	<div class="setting-system">
        			<div class="pull-right">
                    <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                    <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                        <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                </div>
        			<div class="border-box">
	        			<h3>Order By</h3>
	        			<div class="blog">
                  <strong>Searching </strong>
	        				<input type="radio" name="order_by"  value="ASC" @if($data->order_by == 'ASC') checked @endif>ASC
	        				<input type="radio" name="order_by"  value="DESC" @if($data->order_by == 'DESC') checked @endif>DESC

	        			</div>
	        		</div>

	        		<div class="border-box">
	        			<h3>Datable Table</h3>
  	        			<div class="blog">
                    <strong>Show Entry </strong>
  	        				<input type="radio" name="length_table"  value="10" @if($data->lenght_table == '10') checked @endif>10
  	        				<input type="radio" name="length_table"  value="20" @if($data->length_table == '20') checked @endif>20
  	        				<input type="radio" name="length_table"  value="30" @if($data->length_table == '30') checked @endif>30
  	        				<input type="radio" name="length_table"  value="40" @if($data->length_table == '40') checked @endif>40
  	        				<input type="radio" name="length_table"  value="50" @if($data->length_table == '50') checked @endif>50
  	        				<input type="radio" name="length_table"  value="100" @if($data->length_table == '100') checked @endif>100
  	        				<input type="radio" name="length_table"  value="150" @if($data->length_table == '150') checked @endif>150
  	        				<input type="radio" name="length_table"  value="200" @if($data->length_table == '200') checked @endif>200
  	        				<input type="radio" name="length_table"  value="500" @if($data->length_table == '500') checked @endif>500

  	        			</div>
                  <div class="blog">
                    <strong>Search Table </strong>
                    <label class="switch">
                      <input type="checkbox" name="searching_tbl"  value="false" @if($data->searching_tbl == 'false') checked @endif>
                      <span class="slider round"></span>
                    </label>
                  </div>
	        		</div>

        	</div>
        	{!! Form::close() !!}

        </div>
    </div>
</div>
@endsection
<style type="text/css">
  .switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}

.switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
@section('script')
<script type="text/javascript">

</script>

@endsection
