@extends('layouts.app-mobile-merchant')

@section('content')
<?php Fun::lang()?>
<div class="mobile-dashboard">
    <div class="container">
        <div class="shipping-area">
            <div class="main-showdata">
                @foreach ($data as $item)
                    <div class="col-md-6= col-sm-6 col-xs-12">
                        <div class="show-boxdata">
                            <div class="shop-left">
                                <p>Date : {{date("d-m-Y", strtotime($item->date)) }}</p>
                            </div>
                            <div class="exchage-rate">
                                <p>Exchange Rate:<span>{{$item->exchange_rate}} ៛</span></p>
                                <p>Invoice : {{ $item->invoice_pickup  }}</span></p>
                                <p>Shop Name : {{ $item->shop_name  }}</span></p>
                                <p>Phone Number :  <a href="tel:{{$item->phone}}">{{$item->phone}} </a> </span></p>
                                <p>Description : {{ $item->description  }}</span></p>
                                <p>Location : {{ $item->address  }}</span></p>
                            </div>
                            <div class="button-show">

                                @if ($item->status == 1 || $item->status == 2)
                                    <a href="{{route('pickup-show', ['id' => $item->id])}}"><button>Show</button></a>
                                    <button class="btn-done"   data-id="{{$item->id}}" style="background: #2aa638">Done </button>
                                @endif
                                <a href="{{route('pickup.show', ['id' => $item->id])}}"><button>Print</button></a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
<script>
    $(document).on('click', '.btn-done',function(){

         var id =$(this).data().id;
         $.confirm({
            title: 'Confirm!',
            content: 'Simple confirm!',
            buttons: {
                cancel: function () {

                },
                confirm: function () {
                       $.ajax({
                        type: 'POST',
                        url: '{{ route("pickup_done") }}',
                        dataType:'text',
                        data: {
                            _token: '{{ csrf_token() }}',
                            id: id,

                        },
                        success: function (data) {
                            location.reload();
                        }
                    });
                },

            }
        });
    });
</script>
@endsection
