@extends('layouts.app-mobile')

@section('content')
    <?php Fun::lang(); ?>
    <style>
        .mobile-button .btn-edit {
            background: #66d6f4;
            padding: 4px;
            border-radius: 2px;
        }

        .mobile-text .texted-right {
            width: 49%;
            float: left;
            /* margin-top: -24px; */
        }

        .mobile-button {
            width: 100%;
            float: left;
            margin-left: 12%;
        }

    </style>

    <div class="container">
        <div class="shipping-area shipping-detail">
            @foreach ($data->cursor() as $key=>$item)
                <div class="col-md-6  col-sm-6 padd-0">
                    <div class="mobile-detail" style="position: relative;">
                        <b
                            style="position: absolute;top: 10px;right: 10px;width:30px;height: 30px;border-radius: 50%;border: 1px solid #2516d7;float: left;text-align: center;line-height: 2em;">{{$key+1}}</b>
                        <div class="mobile-text">
                            <div class="texted-left">
                                <li>កាលបរិច្ឆេទ : <span>{{$item->date ? date('Y-m-d',strtotime($item->date)) : ''}}</span></li>
                                {{-- <li>កាលបរិច្ឆេទដឹក : <span>{{$item->delivery_date ? date('Y-m-d',strtotime($item->delivery_date)) : ''}}</span></li> --}}
                                <li>ហាង : <span>{{$item->shop_name}}</span></li>
                                <li>លេខទូរស័ព្ទ : <span>{{$item->phone}}</span></li>
                                <li>ទីតាំង: <span>{{$item->address}}</span></li>
                                <li>
                                    សម្គាល់: <span>{{$item->description??"N/A"}}</span>
                                </li>
                            </div>
                            <div class="mobile-button" style="text-align: right !important;margin: 0 !important;">
                                <button class="btn-pending driver-con-pickup" data-route="{{route('confirm-pickup',$item->id)}}">បញ្ចូលកញ្ចប់</button>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

    </div>

    <script type="text/javascript">
        $('.driver-con-pickup').on('click', function() {
            let route = $(this).data('route');
            $.confirm({
                title:"Done Pickup",
                theme: "bootstrap",
                closeIcon:true,
                content: function () {
                    var self = this;
                    return $.ajax({
                        url: route,
                        dataType: 'JSON',
                        method: 'GET'
                    }).done(function (response) {
                        self.setContent(response.view);
                    }).fail(function(){
                        self.setContent('Something went wrong.');
                    });
                },
                buttons: {
                    cancel: {
                        text: 'Cancel',
                        btnClass: 'btn-red',
                        action: function () {
                            
                        }
                    },
                    formSubmit: {
                        text: 'Submit',
                        btnClass: 'btn-blue',
                        action: function () {
                            let jc = this;
                            let qty = jc.$content.find('input[name=qty]').val();
                            if(!qty){
                                $.alert("Please Input Qty.");
                                return false;
                            }
                            if(qty <= 0){
                                $.alert("Qty must be bigger than zero");
                                return false;
                            }
                            $.ajax({
                                type: "POST",
                                url: route,
                                data: {
                                    _token:'{{csrf_token()}}',
                                    qty
                                },
                                dataType: "JSON",
                                success: function (response) {
                                    if(response.success){
                                        location.reload();
                                    }else{
                                        $.alert(response.msg);
                                    }
                                }
                            });
                        }
                    },
                },
            });
           
        });
    </script>
@endsection
