@extends('layouts.app')

@section('content')
<?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('users.index')}}">{{__('administrator.user')}}</a></li>
            <li class="active">{{__('administrator.create_new')}}</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{__('administrator.user')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {!! Form::open(array('route' => 'users.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form">
                        <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.user')}} <i>( {{__('administrator.fields_in_red_are_required')}} )</i></h3>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.full_name')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('name', null, array('placeholder' => __('administrator.full_name'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.sex')}} </label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::select('gender', ['Male'=> __('administrator.male'),'Female'=> __('administrator.female')],null, array('class' => 'form-control select2','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.roles')}} </label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::select('roles[]', $roles,[], array('class' => 'form-control select2','required')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.email_user_name')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::text('email', null, array('placeholder' => __('administrator.email_user_name'),'class' => 'form-control','required','autocomplete'=>'off')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.phone_number')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::text('phone', null, array('placeholder' => __('administrator.phone_number'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.password')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::password('password', array('placeholder' => __('administrator.password'),'class' => 'form-control')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.confirm_password')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::password('confirm_password', array('placeholder' => __('administrator.confirm_password'),'class' => 'form-control')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12">
                                <label >{{__('administrator.profile')}}</label>
                            </div>
                            <div class="form-group col-sm-9">
                                <input id="input-44" type="file" name="image" class="file" data-overwrite-initial="false" >
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>
@endsection
