
@extends('layouts.print')

@section('content')
<style>
    .table {
        width: 100%;
        max-width: 100%;
        margin-bottom: 10px !important;
    }
</style>
<div class="page-purchases">
    <div class="container">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="pull-left mr-bt">

                    <img src="{{asset('images/logo.jpg')}}" alt="" width="200">
                </div>
                <div class="pull-right">
                    <div class="title-add">
                        <h2>Stock Balance Report</h2>
                        <table class="table table-striped">
                            <tr>
                                <td><b class="pull-left">Show Name :</b></td>
                                <td><span class="pull-left"> {{ $shop_name }} </span></td>
                            </tr>
                            <tr>
                                <td><b class="pull-left">Phone Number :</b></td>
                                <td><span class="pull-left"> {{$phone}}</span></td>
                            </tr>
                            <tr>
                                <td><b class="pull-left">Date  :</b></td>
                                <td><span class="pull-left"> {{ date('d-m-Y') }} </span></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="summary-header">

        <div class="wrapper-table">
                    <table width="100%" class="table table-striped">
                        <thead>
                        <tr>
                            <th>{{__('administrator.no')}}</th>
                            <th>{{__('administrator.product_code')}}</th>
                            <th>{{__('administrator.product_name')}}</th>

                            <th>{{__('administrator.category')}}</th>
                            <th>{{__('administrator.balance_stock')}}</th>


                        </tr>
                        </thead>
                            <tbody style="text-align: center;">
                                @foreach ($data as $key=>$val)
                                <tr align="center">
                                    <td>{{  $key+1}}</td>
                                    <td>{{ $val->product_code }}</td>
                                    <td>{{ $val->product_name }}</td>
                                    <td>{{ $val->category_name }}</td>
                                    <td>{{ $val->stock_qty   }}</td>


                                </tr>
                            @endforeach

                            </tr>
                        </tbody>


                    </tfoot>
                    </table>
                </div>


    </div>
</div>


@endsection

