@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
 <script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
 <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
 <style>
   thead input {
        width: 100%;
    }
    input[type=text]{
        color: black;
    }
    .buttons-html5{background: coral !important;}
    div.dt-button-collection{
        width: 60px !important;
        padding: 1px 1px 1px 1px !important;
        box-shadow: none !important;

    }
    .dt-button{
        color: black !important;
    }
 </style>


<div class="top-header">
<ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li class="active">{{__('administrator.report_delivery')}}</li>
</ol>
</div>
<div class="page">
<div class=container-fluid>
<div class="top-content">
    <div class="row">
        <div class="col-sm-12">
            <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                @csrf

            <div class="form-search">
                @if(\Globals::is_Administrator() == 'Administrator')
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::select('merchant', $merchant, null, ['class' => 'form-control merchant']) !!}
                </div>
                @endif
                <div class="form-group col-sm-3 col-xs-3">
                    <select name="status[]" id="" multiple="multiple" class="form-control chosen-select">
                        <option value="">   {{__('administrator.please_select')}}  {{__('administrator.no')}} </option>
                        <option value="1">   {{__('administrator.processing')}} </option>
                        <option value="2">   {{__('administrator.padding')}} </option>
                        <option value="3">  {{__('administrator.done')}} </option>
                        <option value="4">  {{__('administrator.cancel')}} </option>
                    </select>
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                </div>

                <div class="col-sm-12 col-xs-12">
                    <div class="form-group footer-save">
                        <button class="button_sm button_success pull-right  " id="print-all" type="button"><span class="fa fa-print"></span >  </button>
                        <button class="button_sm button_info pull-right  " id="search" type="button"><span class="fa fa-search"></span> {{__('administrator.searching')}}  </button>
                    </div>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>

<div class="wrapper-table ">
    <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
        <thead>
            <tr>​
                <th>ល.រ</th>
                <th>ថ្ងែដឹក</th>
                <th>ហាង</th>
                <th>ប្រតិបត្តិការ</th>
                <th>ប្រាក់ទទួល</th>
                <th>ប្រាក់ទូទាត់</th>
                <th>តម្លៃសេវាដឹកសរុប</th>
                <th>សេវាអ្នកដឹក</th>
                <th>សេវាសរុបចុងក្រោយ</th>
                <th>សកម្មភាព</th>
            </tr>
        </thead>
        <tbody class="tbody">
        </tbody>
    </table>
</div>
</div>
@endsection
@section('script')
<script type="text/javascript">


    $('#print-all').on('click', function(e) {
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();

        $.ajax({
            url: "{{route('summary-delivery-list-all')}}",
            type: 'POST',
            dataType: 'html',
            data: {
                from_date:from_date,
                to_date:to_date,
                merchant:merchant,
                status:status,
                _token: '{{ csrf_token() }}',
            },
            success: function (data) {
                var content_ = (data);
                $.confirm({
                    title: '',
                    content: content_,
                    boxWidth: '70%',
                    useBootstrap: false,
                    buttons: {
                        close: {
                            text: '<i class="fa fa-times" aria-hidden="true"></i>',
                            btnClass: 'btn-danger',
                            keys: ['esc'],
                            action: function () {

                            }
                        },
                        print: {
                            text: '<i class="fa fa-print" aria-hidden="true"></i>',
                            btnClass: 'btn-info',
                            keys: ['enter'],
                            action: function () {
                                $('.container-prints').printThis({
                                    loadCSS: "{{asset('assets/print_this/pos-invoice.css')}}",
                                    afterPrint: function () {

                                    }
                                });
                            }
                        },
                        'excel': {
                            text: '<i class="fa fa-file-excel-o" aria-hidden="true"></i>',
                            btnClass: 'btn-primary',
                            action: function () {
                                exportTableToExcel('tblData', 'Report Summary');
                            }
                        },
                    }
                });
                $('.loading_btn').hide();
                $('input[type=submit]').show();
                $('button[type=submit]').show();
            }
        });


    });


    $(document).on('click','.bt-print',function(){
        var href = $(this).data('href');
        $.ajax({
            url: href,
            success: function (data) {
                var content_ = (data);
                $.confirm({
                    title: '',
                    content: content_,
                    boxWidth: '70%',
                    useBootstrap: false,
                    buttons: {
                        close: {
                            text: '{{__('administrator.close')}}',
                            btnClass: 'button_warning',
                            keys: ['esc'],
                            action: function () {

                            }
                        },
                        print: {
                            text: '{{__('administrator.print')}}',
                            btnClass: 'button_info',
                            keys: ['enter'],
                            action: function () {
                                $('.container-prints').printThis({
                                    loadCSS: "{{asset('assets/print_this/pos-invoice.css')}}",
                                    afterPrint: function () {

                                    }
                                });
                            }
                        },
                    }
                });
                $('.loading_btn').hide();
                $('input[type=submit]').show();
                $('button[type=submit]').show();
            }
        });
    });


    $(document).ready(function(){
        dataTableAjax();
    });

    $(document).on('click', '#search', function(){
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();

        $('#datatable_income').DataTable().destroy();
        dataTableAjax(from_date, to_date, merchant,status);
    });

    function dataTableAjax(from_date= '', to_date= '', merchant= '',status=''){
    var table  = $('#datatable_income').DataTable({
    "oLanguage": {
        "sSearch": "{{__('administrator.search')}}:",
        "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
        "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
        "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
        "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
        "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
        "oPaginate": {
            "sFirst": "{{__('administrator.first')}}",
            "sLast": "{{__('administrator.last')}}",
            "sNext": "{{__('administrator.next')}}",
            "sPrevious": "{{__('administrator.prevoius')}}"
        },
    },
    ordering: false,
    serverSide: true,
    lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
    ajax:{
        url: "{{ route('summary-delivery-list') }}",
        data:{
            from_date:from_date,
            to_date:to_date,
            merchant:merchant,
            status:status
        }
    },

    dom: 'Bfrtip',
    buttons: [
        {
            extend: 'pageLength',
            text: 'show', // Label
            className: 'buttons-html5',
        },
        {
            extend: 'excelHtml5',
            title: 'Report Delivery',
            autoFilter: true,
            sheetName: 'Exported data',
            customize: function ( xlsx ){
                var sheet = xlsx.xl.worksheets['sheet1.xml'];
                $('row c[r*="2"]', sheet).attr( 's', '25' );
                $('row c[r^="C"]', sheet).each( function () {
                    // Get the value
                });
            }
        },
        {
            extend: 'copyHtml5',
            title: 'Report Delivery'
        },
    ],
    columns:
        [
            {data: 'DT_RowIndex'},
            {data: 'date'},
            {data: 'merchant'},
            {data: 'transaction'},
            {data: 'received'},
            {data: 'payment'},
            {data: 'Services'},
            {data: 'commission_driver'},
            {data: 'total'},
            {data: 'action'},
        ],
        orderCellsTop: true,
        fixedHeader: true,

    } );
}


</script>
@stop



