<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sammaki Delivery</title>
    <meta property="og:type" content="website" />
    <meta property="og:title" content="2U Delivery" />
    <meta property="og:image" content="{{ asset('images/logo.png') }}" />
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('images/logo.png') }}">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">

    <link rel="stylesheet" href="{{ asset('assets/font-awesome-4.7.0/css/font-awesome.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/AdminLTE/AdminLTE.min.css') }}">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

    <script src="{{asset('assets/js/jquery3.4.1.min.js')}}"></script>
    <link rel="stylesheet" href="{{asset('assets/jquery-confirm/css/jquery-confirm.min.css')}}">
        
</head>

<body>

    <style type="text/css">
        body,
        #main-container {
            height: auto;
        }
        
        .table-bordered>thead>tr>th,
        .table-bordered>tbody>tr>th,
        .table-bordered>tfoot>tr>th,
        .table-bordered>thead>tr>td,
        .table-bordered>tbody>tr>td,
        .table-bordered>tfoot>tr>td {
            border: 1px solid gray !important;
            text-align: center; 
                       
        }
        .table-bordered>thead>tr>th{
            vertical-align: middle;
        }
        .table-striped{
            font-size: 16px !important;
        }
        .table-bordered{
            border: none !important;
                       
        }
    </style>


    <div class="wrapper" id="main-container">
        <!-- Main content -->
        <section class="invoice">
            <!-- title row -->
            <div class="row">
                <div class="col-xs-12">
                    <h2 class="page-header">
                        <img src="{{ asset('images/logo.jpg') }}" width="70px;" height="70px;">Sammaki Delivery
                        <small class="pull-right bt-date"  > Date: {{ date("m-d-Y") }} </small>
                    </h2>
                </div>
            </div>
        
            <div class="row">
                <div class="col-xs-12 table-responsive">
                 
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th rowspan="2">ល.រ</th>
                                <th rowspan="2">គោលដៅផ្ញើរ</th>
                                {{-- <th> Type</th> --}}
                                <th rowspan="2" > កាលបរិច្ឆេតទទួលអីវ៉ាន់</th>
                                <th rowspan="2" > លេខទូរសព្ទអ្នកទិញ</th>
                                <th rowspan="2" > កាលបរិច្ឆេតបញ្ជេញអីវ៉ាន់</th>
                                
                                <th colspan="2"> តម្លៃទំនិញ</th>
                               
                                <th colspan="2">ប្រាក់ទទួលបានពីភ្ញៀវ</th>
                                <th rowspan="2" >ថ្លៃផ្ញើរទៅខេត្ត</th> 
                                <th rowspan="2" > ថ្លៃសេវាដឹកទូទាត់ពីហាង</th>
                                <th rowspan="2" > សរុបប្រាក់ត្រូវទូទាត់ពីម្ចាស់ហាង</th>
                                <th rowspan="2"> សម្គាល់</th>
                            </tr>
                            <tr>
                                <th rowspan="2" > ដុល្លា</th>
                                <th rowspan="2" > រៀល</th>
                                <th rowspan="2" > ដុល្លា</th>
                                <th rowspan="2" > រៀល</th>
                                {{-- <th rowspan="2" > (ABA) To Shop</th> --}}
                                {{-- <th > (ABA) To Shop</th> --}}

                            </tr>
                        </thead>
                        <?php 
                            $total_all_service = 0;
                            $total_receive_dollar = 0;
                            $total_receive_riel = 0;
                        ?>
                        <tbody>
                            
                            @foreach ($data as $key=>$val)

                                <?php
                                    $delivery_fee = 0;   
                                    $total = 0;
                                    $service_delivery_fee = 0;
                                    $service_taxi_fee = 0;
                                    $color = "";
                                    if($val->total_riel <= 0 && $val->total_dollar <= 0){
                                        $color = "red";
                                    }
                                    $total_receive_dollar += $val->total_dollar;
                                    $total_receive_riel += $val->total_riel;
                                ?>
                                
                                <tr>
                                    <td style="color:{{$color}}">
                                        {{$key+1}}
                                    </td>
                                    <td style="color:{{$color}}">
                                        {{$val->location_name}}
                                    </td>
                                    <td style="color:{{$color}}">
                                        {{$val->created_at}}
                                    </td>
                                    <td style="color:{{$color}}">
                                        {{$val->customer_receive}}
                                    </td>
                                    <td style="color:{{$color}}">
                                        {{$val->delivery_date}}
                                    </td>
                                    <td style="color:{{$color}}">
                                        {{$val->total_price}}
                                    </td>
                                    <td style="color:{{$color}}">
                                        
                                    </td>
                                    <td style="color:{{$color}}">
                                        {{$val->total_dollar}}
                                        
                                    </td>
                                    <td style="color:{{$color}}">
                                        {{$val->total_riel}}
                                    </td>
                                    {{-- <td style="color:{{$color}}">
                                        {{$val->amount_pay_to}}
                                    </td> --}}
                                    <td style="color:{{$color}}">
                                        <?php 
                                           if($val->taxi_status == 1){
                                                $taxi_fee = '$'.number_format( $val->taxi_shop_fee,2) .' s';
                                                $service_delivery_fee = $val->taxi_shop_fee;
                                                $total_all_service += $val->taxi_shop_fee;
                                            }
                                            else{
                                                $taxi_fee = '$'.number_format( $val->taxi_cust_fee,2) . ' c';
                                            }
                                            echo $taxi_fee;
                                        ?>
                                        
                                        
                                    </td>
                                    <td style="color:{{$color}}">
                                        <?php 
                                            if($val->discount_type != null || $val->discount_type != ''){
                                                    if($val->discount_type == 1){
                                                        $delivery_fee = $val->discount;
                                                    }elseif($val->discount_type == 2){
                                                        $delivery_fee = ( (100 - $val->discount) * $val->delivery_fee ) / 100;
                                                    }else{
                                                        $delivery_fee = $val->delivery_fee;
                                                    }
                                                
                                            }else{
                                                    $delivery_fee  =  $val->delivery_fee;

                                                }
                                                
                                                if ($val->delivery_status == 1) {
                                                    $service_taxi_fee = $delivery_fee;
                                                    $total_all_service += $val->delivery_fee;
                                                    echo '$' . number_format($delivery_fee, 2) .' s';
                                                }else {
                                                    echo '$' . number_format($delivery_fee, 2) .' c';
                                                }
                                        
                                        ?>
                                    </td>
                                    <td style="color:{{$color}}">
                                        {{"$ ".number_format($service_delivery_fee + $service_taxi_fee,2)}}
                                    </td>
                                    <td style="color:{{$color}}">
                                        {{$val->description}}
                                    </td>
                                    
                                </tr> 
                            @endforeach
                            
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="10" style="border: none !important"><b>ទូទាត់តាម ABA </b>: Tan Srey Leak,001322597(USD)</td>
                                <td> សរុបថ្លៃសេវា​ ដឹកនិងផ្ញើឡាន</td>
                                <td colspan="2">{{'$ '.number_format($total_all_service,2)}}</td>
                            </tr>
                            <tr>
                                <td colspan="10" style="border: none !important"></td>
                                <td> ប្រាក់ទទួលជា (រៀល)</td>
                                <td colspan="2">{{$total_receive_riel.' ៛'}}</td>
                            </tr>
                            <tr>
                                <td colspan="10" style="border: none !important"></td>
                                <td> ប្រាក់ទទួលជា (ដុល្លា)</td>
                                <td colspan="2">{{'$ '.number_format($total_receive_dollar,2)}}</td>
                            </tr>
                            <tr>
                                <td  colspan="10" style="border: none !important"></td>
                                <td rowspan="2" style="vertical-align: middle"> ប្រាក់ត្រូវទូទាត់សរុប(ដុល្លា&រៀល)</td>
                                <td colspan="2">
                                    

                                    <?php 
                                        $substrack_total_receice_riel = (($total_receive_riel / 4000) - $total_all_service) * 4000;
                                        if($substrack_total_receice_riel <= 0){
                                            $total_receive_dollar += ($substrack_total_receice_riel / 4000);
                                        }
                                    ?>
                                    {{'$ '.number_format($total_receive_dollar,2) }}
                                </td>
                            </tr>
                            <tr>
                                <td  colspan="10" style="border: none !important"></td>
                                {{-- <td> ប្រាក់ទទួលជា (ដុល្លា)</td> --}}
                                <td colspan="2">
                                    {{$substrack_total_receice_riel <= 0 ? 0 .'៛' : $substrack_total_receice_riel.'៛'}}
                                    {{-- {{(($total_receive_riel / 4000) - $total_all_service) * 4000 <= 0 ? 0 .' ៛' : (($total_receive_riel / 4000) - $total_all_service) .' ៛'}} --}}
                                </td>
                            </tr>
                            <tr>
                                <td colspan="10" style="border: none !important"></td>
                                <td> ប្រាក់ត្រូវទូទាត់សរុប (ដុល្លា)</td>
                                <td colspan="2">
                                    <?php 
                                        $test = $substrack_total_receice_riel > 0 ? $substrack_total_receice_riel / 4000 : 0;

                                    ?>
                                    {{'$ '.number_format($total_receive_dollar + $test,2)}}
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </section>
    </div>
</body>

</html>
    <link rel="stylesheet" type="text/css" href="{{asset('js/datepicker/datepicker.min.css')}}">
    <script src="{{asset('js/datepicker/datepicker.min.js')}}"></script>
    <script src="{{asset('assets/js/barcode/barcode.js')}}"></script>
    <script src="{{asset('assets/js/bootstrap.min.js')}}"></script>
    <script src="{{asset('assets/mobile/js/jquery-confirm.js')}}"></script>
    <script>

        
    </script>


    </body>

</html>

