@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
 <script src="{{asset('assets/print_this/printThis.js')}}"></script>
 <script src="{{asset('assets/report/jquery.dataTables.min.js')}}"></script>
 <script src="{{asset('assets/report/jquery-3.5.1.js')}}"></script>

 <style>
   thead input {
        width: 100%;
    }
    input[type=text]{
        color: black;
    }
    .buttons-html5{background: coral !important;}
    div.dt-button-collection{
        width: 60px !important;
        padding: 1px 1px 1px 1px !important;
        box-shadow: none !important;

    }
    .dt-button{
        color: black !important;
    }

    .redClass  td {
        background: #c8ddc8;
    }
 </style>


<div class="top-header">
<ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li class="active">{{__('administrator.report_delivery')}}</li>
</ol>
</div>
<div class="page">
<div class=container-fluid>

<div class="wrapper-table ">
    <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
        <thead>
            <tr>
                <th>{{__('administrator.no')}}</th>
                <th>{{__('administrator.date')}}</th> 
                <th>{{__('administrator.shop_name')}}</th>
                <th>{{__('administrator.phone')}}</th>
                <th>Qty Box</th> 
                <th>{{__('administrator.action')}}</th> 
            </tr>
        </thead>
        <tbody class="tbody">
        </tbody>
    </table>
</div>
</div>
@endsection
@section('script')
<script type="text/javascript">      
    $(document).ready(function(){
        dataTableAjax();
    });
    
    function dataTableAjax(from_date= "{{date(' Y-m-d')}}", to_date= "{{date(' Y-m-d')}}", merchant= '',status='',filter_date = 1){
        var table  = $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[50, 200, 500, 1000,-1], [50, 200, 500, 1000,'All']],
        ajax:{
            url: "{{ route('report-for-shop.index') }}",
            data:{
                from_date:from_date,
                to_date:to_date,
                merchant:merchant,
                status:status,
            }
        }, 
        buttons: [
            {
                extend: 'pageLength',
                text: 'show', // Label
                className: 'buttons-html5',
            },
            {
                extend: 'excelHtml5',
                title: 'Report Delivery',
                autoFilter: true,
                sheetName: 'Exported data',
                customize: function ( xlsx ){
                    var sheet = xlsx.xl.worksheets['sheet1.xml'];
                    $('row c[r*="2"]', sheet).attr( 's', '25' );
                    $('row c[r^="C"]', sheet).each( function () {
                        // Get the value

                    });
                }
            },
        ],
        columns:
            [
                {data: 'DT_RowIndex'                , 'searchable': false},
                {data: 'date_'                , 'searchable': false},
                {data: 'shop_name' ,name: 'nso007_export_stock.shop_name'  , 'searchable': true},
                {data: 'phone' ,  name: 'nso007_export_stock.phone'  , 'searchable': false},
                {data: 'status' , 'searchable': false},
                {data: 'action' , 'searchable': false},
                
            ],
            orderCellsTop: true,
            fixedHeader: true,


            "createdRow": function( row, data, dataIndex){

                if( data.success >= 1){
                    $(row).addClass('redClass');
                }
            }
        } );

    $(document).find('.dataTables_filter').prepend(`
    
                                                <label style="border: solid #ffe4e4 2px;"> 
                                                    <space class="text-primary">Processing</space>&nbsp; ,
                                                    <space class="text-success">Success</space>&nbsp;,
                                                    <space class="text-warning"> Pending</space>&nbsp;,
                                                    <space class="text-danger">Cancel</space>&nbsp;
                                                </label>&nbsp;&nbsp; `);

    }

    $(document).on('change','.staff_id',function(){
        var id =$(this).val();
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var staff = $(this);
        $.ajax({
                type: 'POST',
                dataType: "json",
                url: "{{route('get_merchant_in_report_delivery')}}",
                data: {
                    "id": id,
                    "from_date": from_date,
                    "to_date": to_date,
                    "_token": '{{csrf_token()}}',
                },
                success: function (data) {
                  staff.closest('form').find('.merchant').html(data);

                }
        });

    });


</script>
@stop



