@extends('layouts.app')
@section('content')
<?php Fun::lang()?>


 <script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>

 <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>

 <style>
    thead input {
        width: 100%;
    }
    input[type=text]{
        color: black;
    }
    .buttons-html5{background: coral !important;}
    div.dt-button-collection{
        width: 60px !important;
        padding: 1px 1px 1px 1px !important;
        box-shadow: none !important;

    }
    .dt-button{
        color: black !important;
    }
 </style>


<div class="top-header">
<ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li class="active">{{__('administrator.report_delivery')}}</li>
</ol>
</div>
<div class="page">
<div class=container-fluid>
<div class="top-content">
    <div class="row">
        <div class="col-sm-12">
            <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                @csrf

            <div class="form-search">
                @if(\Globals::is_Administrator() == 'Administrator')
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::select('merchant', $merchant, null, ['class' => 'form-control merchant']) !!}
                </div>
                @endif
                <div class="form-group col-sm-3 col-xs-3">
                    <select name="status[]" id="" multiple="multiple" class="form-control chosen-select">
                        <option value="">   {{__('administrator.please_select')}}  {{__('administrator.no')}} </option>
                        <option value="1">   {{__('administrator.processing')}} </option>
                        <option value="2">   {{__('administrator.padding')}} </option>
                        <option value="3">  {{__('administrator.done')}} </option>
                        <option value="4">  {{__('administrator.cancel')}} </option>
                    </select>
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                </div>

                <div class="col-sm-12 col-xs-12">
                    <div class="form-group footer-save">
                        <button class="button_sm button_info pull-right  " id="search" type="button"><span class="fa fa-search"></span> {{__('administrator.searching')}} </button>
                        <button type="button" class="button_sm button_info pull-right buttons-print bt_print"><span class="fa fa-print"></span>   {{__('administrator.print')}}</button>
                    </div>
                </div>
            </div>
            </form> 
        </div>
    </div>
</div>

<div class="wrapper-table ">
    <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
        <thead>
            <tr>
                <th>{{__('administrator.no')}}</th>
                <th>{{__('administrator.date')}}</th>
                <th>{{__('administrator.shop_name')}}</th>
                <th>{{__('administrator.driver')}}</th>
                <th>{{__('administrator.box_code')}}</th>
                <th>{{__('administrator.location')}}</th>
                <th>{{__('administrator.customer_receive')}}</th>
                <th>{{__('administrator.price')}}</th>
                <th>{{__('administrator.price_of_car')}}</th>
                <th>{{__('administrator.price_of_service')}}</th>
                <th>{{__('administrator.extra_fee')}}</th>
                <th>{{__('administrator.total')}}</th>
                <th>{{__('administrator.reason')}}</th>
                <th>{{__('administrator.status')}}</th>
                <th></th>
            </tr>
        </thead> 
        <tbody class="tbody"> 
        </tbody>
    </table>
</div>
</div> 
@endsection 
@section('script')
<script type="text/javascript">

$(document).on('change','.merchant',function(){
        if($(this).val() != ''){
            $('.bt_print_with_invoice').show();
        }
    });

    $(document).on('click','.bt_print',function(){
        $( ".submit" ).submit();
        $('.submit').attr('action', '{{ route("report_for_fee_paid") }}').submit();
    });

   

    $(document).ready(function(){
        dataTableAjax(); 
    });

    $(document).on('click', '#search', function(){ 
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();


        $('#datatable_income').DataTable().destroy();
        dataTableAjax(from_date, to_date, merchant,status); 
    });



    function dataTableAjax(from_date= '', to_date= '', merchant= '',status=''){
    var table  = $('#datatable_income').DataTable({
    "oLanguage": {
        "sSearch": "{{__('administrator.search')}}:",
        "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
        "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
        "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
        "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
        "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
        "oPaginate": {
            "sFirst": "{{__('administrator.first')}}",
            "sLast": "{{__('administrator.last')}}",
            "sNext": "{{__('administrator.next')}}",
            "sPrevious": "{{__('administrator.prevoius')}}"
        },
    },
    ordering: false,
    serverSide: true,
    lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']], 
    ajax:{
        url: "{{ route('datable_deliver_paid') }}", 
        data:{                       
            from_date:from_date, 
            to_date:to_date, 
            merchant:merchant,
            status:status
        }
    },
    columns:
        [
            {data: 'DT_RowIndex'},
            {data: 'delivery_date'},
            {data: 'shop_name'},
            {data: 'driver_name'},
            {data: 'box_code'},
            {data: 'name_location'},
            {data: 'customer_receive'},
            {data: 'total_price'},
            {data: 'taxi_fee'},
            {data: 'delivery_fee'},
            {data: 'extra_fee'},
            {data: 'total'},
            {data: 'reason'},
            {data: 'status'},
            {data: 'status_paid'},
        ],
        orderCellsTop: true,
        fixedHeader: true,


    } );
}

     
</script>
@stop



