@extends('layouts.app')

@section('content')
<?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('users.index')}}">{{__('administrator.products')}}</a></li>
            <li class="active">{{__('administrator.create_product')}}</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{__('administrator.create_product')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {!! Form::open(array('route' => 'product.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
            @csrf
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form">
                        <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.create_product')}} <i>( {{__('administrator.fields_in_red_are_required')}} )</i></h3>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.category')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::select('category_id', $categories, null, ['class' => 'form-control chosen-select','id'=>'categories','required']) !!}
                            </div>
                        </div>

                        ​<div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.name_en')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('name_en', null, array('placeholder' =>  __('administrator.name_en'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.name_km')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('name_km', null, array('placeholder' =>  __('administrator.name_km'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.price')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('price', null, array('placeholder' =>  __('administrator.price'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.generate_barcode')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('barcode', null, array('placeholder' =>  __('administrator.generate_barcode'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.shop_name')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::select('shop_id[]', $shop,null, array('class' => 'select2','required','multiple','style'=>'width:100%')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12">
                                <label >{{__('administrator.image')}}</label>

                            </div>
                            <div class="form-group col-sm-9">
                                <input id="input-44" type="file" name="image" class="file" data-overwrite-initial="false" >
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>
@endsection
