@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<style>
    .buttons-html5{background: coral !important;}
    div.dt-button-collection{
            width: 80px;
    }
    div.dt-button-collection span{
            color:black;
    }
    div.dt-button-collection {
        width: 182px;

    }
    .select2-container.select2-container--default.select2-container--open {
        z-index: 99999999;
    }




    .dropbtn {
  background-color: #3498DB;
  color: white;
  padding: 16px;
  font-size: 16px;
  border: none;
  cursor: pointer;
}

.dropbtn:hover, .dropbtn:focus {
  background-color: #2980B9;
}

.dropdown {
  position: relative;
  display: inline-block;
}

.dropdown-content {
  display: none;
  position: absolute;
  background-color: #f1f1f1;
  min-width: 160px;
  overflow: auto;
  box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);
  z-index: 1;
}

.dropdown-content a {
  color: black;
  padding: 12px 16px;
  text-decoration: none;
  display: block;
}

.dropdown a:hover {background-color: #ddd;}

.show {display: block;}
.card-header{
    height: auto !important;
    padding: 0px !important;
    background: #f1f1f1 !important;
}
.offset-sm-1{
    margin: 10px;
}
.dataTables_wrapper{
    margin-bottom: 70px !important;
}
</style>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.order')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                
                
                <div id="accordion">
                    
                              
                         
                    </div>
                </div>
                
                <div class="wrapper center-block">
                    <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                        <div class="panel panel-default">
                        <div class="panel-heading active" role="tab" id="headingOne">
                            <h4 class="panel-title">
                            <a role="button" onclick="" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    Filtering
                            </a>
                            <a style="float: right" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    <i class="fa fa-arrow-down"></i>
                            </a>
                            </h4>
                        </div>
                        <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
                            <div class="panel-body" style="padding: 0 !important;border: none !important;">
                                
                                <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                                    @csrf
                                    <div class="form-search" style="margin: 0 !important">
                                    <div class="form-group col-sm-2 col-xs-3">
                                        <label for="">{{__('administrator.shop_name')}}</label>
                                        {!! Form::select('merchant', $merchant_show, null, ['class' => 'form-control merchant']) !!}
                                    </div>
                                    <div class="form-group col-sm-2 col-xs-3">
                                        <label for="">{{__('administrator.driver')}}</label>
                                        {!! Form::select('driver_id', compressDriver(), null, ['class' => 'form-control','placeholder'=>__('administrator.please_select')]) !!}
                                    </div>
                                    <div class="form-group col-sm-2 col-xs-3">
                                        <label for="">From Date</label>
                                        {!! Form::text('from_date', date("d-m-Y",strtotime("-1 week")), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                                    </div>
                                    <div class="form-group col-sm-2 col-xs-3">
                                        <label for="">To Date</label>
                                        {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                                    </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        </div>
                   
                  </div>
                  </div>
            </div>
        </div>
    </div>

	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> {{__('administrator.transection_list')}}</h3>
	                </div>
	                <div class="pull-right">
                        
                </div>
	            </div>
	        </div>
	    </div>
    </div>
    
    <div class="table-responsive" style="float: left;">
        <table id="datatable_show" width="100%" class="table table-striped hover">
            <thead>
            <tr>
                <th width="2%">{{__('administrator.no')}}</th>
                <th style="width: 8%">{{__('administrator.date')}}</th>
                <th style="width: 5%">{{__('administrator.shop_name')}}</th>
                <th style="width: 5%">{{__('administrator.qty')}}</th>
                <th style="width: 5%">{{__('administrator.exact_qty')}}</th>
                <th style="width: 5%">{{__('administrator.description')}}</th>
                <th style="width: 5%">{{__('administrator.reason')}}</th>
                <th style="width: 5%">{{__('administrator.driver')}}</th>
                <th style="width: 5%">{{__('administrator.action')}}</th>
            </tr>
            <tbody class="tbody">
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')
<script type="text/javascript">
    $(document).ready(function(){
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();
        var province_or_city = $('select[name="province_or_city[]"]').val();
        var driver_id = $('select[name="driver_id"]').val();
        dataTableAjax(from_date, to_date, merchant,status,province_or_city,driver_id);
        $(document).on('click','.return-pickup',function(){
            let route = $(this).data('route');
            let tableId = $(this).closest('tr').parents('table').attr('id');
            $.confirm({
                title:"Return Pickup",
                theme: "bootstrap",
                closeIcon:true,
                content: function () {
                    var self = this;
                    return $.ajax({
                        url: route,
                        dataType: 'JSON',
                        method: 'GET'
                    }).done(function (response) {
                        self.setContent(response.view);
                    }).fail(function(){
                        self.setContent('Something went wrong.');
                    });
                },
                buttons: {
                    cancel: {
                        text: 'Cancel',
                        btnClass: 'btn-red',
                        action: function () {
                            
                        }
                    },
                    formSubmit: {
                        text: 'Submit',
                        btnClass: 'btn-blue',
                        action: function () {
                            let jc = this;
                            let reason = jc.$content.find('textarea[name=reason]').val();
                            if(!reason){
                                $.alert("Please input your reason.");
                                return false;
                            }
                            $.ajax({
                                type: "POST",
                                url: route,
                                data: {
                                    _token:'{{csrf_token()}}',
                                    reason
                                },
                                dataType: "JSON",
                                success: function (response) {
                                    if(response.success){
                                        $('#'+tableId).DataTable().ajax.reload();
                                    }else{
                                        $.alert(response.msg);
                                    }
                                }
                            });
                        }
                    },
                },
            });
        });
        $(document).on('click','.approve-pickup',function(){
            let route = $(this).data('route');
            let tableId = $(this).closest('tr').parents('table').attr('id');
            $.confirm({
                title:"Approve Pickup",
                theme: "bootstrap",
                closeIcon:true,
                content: function () {
                    var self = this;
                    return $.ajax({
                        url: route,
                        dataType: 'JSON',
                        method: 'GET'
                    }).done(function (response) {
                        self.setContent(response.view);
                    }).fail(function(){
                        self.setContent('Something went wrong.');
                    });
                },
                buttons: {
                    cancel: {
                        text: 'Cancel',
                        btnClass: 'btn-red',
                        action: function () {
                            
                        }
                    },
                    formSubmit: {
                        text: 'Submit',
                        btnClass: 'btn-blue',
                        action: function () {
                            let jc = this;
                            let exact_qty = jc.$content.find('input[name=exact_qty]').val();
                            if(!exact_qty){
                                $.alert("Please input your exact qty.");
                                return false;
                            }
                            $.ajax({
                                type: "POST",
                                url: route,
                                data: {
                                    _token:'{{csrf_token()}}',
                                    exact_qty
                                },
                                dataType: "JSON",
                                success: function (response) {
                                    if(response.success){
                                        $('#'+tableId).DataTable().ajax.reload();
                                    }else{
                                        $.alert(response.msg);
                                    }
                                }
                            });
                        }
                    },
                },
            });
        });
    });

    $(document).on('change', '.merchant,.status,#province_or_city,select[name="status[]"],input[name="from_date"],input[name="to_date"],select[name="driver_id"]', function(){
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();
        var province_or_city = $('select[name="province_or_city[]"]').val();
        var driver_id = $('select[name="driver_id"]').val();
        $('#datatable_show').DataTable().destroy();
        dataTableAjax(from_date, to_date, merchant,status,province_or_city,driver_id);
    });
    $(document).on('click', '#search', function(){
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();
        var province_or_city = $('select[name="province_or_city[]"]').val();
        var driver_id = $('select[name="driver_id"]').val();
        $('#datatable_show').DataTable().destroy();
        dataTableAjax(from_date, to_date, merchant,status,province_or_city,driver_id);
    });
   
    function dataTableAjax(from_date= "", to_date="", merchant= '',status='',pro_or_city='',driver_id=''){
        
        $('#datatable_show').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sSearchPlaceholder": "",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            serverSide: true,
            ajax:{
                url: window.location,
                data:{
                    from_date:from_date,
                    to_date:to_date,
                    merchant:merchant,
                    status:status,
                    pro_or_city:pro_or_city,
                    driver_id:driver_id,
                }
            },
           

            lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
            columns:
                [
                    {data: 'DT_RowIndex'            ,  'searchable': false},
                    {data: 'delivery_date'             ,  'searchable': false},
                    {data: 'shop_name', name:'users.name'},
                    {data: 'qty',  'searchable': false},
                    {data: 'exact_qty',  'searchable': false},
                    {data: 'description' , name:  'nso007_pickup_admin.description' },
                    {data: 'reason' , name:  'nso007_pickup_admin.reason' },
                    {data: 'driver_name', name:  'driver.name'},
                    {data: 'action',  'searchable': false},
                ],
            "initComplete": function (settings, json) {
                
            }
        });
    }
   
   

</script>
@stop



