@extends('layouts.app')
@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.4/jquery.datetimepicker.min.css" />
<?php Fun::lang()?>
<style>
    .buttons-html5{background: coral !important;}
    div.dt-button-collection{
            width: 80px;
    }
    div.dt-button-collection span{
            color:black;
    }
    div.dt-button-collection {
        width: 182px;

    }
    .select2-container.select2-container--default.select2-container--open {
        z-index: 99999999;
    }
    .xdsoft_datetimepicker.xdsoft_noselect.xdsoft_{
        z-index: 11111111111 !important;
    }




    .dropbtn {
  background-color: #3498DB;
  color: white;
  padding: 16px;
  font-size: 16px;
  border: none;
  cursor: pointer;
}

.dropbtn:hover, .dropbtn:focus {
  background-color: #2980B9;
}

.dropdown {
  position: relative;
  display: inline-block;
}

.dropdown-content {
  display: none;
  position: absolute;
  background-color: #f1f1f1;
  min-width: 160px;
  overflow: auto;
  box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);
  z-index: 1;
}

.dropdown-content a {
  color: black;
  padding: 12px 16px;
  text-decoration: none;
  display: block;
}

.dropdown a:hover {background-color: #ddd;}

.show {display: block;}
.card-header{
    height: auto !important;
    padding: 0px !important;
    background: #f1f1f1 !important;
}
.offset-sm-1{
    margin: 10px;
}
.dataTables_wrapper{
    margin-bottom: 70px !important;
}
</style>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.order')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                
                
                <div id="accordion">
                    
                              
                         
                    </div>
                </div>
                
                <div class="wrapper center-block">
                    <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                        <div class="panel panel-default">
                        <div class="panel-heading active" role="tab" id="headingOne">
                            <h4 class="panel-title">
                            <a role="button" onclick="" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    Filtering
                            </a>
                            <a style="float: right" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    <i class="fa fa-arrow-down"></i>
                            </a>
                            </h4>
                        </div>
                        <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
                            <div class="panel-body" style="padding: 0 !important;border: none !important;">
                                
                                <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                                    @csrf
                                    <div class="form-search" style="margin: 0 !important">
                                    <div class="form-group col-sm-2 col-xs-3">
                                        <label for="">{{__('administrator.shop_name')}}</label>
                                        {!! Form::select('merchant', $merchant_show, null, ['class' => 'form-control merchant']) !!}
                                    </div>
                                    <div class="form-group col-sm-2 col-xs-3">
                                        <label for="">{{__('administrator.driver')}}</label>
                                        {!! Form::select('driver_id', compressDriver(), null, ['class' => 'form-control','placeholder'=>__('administrator.please_select')]) !!}
                                    </div>
                                    <div class="form-group col-sm-2 col-xs-3">
                                        <label for="">From Date</label>
                                        {!! Form::text('from_date', date("d-m-Y",strtotime("-1 week")), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                                    </div>
                                    <div class="form-group col-sm-2 col-xs-3">
                                        <label for="">To Date</label>
                                        {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                                    </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        </div>
                   
                  </div>
                  </div>
            </div>
        </div>
    </div>

	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> {{__('administrator.pickup')}}</h3>
	                </div>
	                <div class="pull-right">
                        @can('Create Pickup')
                            <a href="javascript:;" data-tableid="datatable_show" data-title="Create Pickup" data-href="{{route('pickup-admin.create')}}" class="button_sm button_info save-edit-pickup"><span class="fa fa-plus"></span> {{__('administrator.create_new')}}</a>
                        @endcan
                </div>
	            </div>
	        </div>
	    </div>
    </div>
    
    <div class="table-responsive" style="float: left;">
        <table id="datatable_show" width="100%" class="table table-striped hover">
            <thead>
            <tr>
                <th width="2%">{{__('administrator.no')}}</th>
                <th width="1%"><input type="checkbox" name="check" class="checkbox_all"></th>
                <th style="width: 8%">{{__('administrator.create_date')}}</th>
                <th style="width: 8%">{{__('administrator.pickup_date')}}</th>
                <th style="width: 5%">{{__('administrator.shop_name')}}</th>
                <th style="width: 5%">{{__('administrator.quantity')}}</th>
                <th style="width: 5%">{{__('administrator.description')}}</th>
                <th style="width: 5%">{{__('administrator.driver')}}</th>
                <th style="width: 5%">{{__('administrator.action')}}</th>
            </tr>
            <tbody class="tbody">
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.4/build/jquery.datetimepicker.full.min.js"></script>
<script type="text/javascript">
    $('.checkbox_all').on('click', function(e) {
        if ($(this).is(':checked', true)) {
            $(".checkbox").prop('checked', true);
        } else {
            $(".checkbox").prop('checked', false);
        }
    });


    $(document).on('click','.share_link',function () {
        var export_id = [];
        var tbody_1 = '';
        $(".checkbox:checked").each(function() {
            export_id.push($(this).attr('data-export_id'));
        });

        export_id = export_id.join(",");
        var merchant = $('select[name="merchant"]').val();
        $.confirm({
            icon: 'fa fa-check-square-o',
            theme: 'modern',
            closeIcon: true,
            animation: 'scale',
            type: 'blue',
            title: 'Share Link!',
            content: '' +
            '<form action="" class="formName">' +
            '<div class="form-group">' +
            '<label>Note</label>' +
            `<textarea class="form-control note" name="note" rows="4" cols="50"></textarea>`+
            '</div>' +
            '</form>',
            buttons: {
                cancel: function () {

                },
                confirm: {
                    text: 'Confirm',
                    btnClass: 'btn-blue',
                    keys: ['enter', 'shift'],
                    action: function(){
                        var note = this.$content.find('.note').val();
           


                        $.ajax({
                            url: "{{route('share-link.store')}}",
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                export_id: export_id,
                                note: note,
                                merchant: merchant,
                                _token: '{{ csrf_token() }}',
                            },
                            success: function(data) { 
                                if(!data.error){
                                    $.alert({
                                        title: 'Alert!',
                                        content: '' +
                                        '<form action="" class="formName">' +
                                        '<div class="form-group">' +
                                        '<label>Enter something here</label>' +
                                        '<input type="text"  class="link form-control" value="'+ data.link +'" required />' +
                                        '</div>' +
                                        '</form>',
                                        buttons: {
                                            somethingElse: {
                                                text: 'Copy Link',
                                                btnClass: 'btn-blue',
                                                keys: ['enter', 'shift'],
                                                action: function(){
                                                    var textBox = this.$content.find('.link');
                                                    textBox.select();
                                                    document.execCommand("copy");
                                                }
                                            }
                                        }
                                    });
                                }else{
                                    $.dialog({
                                        title: 'Error!',
                                        content: 'please check in box',
                                    });
                                }
                            }
                        });

                    }
                }
            }
          });
    });
    $(document).ready(function(){
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();
        var province_or_city = $('select[name="province_or_city[]"]').val();
        var driver_id = $('select[name="driver_id"]').val();
        dataTableAjax(from_date, to_date, merchant,status,driver_id);
    });

    $(document).on('change', '.merchant,.status,#province_or_city,select[name="status[]"],input[name="from_date"],input[name="to_date"],select[name="driver_id"]', function(){
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();
        var province_or_city = $('select[name="province_or_city[]"]').val();
        var driver_id = $('select[name="driver_id"]').val();
        console.log(province_or_city);

        $('#datatable_show').DataTable().destroy();
        dataTableAjax(from_date, to_date, merchant,status,province_or_city,driver_id);
    });
    $(document).on('click', '#search', function(){
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();
        var province_or_city = $('select[name="province_or_city[]"]').val();
        var driver_id = $('select[name="driver_id"]').val();
        console.log(province_or_city);

        $('#datatable_show').DataTable().destroy();
        dataTableAjax(from_date, to_date, merchant,status,province_or_city,driver_id);
    });
    $(document).on('click','.pro_or_city',function(){

    });
    $(document).on('click','.change-driver',function(){
        let export_id = $(this).data('export_id');
        let driver_id = $(this).data('driver_id');
        let time = $(this).data('time') == undefined ? 1 : $(this).data('time');
        let delivery_date = $(this).data('delivery_date');
        let old_driver_id = driver_id;
        $.confirm({
            title: 'Change Driver!',
            content: '' +
            '<form action="" class="formName">' +
                '<div class="form-group">' +
                    '<label>Select Driver</label>' +
                    `
                        {!! Form::select('driver_id', compressDriver(), null, ['class' => 'form-control chosen-select select2','id'=>'driver_id','required']) !!}
                    ` +
                '</div>' +
                
            '</form>',
            buttons: {
                cancel: function () {
                    //close
                },
                formSubmit: {
                    text: 'Submit',
                    btnClass: 'btn-blue',
                    action: function () {
                        var driver_id = this.$content.find('#driver_id').val();
                        var time_policy = this.$content.find('#time_policy').val();
                        if(!driver_id){
                            $.alert('provide a valid driver_id');
                            return false;
                        }
                        $.ajax({
                            url: "{{route('delivery.change-driver')}}",
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                driver_id: driver_id,
                                delivery_date,delivery_date,
                                export_id,export_id,
                                old_driver_id:old_driver_id,time_policy,
                                _token: '{{ csrf_token() }}',
                            },
                            success: function(response) {
                                if (response.success == true) {
                                    $('#datatable_show').DataTable().ajax.reload();
                                } else {
                                    $.alert({
                                        title: "Error",
                                        content: response.error,
                                        buttons: {
                                            formSubmit: {
                                                text: 'Submit',
                                                btnClass: 'btn-blue',
                                                action: function () {
                                                    $('#datatable_show').DataTable().ajax.reload();
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                },
            },
            onContentReady: function () {
                // bind to events
                var jc = this;
                    jc.$content.find('.select2').select2({
                        dropdownParent:$('.jconfirm')
                    });
                let change_driver = driver_id+'||'+time;
                this.$content.find('#driver_id').val(change_driver).trigger('change');
                // this.$content.find('#time_policy').val(time).trigger('change');
                this.$content.find('form').on('submit', function (e) {
                    // if the user submits the form by pressing enter in the field.
                    e.preventDefault();
                    jc.$$formSubmit.trigger('click'); // reference the button and click it
                });
            }
        });
    });
    // {{ date('Y-m-d') }}
    function dataTableAjax(from_date= "", to_date="", merchant= '',status='',pro_or_city='',driver_id=''){
        
        $('#datatable_show').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sSearchPlaceholder": "",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            serverSide: true,
            ajax:{
                url: window.location,
                data:{
                    from_date:from_date,
                    to_date:to_date,
                    merchant:merchant,
                    status:status,
                    pro_or_city:pro_or_city,
                    driver_id:driver_id
                }
            },
           

            lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
            columns:
                [
                    {data: 'DT_RowIndex'            ,  'searchable': false},
                    {data: 'print_all'             ,  'searchable': false},
                    {data: 'date'             ,  'searchable': false},
                    {data: 'delivery_date'             ,  'searchable': false},
                    {data: 'shop_name', name:'users.name'},
                    {data: 'qty',  'searchable': false},
                    {data: 'description' , name:  'nso007_pickup_admin.description' },
                    {data: 'driver_name', name:  'driver.name'},
                    {data: 'action',  'searchable': false},
                ],
            "initComplete": function (settings, json) {
                
            }
        });
        $(".dataTables_filter").prepend("<span class='btn btn-sm btn-primary assign_to_driver' data-delivery_date='{{date("Y-m-d")}}' data-driver_id style='margin-right:20px;'>{{__('administrator.assign_to_driver')}}</span>")
    }
    $(document).on('click','.print-all-box',function(){
        let checked = $('.checkbox');
        let export_id = [];
        $.each(checked, function (i, val) { 
             if($(this).prop('checked')){
                 export_id.push($(this).val());
             }
        });
        if(export_id.length != 0){
            let route = "{{route('print-all-box')}}";
                        $.ajax({
                            url: route,
                            data:{
                                id:export_id
                            },
                            success: function (data) {
                                var content_ = (data);
                                $.confirm({
                                    title: '',
                                    content: content_,
                                    boxWidth: '50%',
                                    useBootstrap: false,
                                    buttons: {
                                        close: {
                                            text: '{{__('administrator.close')}}',
                                            btnClass: 'button_warning',
                                            keys: ['esc'],
                                            action: function () {

                                            }
                                        },
                                        print_with_fee: {
                                            text: '{{__('administrator.print_with_out_fee')}}',
                                            btnClass: 'button_info button_primary',
                                            action: function () {
                                                $('.container1').printThis({
                                                    loadCSS: "{{asset('assets/print_this/pos-invoice.css')}}",
                                                    beforePrint: function () {
                                                        $('.delivery_fee_print').css('display','none');
                                                    },
                                                    afterPrint: function () {
                                                        $('.checkbox_all').prop('checked',false);
                                                        $('#datatable_show').DataTable().ajax.reload(null,false);
                                                    }
                                                });
                                            }
                                        },
                                        print: {
                                            text: '{{__('administrator.print')}}',
                                            btnClass: 'button_info button_info_',
                                            keys: ['enter'],
                                            action: function () {
                                                $('.container1').printThis({
                                                    loadCSS: "{{asset('assets/print_this/pos-invoice.css')}}",
                                                    beforePrint: function () {
                                                        $('.delivery_fee_print').css('display','');
                                                    },
                                                    afterPrint: function () {
                                                        $('.checkbox_all').prop('checked',false);
                                                        $('#datatable_show').DataTable().ajax.reload(null,false);
                                                    }
                                                });
                                            }
                                        },
                                    }
                                });
                                $('.loading_btn').hide();
                                $('input[type=submit]').show();
                                $('button[type=submit]').show();
                            }
                        });
        }
    });
    $(document).on('click','.assign_to_driver',function(){
        let data_pickup = $(this).data('pickup_id');
        let pickup_id = [];
        if(data_pickup){
            pickup_id.push(data_pickup);
        }else{
            $.each($('.checkbox'), function (i, v) { 
                if($(this).prop('checked')){
                    if($(this).data('status') == 0){
                        pickup_id.push($(this).val())
                    }
                }
            });
        }
        console.log(pickup_id);
        if(pickup_id.length){

        }else{
            $.alert('No Data Selected.')
            return;
        }
        $.confirm({
            title: 'Assign Driver!',
            content: '' +
            '<form action="" class="formName">' +
                '<div class="form-group">' +
                    '<label>Select Driver</label>' +
                    `
                        {!! Form::select('driver_id', compressDriver(), null, ['class' => 'form-control chosen-select select2','id'=>'driver_id','required']) !!}
                    ` +
                '</div>' +
                '<div class="form-group">' +
                    '<label class="required">Date</label>' +
                    `
                        {!! Form::text('date', null, ['class' => 'form-control date_picker delivery_date','required','autocomplete'=>'off']) !!}
                    ` +
                '</div>' +
                
            '</form>',
            buttons: {
                cancel: function () {
                    //close
                },
                formSubmit: {
                    text: 'Submit',
                    btnClass: 'btn-blue',
                    action: function () {
                        var driver_id = this.$content.find('#driver_id').val();
                        var delivery_date = this.$content.find('.delivery_date').val();
                        if(!driver_id){
                            $.alert('provide a valid driver_id');
                            return false;
                        }
                        $.ajax({
                            url: "{{route('pickup-assign-driver')}}",
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                driver_id,
                                delivery_date,
                                pickup_id,
                                _token: '{{ csrf_token() }}',
                            },
                            success: function(response) {
                                if (response.success == true) {
                                    $('#datatable_show').DataTable().ajax.reload();
                                } else {
                                    $.alert({
                                        title: "Error",
                                        content: response.error,
                                        buttons: {
                                            formSubmit: {
                                                text: 'Submit',
                                                btnClass: 'btn-blue',
                                                action: function () {
                                                    $('#datatable_show').DataTable().ajax.reload();
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                },
            },
            onContentReady: function () {
                // bind to events
                var jc = this;
                    jc.$content.find('.select2').select2({
                        dropdownParent:$('.jconfirm')
                    });
                jc.$content.find(".date_picker").datepicker({
                    dateFormat: "dd-mm-yy",
                    changeMonth: true,
                    changeYear: true,
                });
                let change_driver = driver_id+'||'+time;
                this.$content.find('#driver_id').val(change_driver).trigger('change');
                // this.$content.find('#time_policy').val(time).trigger('change');
                this.$content.find('form').on('submit', function (e) {
                    // if the user submits the form by pressing enter in the field.
                    e.preventDefault();
                    jc.$$formSubmit.trigger('click'); // reference the button and click it
                });
                
            }
        });
        
    });
    $(document).on('click','.chage_driver',function(){
        let time_policy = $(this).data('time');
        let driver_id = $(this).data('driver_id');
        let delivery_date = $(this).data('delivery_date');
        let pickup_id = $(this).data('id');
        $.confirm({
            title: 'Assign Driver!',
            content: '' +
            '<form action="" class="formName">' +
                '<div class="form-group">' +
                    '<label class="required">Select Driver</label>' +
                    `
                        {!! Form::select('driver_id', compressDriver(), null, ['class' => 'form-control chosen-select select2','id'=>'driver_id','required']) !!}
                    ` +
                '</div>' +
                '<div class="form-group">' +
                    '<label class="required">Date</label>' +
                    `
                        {!! Form::text('date', null, ['class' => 'form-control date_picker delivery_date','required','autocomplete'=>'off']) !!}
                    ` +
                '</div>' +
                
            '</form>',
            buttons: {
                cancel: function () {
                    //close
                },
                formSubmit: {
                    text: 'Submit',
                    btnClass: 'btn-blue',
                    action: function () {
                        var driver_id = this.$content.find('#driver_id').val();
                        var delivery_date = this.$content.find('.delivery_date').val();
                        if(!driver_id){
                            $.alert('provide a valid driver_id');
                            return false;
                        }
                        $.ajax({
                            url: "{{route('change-driver',':id')}}".replace(':id',pickup_id),
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                driver_id,
                                delivery_date,
                                pickup_id,
                                _token: '{{ csrf_token() }}',
                            },
                            success: function(response) {
                                if (response.success == true) {
                                    $('#datatable_show').DataTable().ajax.reload();
                                } else {
                                    $.alert({
                                        title: "Error",
                                        content: response.error,
                                        buttons: {
                                            formSubmit: {
                                                text: 'Submit',
                                                btnClass: 'btn-blue',
                                                action: function () {
                                                    $('#datatable_show').DataTable().ajax.reload();
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                },
            },
            onContentReady: function () {
                // bind to events
                var jc = this;
                    jc.$content.find('.select2').select2({
                        dropdownParent:$('.jconfirm')
                    });
                jc.$content.find(".date_picker").datepicker({
                    dateFormat: "dd-mm-yy",
                    changeMonth: true,
                    changeYear: true,
                });
                let change_driver = driver_id+'||'+time_policy;
                this.$content.find('#driver_id').val(change_driver).trigger('change');
                this.$content.find('.delivery_date').val(delivery_date).trigger('change');
                // this.$content.find('#time_policy').val(time).trigger('change');
                this.$content.find('form').on('submit', function (e) {
                    // if the user submits the form by pressing enter in the field.
                    e.preventDefault();
                    jc.$$formSubmit.trigger('click'); // reference the button and click it
                });
                
            }
        });
    });
    $(document).on('click','.delete-pickup',function(){
        let obj = this;
        var href = $(obj).data('href');
        var this_ = $(obj);
        let table = $(obj).closest('table').attr('id');
        $.confirm({
            icon: 'fa fa-trash',
            theme: 'modern',
            title: 'Delete!',
            closeIcon: true,
            animation: 'scale',
            type: 'red',buttons: {
                cancel: function () {

                },
                confirm: {
                    text: 'Confirm',
                    btnClass: 'btn-red',
                    action: function(){
                        $.ajax({
                            url: href,
                            method:'DELETE',
                            data:{
                                _token:'{{csrf_token()}}',
                            },
                            success: function (response) {
                                if (response.success == true) {
                                    $('#'+table).DataTable().ajax.reload(null,false);  
                                } else {
                                    $.alert({
                                        title: "Error",
                                        content: response.msg,
                                        buttons: {
                                            formSubmit: {
                                                text: 'Submit',
                                                btnClass: 'btn-blue',
                                                action: function () {
                                                
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            }
        });
    });
    $(document).on('click','.save-edit-pickup',function(){
        let obj = this;
        var href = $(obj).data('href');
        var this_ = $(obj);
        let table = $(obj).data('tableid')?$(obj).data('tableid'):$(obj).closest('table').attr('id');
        let title = $(obj).data('title');
        $.confirm({
                title:title,
                theme: "bootstrap",
                closeIcon:true,
                content: function () {
                    var self = this;
                    return $.ajax({
                        url: href,
                        dataType: 'JSON',
                        method: 'GET'
                    }).done(function (response) {
                        self.setContent(response.view);
                    }).fail(function(){
                        self.setContent('Something went wrong.');
                    });
                },
                buttons: {
                    cancel: {
                        text: 'Cancel',
                        btnClass: 'btn-red',
                        action: function () {
                            
                        }
                    },
                    formSubmit: {
                        text: 'Submit',
                        btnClass: 'btn-blue',
                        action: function () {
                            let jc = this;
                            let form = jc.$content.find('.pickupForm');
                            let formData = new FormData(form[0]);
                            $.ajax({
                                type: form.attr('method'),
                                url: form.attr('action'),
                                data: formData,
                                dataType: "JSON",
                                processData: false,
                                contentType: false,
                                cache: false,
                                success: function (response) {
                                    if(response.success){
                                        $('#'+table).DataTable().ajax.reload();
                                    }else{
                                        $.alert(response.msg);
                                    }
                                },error:function(xhr){
                                    alertErrorFormController(xhr);
                                }
                            });

                        }
                    },
                },
                onContentReady: function () {
                    var self = this;
                    self.$content.find('.datetimepicker').datetimepicker({
                        format:'d-m-Y H:i ',
                        hours12:false,
                        dayOfWeekStart: 1,
                        lang: 'en',
                        formatTime: 'g:i a',
                        step: 15,
                        dropdownParent:$('.confirm')
                    });
                    self.$content.find('.select2').select2();
                },
            });
    });
</script>
@stop



