@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
<ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li class="active">{{__('administrator.list_pickup')}}</li>
</ol>
</div>
<div class="page">
<div class=container-fluid>
<div class="top-content">
    <div class="row">
        <div class="col-sm-12">
            <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                @csrf
            <div class="form-search">
                @if(\Globals::is_Administrator() == 'Administrator')
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::select('drivers', $drivers, null, ['class' => 'form-control drivers']) !!}
                </div>
                @endif
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                </div>

                <div class="col-sm-12 col-xs-12">
                    <div class="form-group footer-save">
                        <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search"></span> {{__('administrator.searching')}} </button>
                        <button type="button" class="button_sm button_info pull-right buttons-print bt_print" style="display: none"><span class="fa fa-print"></span>   {{__('administrator.print')}}</button>
                    </div>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>

<div class="wrapper-table ">
    <table id="datatable-list-pickup" width="100%" class="table table-striped table-hover  ">
        <thead>
            <tr>
                <th>{{__('administrator.no')}}</th>
                <th>{{__('administrator.date')}}</th>
                <th>{{__('administrator.shop_name')}}</th>
                <th>{{__('administrator.box_qty')}}</th>
                <th>{{__('administrator.description')}}</th>
                <th>{{__('administrator.driver_name')}}</th>
                <th>{{__('administrator.invoice_pickup')}}</th>
                <th>{{__('administrator.type_of_pickup')}}</th>
            </tr>
        </thead>
        <tbody class="tbody">

        </tbody>
    </table>
</div>
</div>


@endsection



@section('script')
<script type="text/javascript">

    $(document).ready(function(){
        $(document).on('change','.drivers',function(){
            if($(this).val() != ''){
                $('.buttons-print').show();
            }
            else{
                $('.buttons-print').hide();

            }
        });
    });






    $('#datatable-list-pickup').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax: "{{route('list_pickup')}}",
            columns:
                [
                {data: 'DT_RowIndex'},
                {data: 'date' },
                {data: 'shop_name' },
                {data: 'count_' },
                {data: 'description' },
                {data: 'driver_name' },
                {data: 'invoice_pickup' },
                {data: 'status' },
                // {data: 'action' },
                ],

            "initComplete": function (settings, json) {
            }
    });


    function searching()
{
    var from_date = $('input[name="from_date"]').val();
    var to_date = $('input[name="to_date"]').val();
    var drivers = $('.drivers').val();
    var table = '';
    $.ajax({
        url: "{{ Route('search_history_pickup') }}",
        method: "get",
        dataType: "json",
        data: {
            from_date: from_date,
            to_date: to_date,
            drivers: drivers,
            _token: '{{ csrf_token() }}',
        },
        success: function (data) {
          if(data.search){
             $('#datatable-list-pickup tbody').replaceWith(data.search);
          }
        }
    });
}

$(document).on('click','.bt_print',function(){
        $( ".submit" ).submit();
        $('.submit').attr('action', '{{ route("history_pickup_print") }}').submit();
    });

</script>
@stop



