@extends('layouts.app') @section('content')

 <?php Fun::lang() ?>
<div class="top-header">
    <ol class="breadcrumb">
      <li><a href="#">{{__('administrator.dashboard')}}</a></li>
      <li><a href="{{route('import-stock.index')}}">{{__('administrator.import_stock')}}</a></li>
      <li class="active"><a href="#">{{__('administrator.import_stock')}}</a></li>
    </ol>
</div>
<div class=" pull-right">
    <div class="on-off">
        @if(\Globals::is_MerchantIn() == 'MerchantIn')
        <a href="{{route('export-stock.create')}}" class="active on"> {{__('administrator.export_stock')}}</a>
        @elseif (\Globals::is_MerchantOut() == 'MerchantOut')
        <a href="" class="active on"> {{__('administrator.out_stock')}}</a>
        @else
        <a href="{{route('export-stock.create')}}" class="on"> {{__('administrator.export_stock')}}</a>
        <a href="" class="active on"> {{__('administrator.out_stock')}}</a>
        @endif
    </div>
</div>
<div class="page-purchases">
    <div class="preview">
        <div class="col-sm-5 ">
            <div class="col-sm-12 paddin-5">
                <div class="form-group">
                    {!! Form::text('barcode', null, array('placeholder' => __('administrator.search_product_name') ,'class' => ' search_text form-control typeahead', "autocomplete" => "on")) !!}
                    <div id="autocomplete" class="col-sm-12" style="position: absolute; z-index: 99;left: -12px">
                    </div>
                </div>
            </div>
            <div class="product-item-list outstock">
                <div class="item-list box-addtocart">
                    <div class="row" id="tag_container">
                       @include('administrator.out-stock.result-create')
                    </div>

                </div>
            </div>
        </div>
        {!! Form::open(array('route' => 'out-stock.store','method'=>'POST','enctype'=>'multipart/form-data','id'=>'submit_post')) !!}
        <div class="col-sm-7 ">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">


                        @if(\Globals::is_MerchantIn() == 'MerchantOut')
                        {!! Form::select('merchant_id', $merchant, \Auth::user()->id, ['class' => 'form-control chosen-select','disabled']) !!}
                        <input type="hidden" name="merchant_id" value="{{\Auth::user()->id}}">
                        @else
                        {!! Form::select('merchant_id', $merchant, null, ['class' => 'form-control','required']) !!}
                        @endif
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <input type="text" name="export_date" value="<?php echo date("d-m-Y")?>" class="form-control date_picker" required>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        {!! Form::text('currency', $exchang_rate->currency_exchange_to, array('placeholder' => __('administrator.delivery_fee'),'class' => 'form-control currency','required')) !!}
                    </div>
                </div>
            </div>

            <div class="check-bill">
                <div class="row">
                    <div class="blog-payment ">
                        <div class="col-sm-12 ">
                            <div class="button_payment pull-right">
                                <input type="checkbox" id="vehicle3" {{ (@session()->get('back_bage')) == 1 ? 'checked':  '' }}   name="vehicle3" value="Boat">
                                <label for="vehicle3"> Back Page</label>
                                <button type="button" class="button_warning button_lg" onclick="history.back(1)">{{__('administrator.back')}}</button>
                                <button type="button" class="button_danger remove_all button_lg">{{__('administrator.remove')}}</button>
                                <button type="submit" class="button_info button_lg">{{__('administrator.save')}}</button>

                            </div>
                        </div>
                    </div>
                    <div class="check-bill-table">
                        <div class="product-view-table">
                            <div class="tbl-content">
                                <div class="overflow">
                                    <table width="100%" class="table table-striped">
                                        <tbody id="resultbody">

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
    @endsection
    @section('script')
    <script type="text/javascript">


        $(window).on('hashchange', function() {
            if (window.location.hash) {
                var page = window.location.hash.replace('#', '');
                if (page == Number.NaN || page <= 0) {
                    return false;
                }else{
                    getData(page);
                }
            }
        });

        $(document).ready(function(){
            $(document).on('click', '.pagination a',function(event){
                event.preventDefault();
                $('li').removeClass('active');
                $(this).parent('li').addClass('active');
                var myurl = $(this).attr('href');
                var page=$(this).attr('href').split('page=')[1];
                getData(page);
            });
        });

        function getData(page){
            $.ajax({
                url: '?page=' + page,
                type: "get",
                datatype: "html"
            }).done(function(data){
                $("#tag_container").empty().html(data);
                location.hash = page;
            }).fail(function(jqXHR, ajaxOptions, thrownError){
                    alert('No response from server');
            });
        }

        $(function () {
            $('#resultbody').delegate('.btn-remove', 'click', function () {
                $(this).parent().parent().remove();
            });
        });
        $(document).on('click','.remove_all',function(){
            $('#resultbody').empty();
        });

        $(document).on('change', '.from_location',function(){
            var this_ = $(this);
            var id = $(this).val();
            $.ajax({
                type: 'GET',
                url: '{{ route("find-main-location") }}',
                dataType:'json',
                data: {
                    _token: '{{ csrf_token() }}',
                    id: id,
                },
                success: function (data) {
                    this_.closest("tr").find(".location").empty();
                    this_.closest("tr").find(".location").append('<option value="">{{__('administrator.location')}}</option>');
                    $.each(data, function (index, element) {
                        this_.closest("tr").find(".location").append('<option value="' + element.id + '">' + element.name +  '</option>');
                    });
                    this_.closest("tr").find(".delivery_fee").val("");
                    this_.closest("tr").find(".location").trigger("chosen:updated");

                }
            });
        });

        $(document).on('change', '.location',function(){
            var id = $(this).val();
            var this_ = $(this);

             $.ajax({
                type: 'GET',
                url: '{{ route("find_price_location") }}',
                dataType:'json',
                data: {
                    _token: '{{ csrf_token() }}',
                    id: id,
                },
                success: function (data) {
                    this_.closest("tr").find(".delivery_fee").val("");
                    this_.closest("tr").find('.delivery_fee').val(data);
                }
            });
        });



        $(document).on('change', '.delivery_option',function(){
            var id = $(this).val();
            var this_ = $(this);

             $.ajax({
                type: 'GET',
                url: '{{ route("find_price_bus") }}',
                dataType:'json',
                data: {
                    _token: '{{ csrf_token() }}',
                    id: id,
                },
                success: function (data) { 
                    this_.closest("tr").find(".taxi_price").val("");
                    this_.closest("tr").find('.taxi_price').val(data);
                }
            });
        });


        $(document).on('change', '.location',function(){
            var id = $(this).val();
            var this_ = $(this);

             $.ajax({
                type: 'GET',
                url: '{{ route("find_price_location") }}',
                dataType:'json',
                data: {
                    _token: '{{ csrf_token() }}',
                    id: id,
                },
                success: function (data) {
                    this_.closest("tr").find(".delivery_fee").val("");
                    this_.closest("tr").find('.delivery_fee').val(data);
                }
            });
        });


        

        $('.typeahead').keyup(function () {
            $('#ajax-loading').show();
            var value = $(this).val();
            $.ajax({
                url: "{{ route('autocomplete-find-category') }}",
                method: "post",
                data: {
                    value: value,
                    _token: '{{ csrf_token() }}',
                },
                dataType: 'json',
                success: function (response) {
                    $('#ajax-loading').hide();
                    console.log(response);
                    $('#autocomplete').html(response.html);
                }
            });
        });
        $('.typeahead').blur(function () {
            if($(this).val() == ""){
                $('#autocomplete').html("");
            }

         });
        $(document).on('click','.add-product',function(){
            var id = $(this).data('id');
            var n = ($('#resultbody tr').length - 0) + 1;
            $.ajax({
                url: "{{ Route('get_product-outstock') }}",
                method: "POST",
                dataType: "json",
                data: {
                    id: id,
                    _token: '{{ csrf_token() }}',
                },
                success: function (data) {
                    var div =   `
                        <tr>
                            <td>
                                <div class="result-body">
                                    <span class="fa fa-times-circle close btn-remove"></span>
                                    <input type="hidden" name="category_id[]" value="${data.id}" >
                                    <div class="col-md-10" >
                                        <div style="background: #{{Auth::user()->secondary_background}} !important; color: #ffffff; padding: 0px 12px;   font-size: 14px;   font-weight: bold;  line-height: 30px">
                                            <p> ${data.category_name} (Box ${n})   </p>
                                        </div>
                                    </div>
                                    <div class="col-md-2" >
                                        <div>
                                            <div class="form-group">
                                                {!! Form::select('driver_id[]',getDriver(), null, ['class' => 'form-control driver_id']) !!}
                                            </div>
                                        </div>
                                    </div>
                                 
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <input type="text"  value="" name="customer_receive[]" class="form-control"  placeholder="{{__('administrator.customer_receive')}}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            {!! Form::select('from_location[]',$from_location, null, ['class' => 'form-control from_location']) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            {!! Form::select('location[]',$location, null, ['class' => 'form-control location','required']) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            {!! Form::text('delivery_fee[]', null, array('placeholder' => __('administrator.delivery_fee'),'class' => 'delivery_fee form-control number-only','required')) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group height-27">
                                            <input type="hidden" value="1" name="delivery_status[]" class="delivery_status" >
                                            <div class="bt_action toggle btn btn-success btn-xs " data-toggle="toggle" style=" height: 30.5px;">
                                                <input data-id="1" data-size="mini"  class="toggle-class  " type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" data-off="InActive" checked="">
                                                <div class="toggle-group">
                                                    <label class= " data-id btn  btn-danger btn-xs  toggle-on" >{{__('administrator.pay_shop')}}</label>
                                                    <label class=" data-id btn btn-success btn-xs active toggle-off" >{{__('administrator.pay_customer')}}</label><span class="toggle-handle btn btn-default btn-xs"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 pay_or_paid">
                                        <div class="form-group height-27">
                                            <input type="hidden" value="pay" name="pay_or_paid[]" class="pay_or_paid" >
                                            <div class=" toggle_pay_or_paid toggle  btn btn-success btn-xs " data-toggle="toggle" style=" height: 30.5px;">
                                                <input data-id="1" data-size="mini"  class="toggle-class  " type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" data-off="InActive" checked="">
                                                <div class="toggle-group">
                                                    <label class= " data-id btn  btn-danger btn-xs  toggle-on" >{{__('administrator.pay')}}</label>
                                                    <label class=" data-id btn btn-success btn-xs active toggle-off" >{{__('administrator.paid')}}</label><span class="toggle-handle btn btn-default btn-xs"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            {!! Form::text('price[]', null, array('placeholder' => __('administrator.price'),'class' => 'chosen-select form-control number-only','required')) !!}
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <div class="form-group">
                                            {!! Form::select('delivery_option[]',$bus , null,  ['class' => 'form-control chosen-select delivery_option']) !!}
                                        </div>
                                    </div>

                                    <div class="col-md-2 taxi_price" style="display:none">
                                        <div class="form-group">
                                            {!! Form::text('taxi_price[]', null, array('placeholder' => __('administrator.taxi_price'),'class' => 'taxi_price form-control number-only ')) !!}
                                        </div>
                                    </div>

                                    <div class="col-md-3 taxi_number" style="display:none">
                                        <div class="form-group">
                                            {!! Form::text('taxi_number[]', null, array('placeholder' => __('administrator.taxi_number'),'class' => 'taxi_number form-control')) !!}
                                        </div>
                                    </div>

                                    <div class="col-md-2 taxi_status" style="display:none">
                                        <div class="form-group height-27">
                                            <input type="hidden" value="1" name="taxi_status[]" class="taxi_status" >
                                            <div class=" toggle_taxi_status toggle  btn btn-success btn-xs " data-toggle="toggle" style=" height: 30.5px;">
                                                <input data-id="1" data-size="mini"  class="toggle-class  " type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" data-off="InActive" checked="">
                                                <div class="toggle-group">
                                                    <label class= " data-id btn  btn-danger btn-xs  toggle-on" >{{__('administrator.pay_shop')}}</label>
                                                    <label class=" data-id btn btn-success btn-xs active toggle-off" >{{__('administrator.customer')}}</label><span class="toggle-handle btn btn-default btn-xs"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-2 " style="display:none">
                                        <div class="form-group height-27 taxi_pay_or_paid_div "  >
                                            <input type="hidden" value="pay" name="taxi_pay_or_paid[]" class="taxi_pay_or_paid" >
                                            <div class=" toggle_taxi_pay_or_paid toggle  btn btn-success btn-xs " data-toggle="toggle" style=" height: 30.5px;">
                                                <input data-id="1" data-size="mini"  class="toggle-class  " type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" data-off="InActive" checked="">
                                                <div class="toggle-group">
                                                    <label class= " data-id btn  btn-danger btn-xs  toggle-on" >{{__('administrator.pay')}}</label>
                                                    <label class=" data-id btn btn-success btn-xs active toggle-off" >{{__('administrator.paid')}}</label><span class="toggle-handle btn btn-default btn-xs"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group height-27">
                                            {!! Form::text('other_service_fee[]', null, array('placeholder' => __('administrator.other_service_fee'),'class' => 'other_service_fee number-only form-control')) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-2 other_service_type" style="display:none">
                                        <div class="form-group height-27">
                                            <input type="hidden" value="1" name="other_service_type[]" class="other_service_type" >
                                            <div class=" toggle_other_service_type toggle  btn btn-success btn-xs " data-toggle="toggle" style=" height: 30.5px;">
                                                <input data-id="1" data-size="mini"  class="toggle-class  " type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" data-off="InActive" checked="">
                                                <div class="toggle-group">
                                                    <label class= " data-id btn  btn-danger btn-xs  toggle-on" >{{__('administrator.pay_shop')}}</label>
                                                    <label class=" data-id btn btn-success btn-xs active toggle-off" >{{__('administrator.customer')}}</label><span class="toggle-handle btn btn-default btn-xs"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2" style="display:none">
                                        <div class="form-group  height-27 other_service_pay_or_paid_div">
                                            <input type="hidden" value="pay" name="other_service_pay_or_paid[]" class="other_service_pay_or_paid" >
                                            <div class=" toggle_other_service_pay_or_paid toggle  btn btn-success btn-xs " data-toggle="toggle" style=" height: 30.5px;">
                                                <input data-id="1" data-size="mini"  class="toggle-class  " type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" data-off="InActive" checked="">
                                                <div class="toggle-group">
                                                    <label class= " data-id btn  btn-danger btn-xs  toggle-on" >{{__('administrator.pay')}}</label>
                                                    <label class=" data-id btn btn-success btn-xs active toggle-off" >{{__('administrator.paid')}}</label><span class="toggle-handle btn btn-default btn-xs"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            {!! Form::text('date_delivery[]', date('d-m-Y'), array('placeholder' => __('administrator.date_delivery'),'class' => 'form-control date_picker')) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            {!! Form::text('description[]', null, array('placeholder' => __('administrator.description'),'class' => 'description form-control')) !!}
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    `;
                    {{--  var div =   `
                    <tr>
                        <td>
                            <div class="result-body">
                                <span class="fa fa-times-circle close btn-remove"></span>
                                <input type="hidden" name="category_id[]" value="${data.id}" >
                                <div class="col-md-10" >
                                    <div style="background: #{{Auth::user()->secondary_background}} !important; color: #ffffff; padding: 0px 12px;   font-size: 14px;   font-weight: bold;  line-height: 30px">
                                        <p> ${data.category_name} (Box ${n})   </p>
                                    </div>
                                </div>
                                <div class="col-md-2" >
                                    <div>
                                        <div class="form-group">
                                            {!! Form::select('driver_id[]',getDriver(), null, ['class' => 'form-control driver_id']) !!}
                                        </div>
                                    </div>
                                </div>
                              
                            </div>
                        </td>
                    </tr>
                `;  --}}

                    $('#resultbody').append(div);
                    $('select').select2();
                    $(".date_picker").datepicker({
                        dateFormat: "dd-mm-yy",
                        changeMonth: true,
                        changeYear: true,
                    });
                }
            });
        });


        // delivery fee
        $(document).on('click', '.bt_action','.toggle', function() {
            var status = $(this).hasClass( "off" ) == true ? 1 : 2;
           $(this).closest("tr").find(".delivery_status").val(status);
            $(this).toggleClass("off");
            var delivery_status = $('.delivery_status').val();
           if(delivery_status == 2){
               $(this).closest("tr").find(".toggle_pay_or_paid ").removeClass('off');
               $(this).closest("tr").find(".pay_or_paid").hide();
               $(this).closest("tr").find(".pay_or_paid").val('pay');
           }
           else{
            $(this).closest("tr").find('.pay_or_paid').show();
           }
        });

        $(document).on('click', '.toggle_pay_or_paid','.toggle', function() {
            var status = $(this).hasClass( "off" ) == true ? 'pay' : 'paid';
            $(this).closest("tr").find(".pay_or_paid").val(status);
            $(this).toggleClass("off");
        });
        // taxi fee
        $(document).on('click', '.toggle_taxi_status','.toggle', function() {
            var status = $(this).hasClass( "off" ) == true ? 1 : 2;
            if(status == 2){
                $($(this).closest("tr").find(".taxi_pay_or_paid_div").hide());
                $($(this).closest("tr").find(".taxi_pay_or_paid").val('pay'));
                $($(this).closest("tr").find(".toggle_taxi_pay_or_paid ").removeClass('off'));

            }else{
                $($(this).closest("tr").find(".taxi_pay_or_paid_div").show());
            }

            $($(this).closest("tr").find(".taxi_status").val(status));
            $(this).toggleClass("off");
            var taxi_status = $(this).closest('tr').find('.taxi_status').val();
           if(taxi_status == 2){
                $(this).closest('tr').find('.taxi_pay_or_paid').hide();
                $('.toggle_taxi_pay_or_paid').removeClass('off');
                $('.taxi_pay_or_paid').val('pay');
           }
           else{
            $(this).closest('tr').find('.taxi_pay_or_paid').show();
           }
        });

        $(document).on('click', '.toggle_taxi_pay_or_paid ','.toggle', function() {
            var status = $(this).hasClass( "off" ) == true ? 'pay' : 'paid';
            $($(this).closest("tr").find(".taxi_pay_or_paid").val(status));
            $(this).toggleClass("off");
        });
        // other service
        $(document).on('click', '.toggle_other_service_type','.toggle', function() {
            var status = $(this).hasClass( "off" ) == true ? 1 : 2;
            if(status == 2){
                $(this).closest('tr').find(".toggle_other_service_pay_or_paid").removeClass('off');
                $(this).closest("tr").find(".other_service_pay_or_paid_div").hide();
                $(this).closest("tr").find(".other_service_pay_or_paid").val('pay');
            }else{
                $(this).closest("tr").find(".other_service_pay_or_paid_div").show();
            }

            $(this).closest("tr").find(".other_service_type").val(status);
            $(this).toggleClass("off");

        });

        $(document).on('click', '.toggle_other_service_pay_or_paid','.toggle', function() {
            var status = $(this).hasClass( "off" ) == true ? 'pay' : 'paid';


            $($(this).closest("tr").find(".other_service_pay_or_paid").val(status));
            $(this).toggleClass("off");
        });

        $(document).on('change', '.delivery_option', function() {
            var bus = $(this).val();

           if(bus!='No'){

                $(this).closest('tr').find('.taxi_number').show();
                $(this).closest('tr').find('.taxi_price').show();
                $(this).closest('tr').find('.taxi_status').show();
                $(this).closest('tr').find('.taxi_pay_or_paid').show();
           }
           else{
               $(this).closest('tr').find('.taxi_number').val('').hide();
               $(this).closest('tr').find('.taxi_price').val('').hide();
               $(this).closest('tr').find('.taxi_status').hide();
               $(this).closest('tr').find('.taxi_status').val(1);
               $(this).closest('tr').find('.toggle_taxi_status ').removeClass('off');
               $(this).closest('tr').find('.taxi_pay_or_paid').hide();
               $(this).closest('tr').find('.taxi_pay_or_paid').val('pay');
               $(this).closest('tr').find('.toggle_taxi_pay_or_paid  ').removeClass('off');
           }

        });
        $(document).on('keyup', '.other_service_fee', function() {
            var other_service = $(this).val();
            // alert(other_service);
           if(other_service > 0 && other_service!= ''){

                $(this).closest('tr').find('.other_service_type').show();
                $(this).closest('tr').find('.other_service_pay_or_paid').show();
           }
           else{
                $(this).closest('tr').find('.other_service_type').hide();
                $(this).closest('tr').find('.other_service_type').val(1);
                $(this).closest('tr').find('.toggle_other_service_type  ').removeClass('off');
                $(this).closest('tr').find('.other_service_pay_or_paid').hide();
                $(this).closest('tr').find('.other_service_pay_or_paid').val('pay');
                $(this).closest('tr').find('.toggle_other_service_pay_or_paid  ').removeClass('off');

           }

        });

        </script>
@endsection


