@extends('layouts.app')
@section('content')
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="{{route('app_dashboard')}}">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('import-stock.index')}}">{{__('administrator.import_stock')}}</a></li>
            <li><a href="#" class="active">{{__('administrator.import_stock_details')}}</a></li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{__('administrator.import_stock_details')}}</h3>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table ">
                <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
                    <thead>
                        <tr>
                            <th width="1%">#</th>
                            <th width="15%">{{__('administrator.code')}} </th>
                            <th width="15%">{{__('administrator.name')}}</th>
                            <th width="15%">{{__('administrator.category')}}</th>
                            <th width="15%">{{__('administrator.quantity')}}</th>
                            <th width="15%">{{__('administrator.price')}}</th>
                            <th width="15%">{{__('administrator.total')}} </th>
                            <th width="15%">{{__('administrator.action')}} </th>
                        </tr>
                    </thead>
                    <thead>
                     @foreach($data as $key => $val)
                            <tr align="center">
                                <td>{{($key+1)}}</td>
                                <td>{{$val->barcode}}</td>
                                <td>{{$val->name_km}}</td>
                                <td>{{$val->category_name}}</td>
                                <td>{{$val->import_qty}}</td>
                                <td>{{'$'.$val->sale_price}}</td>
                                <?php $total  =  $val->sale_price * $val->import_qty ?>
                                <td>{{'$'.$total}}</td>
                                <td>
                                    @can('Edit Stock In')
                                        <button class="button_sm button_success" data-id="{{ $val->barcode }}"  data-import_qty="{{ $val->import_qty }}" type="button"><span class="fa fa-edit  "></span> </button>
                                    @endcan
                                    <button class="button_sm button_danger" data-id="{{ $val->barcode }}"  data-import_qty="{{ $val->import_qty }}" type="button"><span class="fa fa-trash  "></span> </button>
                                </td>
                            </tr>
                            @endforeach
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>

        </div>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).on('click','.button_danger',function(){
            var import_qty = $(this).data('import_qty');
            var id = $(this).data('id');
            var merchant_id = '{{ $merchant_id }}' ;
            var invoice = '{{ $invoice }}' ;
            var this_  = $(this);
            $.confirm({
                title: 'Delete',
                theme: 'bootstrap',
                closeIcon: true,
                animation: 'scale',
                type: 'orange',
                content: '',
                buttons: {
                    បិទ: function () {

                    },
                    យល់ព្រម: function () {

                        $.ajax({
                            type: 'POST',
                            url: '{{ route("import_stock_delete") }}',
                            dataType:'text',
                            data: {
                                _token: '{{ csrf_token() }}',
                                import_qty: import_qty,
                                id: id,
                                invoice: invoice,
                                merchant_id:merchant_id
                            },
                            success: function (data) {
                                if(data == 'successfully'){
                                    location.reload();

                                }else if(data == 'not success'){
                                    $.alert('មិនអាចលុប');
                                }
                                else{

                                }

                            }
                        });
                    },
                },
            });
        });


        $(document).on('click','.button_success',function(){
            var import_qty = $(this).data('import_qty');
            var id = $(this).data('id');
            var merchant_id = '{{ $merchant_id }}' ;
            var invoice = '{{ $invoice }}' ;
            var this_  = $(this);
            $.confirm({
                title: 'Edit',
                theme: 'bootstrap',
                closeIcon: true,
                animation: 'scale',
                type: 'orange',
                content: `
                    <form action="" class="formName">
                        <div class="form-group">
                            <div class="row">
                                <div class="col-sm-12 col-xs-12">
                                    <input type="text" name="qty" value="${import_qty}" class="form-control number-only" required placeholder="qty">
                                </div>
                            </div>
                        </div>
                    </form>`,
                buttons: {
                    បិទ: function () {

                    },
                    យល់ព្រម: function () {
                        var qty =$('input[name="qty"]').val();

                        if(qty == ''){
                            $.alert('Select To Driver');
                            return false;
                        }
                        $.ajax({
                            type: 'POST',
                            url: '{{ route("import_stock_update") }}',
                            dataType:'text',
                            data: {
                                _token: '{{ csrf_token() }}',
                                qty: qty,
                                id: id,
                                invoice: invoice,
                                merchant_id:merchant_id
                            },
                            success: function (data) {
                                if(data == 'successfully'){
                                    location.reload();

                                }else if(data == 'not success'){
                                    $.alert('ស្តុកមិនកគ្រប់គ្រាន់');
                                }
                                else{

                                }

                            }
                        });
                    },
                },
            });

        });
    </script>
@endsection




