@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li><a href="#">{{__('administrator.customer_stock')}}</a></li>
	  <li class="active">{{__('administrator.import_stock')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> {{__('administrator.import_stock')}}</h3>
	                </div>
	                <div class="pull-right">
	                   <a href="{{route('import-stock.create')}}" class="button_sm button_info"><span class="fa fa-plus"></span> {{__('administrator.create_new')}}</a>
	                </div>
	            </div>
	        </div>
	    </div>
    </div>
    <div class="wrapper-table ">
        <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
            <thead>
            <tr>
                <th>{{__('administrator.no')}}</th>
                <th>{{__('administrator.date')}}</th>
                <th>{{__('administrator.user')}}</th>
                <th>{{__('administrator.shop_name')}}</th>
                <th>{{__('administrator.transaction_number')}}</th>
                <th>{{__('administrator.action')}}</th>
            </tr>
            <tbody class="tbody">

            </tbody>

        </table>
    </div>
</div>


@endsection



@section('script')
<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('click','.btn-danger',function(){
            var transaction_number = $(this).data('transaction_number') ;
            var merchant_id = $(this).data('merchant_id') ;
            var this_  = $(this) ;
            $.confirm({
                title: 'Delete',
                theme: 'bootstrap',
                closeIcon: true,
                animation: 'scale',
                type: 'orange',
                content: '',
                buttons: {
                    បិទ: function () {

                    },
                    យល់ព្រម: function () {

                        $.ajax({
                            type: 'POST',
                            url: '{{ route("import_stock_main_delete") }}',
                            dataType:'text',
                            data: {
                                _token: '{{ csrf_token() }}',
                                transaction_number: transaction_number,
                                merchant_id: merchant_id,
                            },
                            success: function (data) {
                                if(data == 'successfully'){
                                    location.reload();

                                }else if(data == 'not success'){
                                    $.alert('មិនអាចលុប');
                                }
                                else{

                                }

                            }
                        });
                    },
                },
            });
        });
        $('#datatable_location').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax: "{{route('import-stock.index')}}",
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'import_date'},
                    {data: 'name'},
                    {data: 'shop_name'},
                    {data: 'transaction_number'},
                    {data: 'action'},
                ],

            "initComplete": function (settings, json) {
            }
        });
    });

</script>
@stop



