@extends('layouts.app') @section('content')
 <?php Fun::lang() ?>
<div class="top-header">
    <ol class="breadcrumb">
      <li><a href="#">{{__('administrator.dashboard')}}</a></li>
      <li><a href="{{route('category.index')}}">{{__('administrator.sale')}}</a></li>
      <li class="active"><a href="{{route('category.index')}}">{{__('administrator.add_sale')}}</a></li>
    </ol>
</div>
<div class="page-purchases">
    <div class="preview">
        {!! Form::model($data, ['method' => 'PATCH','route' => ['import-stock.update', $data->id]]) !!}
        <div class="col-sm-12 paddin-12">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::select('merchant_id', $merchant, null, ['class' => 'form-control chosen-select']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <input type="text" name="date" value="{{$data->import_date}}" class="form-control date_picker" required>
                    </div>
                </div>
            </div>

            <div class="check-bill">
                <div class="row">
                    <div class="check-bill-table">
                        <div class="product-view-table">
                            <div class="tbl-header">
                                <table width="100%" class="table table-striped">
                                    <thead class="text-center">
                                        <tr>
                                            <th width="15%">{{__('administrator.code')}}<span class="required">*</span></th>
                                            <th width="15%">{{__('administrator.name')}}<span class="required">* </span></th>
                                            <th width="15%">{{__('administrator.category')}}<span class="required">* </span></th>
                                            <th width="15%">{{__('administrator.quantity')}}<span class="required">* </span></th>
                                            <th width="15%">{{__('administrator.price')}}<span class="required">* </span></th>
                                            <th width="15%">{{__('administrator.total')}}<span class="required"></span></th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            <div class="tbl-content">
                                <div class="overflow">
                                    <table width="100%" class="table table-striped">
                                        <tbody class="resultbody">
                                            <tr >

                                                <td width="16%">
                                                    <input type="text" name="barcode" class="form-control barcode" value=" {{$data->barcode}}" readonly>
                                                </td>
                                                <td width="16%">
                                                    <input type="text" name="product_name" class="form-control all_key product_name"  value="{{$data->name_km}} " readonly>
                                                </td>
                                                <td width="16%">
                                                    <input type="text" name="category_name" class="form-control all_key   category_name" value="{{$data->category_name}} " readonly>
                                                </td>
                                                <td width="16%">
                                                    {!! Form::number('import_qty',null, array('placeholder' =>  '','class' => 'form-control number-only  stockin_qty ','required','number-only')) !!}
                                                </td>
                                                <td width="16%">
                                                    {!! Form::number('sale_price', null, array('placeholder' =>  '','class' => 'form-control number-only  price','required','number-only',)) !!}
                                                </td>
                                                <td width="14%">
                                                    {!! Form::number('total', $total, array('placeholder' =>  '','class' => 'form-control total','required','number-only','readonly')) !!}

                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="blog-payment ">
                        <div class="col-sm-12 ">
                            <div class="button_payment pull-right">
                                <button type="button" class="button_warning button_lg" onclick="history.back(1)">{{__('administrator.back')}}</button>
                                <button type="submit" class="button_info button_lg">{{__('administrator.save')}}</button>

                            </div>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>

        <style type="text/css">
            table {
                width: 100%;
                table-layout: fixed;
                border-collapse: collapse;
                margin-bottom: 0 !important;
            }

            th,
            td {
                width: 100% !important;
            }

            .tbl-content {
                height: 350px;
                overflow-x: auto;
                overflow-y: auto;
                margin-top: 0px;
            }

            ::-webkit-scrollbar {
                width: 6px;
            }

            ::-webkit-scrollbar-track {
                -webkit-box-shadow: inset 0 0 6px rgba(0, 0, 0, 0.3);
            }

            ::-webkit-scrollbar-thumb {
                -webkit-box-shadow: inset 0 0 6px rgba(0, 0, 0, 0.3);
            }
        </style>
    @endsection
    @section('script')
    <script type="text/javascript">




        $(document).on('keyup','.number-only',function(){
            var qty = parseFloat($(this).closest("tr").find(".stockin_qty").val());
            var price = parseFloat($(this).closest("tr").find(".price").val());
            var total = qty * price;
            $(this).closest("tr").find(".total").val(total);
        });


        </script>
@endsection
