@extends('layouts.app') @section('content')
<?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="{{route('app_dashboard')}}">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('location.index')}}">{{__('administrator.location')}}</a></li>
            <li><a href=""​ class="active">{{__('administrator.edit')}}</a></li>
        </ol>
    </div>
    <div class="page">
        <div class=container>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{__('administrator.location')}}</h3>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            {!! Form::model($location, ['method' => 'PATCH','route' => ['location.update', $location->id]]) !!}
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form">
                        <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.location')}} <i>( {{__('administrator.fields_in_red_are_required')}} )</i></h3>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">{{__('administrator.zone')}} (EN) </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('name_en', null, array('placeholder' =>__('administrator.zone'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">{{__('administrator.zone')}} (KM) </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('name_km', null, array('placeholder' =>__('administrator.zone'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label for="name">{{__('administrator.description')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::textarea('description',null, array('placeholder' =>__('administrator.description'),'class' => 'form-control', 'rows'=>'2')) !!}
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>
@endsection
