@extends('layouts.app')
@section('content')
<?php Fun::lang()?>

<style>
    .select2-container.select2-container--default.select2-container--open {
        z-index: 99999999;
    }
</style>
<div class="top-header">
	<ol class="breadcrumb">
      <li><a href="/">{{__('administrator.dashboard')}}</a></li>

	  <li class="active">{{__('administrator.completed')}}</li>
	</ol>
</div>

<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> {{__('administrator.completed')}}</h3>
                    </div>
	            </div>
	        </div>
	    </div>
    </div>

    <div class="form-search">       
        <div class="form-group col-sm-2 col-xs-3">
            {!! Form::select('driver_id', getDriver(), null, ['class' => 'form-control driver_id']) !!}
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
            <thead>
            <tr>
                <th width="1%">#</th>
                <th width="5%">{{__('administrator.date')}}                 </th>
                <th width="5%">{{__('administrator.box_code')}}             </th>
                <th width="5%">{{__('administrator.driver_name')}}          </th>
                <th width="5%">{{__('administrator.shop_name')}}            </th>
                <th width="5%">{{__('administrator.location')}}             </th>
                <th width="5%">{{__('administrator.customer_receive')}}     </th>
                <th width="5%">{{__('administrator.product_price')}}        </th>
                <th width="5%">{{__('administrator.delivery_fee') }}        </th>
                <th width="5%">{{__('administrator.other_service_fee') }}   </th>
                <th width="5%">{{__('administrator.price_of_car')}}         </th>
                <th width="5%">{{__('administrator.total_collection')}}         </th>

                
                <th width="5%">{{__('administrator.description')}}          </th>
                <th width="5%">{{__('administrator.action')}}               </th> 
            </tr>
            <tbody class="tbody">

            </tbody>

        </table>
    </div>
</div>
 

@endsection
@section('script')<script type="text/javascript">

    $(document).on('click','.return_to_inpro',function(){
        var export_id = $(this).data('export_id');
        var status = 1 ;
        $.confirm({
            title: '',
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'purple',
            content: 'ត្រឡប់កំពុង​ដំណើរការវិញ​!',
            buttons: {
                បិទ: function () {

                },
                យល់ព្រម: function () {
                    location.href = "/nso/delivery-return-in-processing/"+export_id+"/"+status ;
                },
            },
        });
    });

    $(document).on('change','.driver_id',function(){
        dataTableAjax();
    });

    $(document).on('click','.change-driver',function(){

        let export_id = $(this).data('export_id');
        let driver_id = $(this).data('driver_id');
        let delivery_date = $(this).data('delivery_date');
        $.confirm({
            title: 'Change Driver!',
            content: '' +
            '<form action="" class="formName">' +
                '<div class="form-group">' +
                    '<label>Select Driver</label>' +
                    `
                        {!! Form::select('driver_id', getDriver(), null, ['class' => 'form-control chosen-select','id'=>'driver_id','required']) !!}
                    ` +
                '</div>' +
            '</form>',
            buttons: {
                cancel: function () {
                    //close
                },
                formSubmit: {
                    text: 'Submit',
                    btnClass: 'btn-blue',
                    action: function () {
                        var driver_id = this.$content.find('#driver_id').val();
                        if(!driver_id){
                            $.alert('provide a valid driver_id');
                            return false;
                        }
                        $.ajax({
                            url: "{{route('delivery.change-driver')}}",
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                driver_id: driver_id,
                                delivery_date,delivery_date,
                                export_id,export_id,
                                _token: '{{ csrf_token() }}',
                            },
                            success: function(response) {
                                if (response.success == true) {
                                    $('#datatable_location').DataTable().ajax.reload();
                                } else {
                                    $.alert({
                                        title: "Error",
                                        content: response.error,
                                        buttons: {
                                            formSubmit: {
                                                text: 'Submit',
                                                btnClass: 'btn-blue',
                                                action: function () {
                                                    $('#datatable_location').DataTable().ajax.reload();
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                },
            },
            onContentReady: function () {
                // bind to events
                $('select').select2();
                this.$content.find('#driver_id').val(driver_id).trigger('change');
                var jc = this;
                this.$content.find('form').on('submit', function (e) {
                    // if the user submits the form by pressing enter in the field.
                    e.preventDefault();
                    jc.$$formSubmit.trigger('click'); // reference the button and click it
                });
            }
        });
    });
 

    $(document).ready(function(){
        dataTableAjax();
    });

    function dataTableAjax(){

        let driver_id = $('.driver_id').val();
        $('#datatable_location').DataTable().destroy();
        $('#datatable_location').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst"    : "{{__('administrator.first')}}",
                    "sLast"     : "{{__('administrator.last')}}",
                    "sNext"     : "{{__('administrator.next')}}",
                    "sPrevious" : "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            bLengthChange:false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax:{
                url: "{{ route('list_delivery_seccess') }}",
                data:{
                    driver_id:driver_id, 
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'                    ,  'searchable': false},
                    {data: 'delivery_date'                  ,   name:  'nso007_delivery_order.delivery_date'            ,  'searchable': true},
                    {data: 'box_code'                       ,   name:  'nso007_export_stock.box_code'                   ,  'searchable': true},
                    {data: 'driver_name'                    ,   name:  'nso007_delivery_order.driver_name'              ,  'searchable': true},
                    {data: 'shop_name'                      ,   name:  'nso007_export_stock.shop_name'                  ,  'searchable': true},
                    {data: 'location_name'                  ,   name:  'nso007_export_stock.location_name'              ,  'searchable': true},
                    {data: 'customer_receive'               ,   name:  'nso007_export_stock.customer_receive'           ,  'searchable': true},
                    {data: 'total_price'                    ,  'searchable': false},
                    {data: 'delivery_fee'                   ,  'searchable': false},
                    {data: 'other_services_fee'             ,  'searchable': false},
                    {data: 'buy_fee'                        ,  'searchable': false},
                    {data: 'total_collection'           ,  'searchable': false},
                    {data: 'description'                    ,  'searchable': false},
                    {data: 'action'                         ,  'searchable': false},
                ],
            "initComplete": function (settings, json) {
            }
        });
    }
</script>
@stop



