


<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Menu</title>

	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css">
	<link rel="stylesheet" href="css/stylemobile.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<style>
    . 
	.container{
		background: #f2f2f2;
	}
	.main-Receipt{
		width: 100%                                                                                                                                       ;
		height: auto;
		float: left;
		margin:20px 0px;
		background: #ffffff;
        padding: 8px;
        border: 1px solid #000;
	}
	.main-Receipt .show-Receipt{
		width: 40px;
		float: left;
		margin: 10px;
	}
	.main-Receipt .show-Receipt img{
		margin-bottom: 10px;
		width: 100%;
	}
	.main-Receipt  .desc-logo{
		width: 70%;
		float: right;
		text-align: center;
	}
	.main-Receipt .Receipt-right p,
	.main-Receipt .Receipt-right h4,
	.main-Receipt .desc-logo p,
	.main-Receipt .desc-logo h4{
		margin: 0px;

	}
	.main-Receipt .desc-logo h4{font-size: 14px;font-weight: bold;}
	.border-green{
		width:100%;
		float: left;
		border:1px solid green;
	}
	.main-Receipt .Receipt-right{
		width:35%;
		float: right;
		text-align: right;
		margin-top: 2px;
		margin-right: 10px;
	}
	.main-Receipt .Receipt-left{
		width: 35%;
		float: left;
		margin-top: 6px;
	}
	.main-Receipt  .receipt-img{
		width: 50px;
		height: 50px;
		float: right;
		margin-top: 6px;
	}
	.main-Receipt  .receipt-img img{
		width: 100%;
		height: 100%;
	}
	.main-Receipt .Receipt-left .receipt-desc h4,
	.main-Receipt .Receipt-right h4{margin: 0px;font-size: 10px;font-weight: bold;}
	.main-Receipt .Receipt-left .receipt-desc{
		width: 100%;
		float: left;
		/*margin-left: 10px;*/
	}
	.main-Receipt .desc-logo p,
	.main-Receipt .Receipt-right p,
	.main-Receipt .Receipt-left .receipt-desc h5,
	.main-Receipt .Receipt-left .receipt-desc p{
		margin: 0px;
		font-size: 10px;
	}
	.main-Receipt .Receipt-left .receipt-desc h5{font-weight: bold;}
	.main-Receipt .item-product{
		width: 100%;
		float: left;
		margin-top: 2px;
	}
	.main-Receipt .item-product .table{
		margin-bottom: 0px;
	}
	.main-Receipt .item-product .table tbody tr td:last-child,
	.main-Receipt .item-product .table thead tr th:last-child{
		text-align: right;
	}
	.main-Receipt .item-product .table thead tr th,
	.main-Receipt .item-product .table tbody tr th,
	.main-Receipt .item-product .table tbody tr td{
		border-bottom: 1px solid #ddd;
        padding: 0px;
        font-size: 10px;
	}
	.main-Receipt .item-product .table tbody tr th,
	.main-Receipt .item-product .table tbody tr td{font-style: italic;}
	.item-subtotal{
		width: 100%;
		float: left;
	}
	.item-subtotal .item-left{
		width: 50%;
		float: left;
	}
	.item-subtotal .item-right{
		width: 50%;
		float: right ;
		text-align: right;
	}
    .item-subtotal .item-right h5{font-weight: bold;}
    .h5, h5 {
        font-size: 10px;
	}
    .delivery-invoice p{
        font-size: 10px;
    }
	@media print{
		.main-Receipt{
			/* margin-left: -7px; */
			border:none;
		}
	}
</style>
<body>
    <?php
    $branch = DB::table('nso007_branch')->find(1);
    $total_price  = 0;
    $total        = 0;
    $delivery_note = '';
?>
<div class="container1">
	<div class="main-Receipt">
		<div class="show-Receipt">
            <img src="{{asset('images/logo.png')}}" alt="Logo">
		</div>
		<div class="desc-logo">
			<h4>{{ $branch->company_name }}</h4>
            <p>{{ str_limit($branch->address, $limit = 31, $end = '') }} </p>
            <p>Facebook page : {{ $branch->facebook_page }}</p>
			<p>{{ $branch->phone }}</p>
		</div>
		<div class="border-green"></div>
		<div class="receipt-img">
            {!! QrCode::size(45)->generate($data[0]->box_code); !!}

		</div>
		<div class="Receipt-right">
			<h4>អ្នកទទួល</h4>
			<p>លេខទូរស័ព្ទ : {{ $data[0]->customer_receive }}</p>
			<p>ទីតាំង​ : {{ $data[0]->location_name }}</p>
			<p>កាលបរិច្ឆេទ : {{ date('d-m-Y') }}</p>
		</div>
		<div class="Receipt-left">
			<div class="receipt-desc">
                <h4>ផ្ញើរពី</h4>

				<h5>ឈ្មោះហាង : {{ $data[0]->shop_name }}</h5>
				<p>លេខហាង : {{ $data[0]->phone }}</p>
                <?php
                    if($data[0]->delivery_option != ''){
                        echo  '
                            <p>ផ្ញើរតាម : '.$data[0]->delivery_option.'    </p>
                            ' ;
                    }
                ?>​
				{{-- <p>{{ $data[0]->location_name }}</p> --}}

			</div>
		</div>
		<div class="item-product">
			<table class="table">
			  <thead>
			    <tr>
			      <th scope="col">ល.រ</th>
			      <th scope="col">បរិយាយ</th>
			      <th scope="col">តម្លៃ</th>
			    </tr>
			  </thead>
			  <tbody>
                @foreach($data as $key => $value)
                    <?php
                        $total_price += ($value->price * $value->export_qty )  ;
                    ?>
                    <tr>
                        <th scope="row">{{$key+1}}</th>
                        <td>{{$value->items}} (x{{$value->export_qty}}) </td>
                        <td>{{ '$'.number_format( $value->price * $value->export_qty,2) }}</td>
                    </tr>
                @endforeach
        
			  </tbody>
			</table>
        </div>
		   
		 
		<?php
			$delivery_fee = 0;
			$delivery_fee_show = 0;
            $total = 0;
            if($data[0]->delivery_status == 1 ){ 
				if($data[0]->discount_type != null || $data[0]->discount_type != ''){
					if($data[0]->discount_type  == 1){   // $
						$delivery_fee = $data[0]->discount;
					}
					else{
						$delivery_fee = ( (100 - $data[0]->discount) * $data[0]->delivery_fee ) / 100; 	
					} 
				}
				else{
					$delivery_fee = $data[0]->delivery_fee ;
				} 
                $total  =  $total_price  ;
            }else{
				if($data[0]->discount_type != null || $data[0]->discount_type != ''){
					if($data[0]->discount_type  == 1){   // $
						$delivery_fee = $data[0]->discount;
					}
					else{
						$delivery_fee = ( (100 - $data[0]->discount) * $data[0]->delivery_fee ) / 100; 	
					} 
				}
				else{
					$delivery_fee = $data[0]->delivery_fee ;
				} 
                $total  =  $total_price + $delivery_fee;
			}
			 
        ?>
		<div class="item-subtotal">
			<div class="item-left">
				<h5>Delivery Fee:
                    <?php
                     if ($data[0]->delivery_status == 1)
                        echo '<strike>'.number_format( $delivery_fee,2).'</strike>' ;
                    else
                        echo number_format( $delivery_fee,2)
                    ?>
                </h5>
			</div>
			<div class="item-right">
				<h5>Total: {{ '$'.number_format( $total,2) }}</h5>
			</div>
        </div>
        <?php

        if($data[0]->delivery_status == 1 ){    
            $delivery_note  = 'យកសេវាដឹកជញ្ជូនយកខាងហាង';
            
        }
        else{
            $delivery_note  = 'សេវាដឹកជញ្ជូនខាងអ្នកទទួល' ;
        }

    ?>
        <div class="row">
            <div class="col-sm-12">
                <h4 style="font-size:14px;float:left"><u>ចំណាំ:</u></h4>
            </div>
        </div>

        <div class="row">
            <div class="delivery-invoice">
                <p  class="text-left note" >​ -  {{  $delivery_note  }}  <br>
                    -   រាល់ឥវ៉ាន់ខុសច្បាប់ម្ចាស់ឥវ៉ាន់ជាអ្នកទទួលខុសត្រូវ។  <br>
                    -   អគុណសម្រាប់ការប្រើប្រាស់សេវាកម្មយើងខ្ញុំ។  <br>
                @if ($description!=null)
                   ​-  {{$description}} ។
                    
                @endif
                </p>
            </div>

        </div>
	</div>
</div>


<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.0/jquery.min.js"></script>
</body>
</html>





